/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(uz.class, (Class[])new Class[]{Map.class});

    public static vz toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> ux.b;
                case 1 -> ux.c;
                default -> ux.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return vs.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return ve.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return vh.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return vc.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return va.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new uw(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new vd(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new vg(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return vx.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return vb.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(vz nmsTag) {
        if (nmsTag instanceof ux) {
            ux nmsByteTag = (ux)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.n());
        }
        if (nmsTag instanceof vs) {
            vs nmsShortTag = (vs)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.n());
        }
        if (nmsTag instanceof ve) {
            ve nmsIntTag = (ve)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.n());
        }
        if (nmsTag instanceof vh) {
            vh nmsLongTag = (vh)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.n());
        }
        if (nmsTag instanceof vc) {
            vc nmsFloatTag = (vc)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.n());
        }
        if (nmsTag instanceof va) {
            va nmsDoubleTag = (va)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.n());
        }
        if (nmsTag instanceof uw) {
            uw nmsByteArrayTag = (uw)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.e());
        }
        if (nmsTag instanceof vd) {
            vd nmsIntArrayTag = (vd)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.g());
        }
        if (nmsTag instanceof vg) {
            vg nmsLongArrayTag = (vg)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.g());
        }
        if (nmsTag instanceof vx) {
            vx nmsStringTag = (vx)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.k());
        }
        if (nmsTag instanceof vf) {
            vf nmsListTag = (vf)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof uz) {
            uz nmsCompoundTag = (uz)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof vb) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.c().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(vf nmsListTag) {
        ListBinaryTag.Builder builder = ListBinaryTag.heterogeneousListBinaryTag((int)nmsListTag.size());
        for (vz nmsValue : nmsListTag) {
            builder.add(NBTAdapter.toAPI(nmsValue));
        }
        return builder.build();
    }

    public static vf toNMS(ListBinaryTag listTag) {
        ArrayList<vz> nmsTags = new ArrayList<vz>(listTag.size());
        for (BinaryTag value : listTag) {
            nmsTags.add(NBTAdapter.toNMS(value));
        }
        return new vf(nmsTags);
    }

    public static CompoundBinaryTag toAPI(uz nmsCompoundTag) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder((int)nmsCompoundTag.i());
        for (Map.Entry nmsEntry : nmsCompoundTag.g()) {
            builder.put((String)nmsEntry.getKey(), NBTAdapter.toAPI((vz)nmsEntry.getValue()));
        }
        return builder.build();
    }

    public static uz toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, vz> nmsTags = new HashMap<String, vz>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

