/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.NBTAdapter;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.advancements.criterion.CriterionConditionBlock;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(Item.class).get(ReflectionMappingsInfo.Item_components, DataComponentMap.class);
    public static final Field RecipeManager_featureFlagSet = ReflectionHelper.getFields(CraftingManager.class).getFirstOfType(FeatureFlagSet.class);
    public Object recipeManagerFeatureFlagSetCache = null;
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(AdventureModePredicate.class).get(ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static RecipeHolder<?> getNMSRecipe(NamespacedKey key) {
        ResourceKey nmsKey = ResourceKey.a((ResourceKey)Registries.bK, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aJ().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            Item nmsItem = (Item)BuiltInRegistries.h.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            DataComponentMap currentComponents = nmsItem.f();
            Item_components.set(nmsItem, DataComponentMap.a((DataComponentMap)currentComponents, (DataComponentMap)DataComponentMap.a().a(DataComponents.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static CraftingManager getRecipeManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aJ();
    }

    public static NBTTagCompound serializeNmsItem(net.minecraft.world.item.ItemStack nmsItem) {
        return (NBTTagCompound)net.minecraft.world.item.ItemStack.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)nmsItem).getOrThrow();
    }

    public static net.minecraft.world.item.ItemStack parseNmsItem(NBTTagCompound nmsTag) {
        return (net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)nmsTag).getOrThrow();
    }

    public void blockRecipeFinalization() {
        try {
            CraftingManager manager = ItemHelperImpl.getRecipeManager();
            Object flags = RecipeManager_featureFlagSet.get(manager);
            if (flags != null) {
                this.recipeManagerFeatureFlagSetCache = flags;
                RecipeManager_featureFlagSet.set(manager, null);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreRecipeFinalization() {
        try {
            CraftingManager manager = ItemHelperImpl.getRecipeManager();
            if (this.recipeManagerFeatureFlagSetCache != null) {
                RecipeManager_featureFlagSet.set(manager, this.recipeManagerFeatureFlagSetCache);
                manager.finalizeRecipeLoading();
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void removeRecipes(List<NamespacedKey> keys) {
        this.blockRecipeFinalization();
        CraftingManager manager = ItemHelperImpl.getRecipeManager();
        for (NamespacedKey key : keys) {
            ResourceKey nmsKey = ResourceKey.a((ResourceKey)Registries.bK, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
            manager.removeRecipe(nmsKey);
        }
        this.restoreRecipeFinalization();
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bs().b(new net.minecraft.world.item.ItemStack((IMaterial)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static RecipeItemStack itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return RecipeItemStack.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return RecipeItemStack.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static ResourceKey<IRecipe<?>> createRecipeKey(String name) {
        return ResourceKey.a((ResourceKey)Registries.bK, (MinecraftKey)MinecraftKey.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        CookingBookCategory categoryValue;
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        CookingBookCategory cookingBookCategory = categoryValue = category == null ? CookingBookCategory.c : CookingBookCategory.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new RecipeSmoking(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new RecipeBlasting(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new RecipeCampfire(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new net.minecraft.world.item.crafting.FurnaceRecipe(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        RecipeStonecutting recipe = new RecipeStonecutting(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        RecipeItemStack templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        RecipeItemStack baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        RecipeItemStack upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<RecipeItemStack> ingredientList = new ArrayList<RecipeItemStack>();
        CraftingBookCategory categoryValue = category == null ? CraftingBookCategory.d : CraftingBookCategory.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)NonNullList.a(null, (Object[])ingredientList.toArray(new RecipeItemStack[0])));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerOtherRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            CraftRecipe craft;
            toAdd = craft = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)((ShapedRecipe)recipe));
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)((ShapelessRecipe)recipe));
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)((FurnaceRecipe)recipe));
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)((BlastingRecipe)recipe));
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)((CampfireRecipe)recipe));
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)((SmokingRecipe)recipe));
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)((StonecuttingRecipe)recipe));
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)((SmithingTransformRecipe)recipe));
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)((SmithingTrimRecipe)recipe));
        } else {
            if (!(recipe instanceof TransmuteRecipe)) {
                if (recipe instanceof ComplexRecipe) {
                    throw new UnsupportedOperationException("Cannot add custom complex recipe");
                }
                return;
            }
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)((TransmuteRecipe)recipe));
        }
        toAdd.addToCraftingManager();
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).K().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public JsonObject getRawHoverComponentsJson(ItemStack item) {
        DataComponentPatch nmsComponents = CraftItemStack.asNMSCopy((ItemStack)item).d();
        if (nmsComponents.d()) {
            return null;
        }
        return ((JsonElement)DataComponentPatch.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)nmsComponents).getOrThrow()).getAsJsonObject();
    }

    public ItemStack applyRawHoverComponentsJson(ItemStack item, JsonObject components) {
        return (ItemStack)DataComponentPatch.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)components).mapOrElse(nmsComponents -> {
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b(nmsComponents);
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItem);
        }, error -> {
            Debug.echoError((String)("Invalid hover item data '" + String.valueOf(components) + "': " + error.message()));
            return item;
        });
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        ResolvableProfile profile = (ResolvableProfile)itemStack.a(DataComponents.ar);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.b().properties().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.d().orElse(null), ProfileEditorImpl.getUUID(profile), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(DataComponents.ar, (Object)ResolvableProfile.a((GameProfile)gameProfile));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, BinaryTag value) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(DataComponents.b, (Object)CustomData.a, customData -> customData.a(nmsCompoundTag -> nmsCompoundTag.a(key, NBTAdapter.toNMS(value))));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public CompoundBinaryTag getNbtData(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return NBTAdapter.toAPI(ItemHelperImpl.serializeNmsItem(nmsItemStack));
        }
        return CompoundBinaryTag.empty();
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundBinaryTag compoundTag) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ItemHelperImpl.parseNmsItem(NBTAdapter.toNMS(compoundTag)));
    }

    public CompoundBinaryTag getCustomData(ItemStack item) {
        CustomData customData = (CustomData)CraftItemStack.asNMSCopy((ItemStack)item).a(DataComponents.b);
        return customData != null ? NBTAdapter.toAPI(customData.b()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundBinaryTag data) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.e(DataComponents.b);
        } else {
            nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)NBTAdapter.toNMS(data)));
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundBinaryTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        NBTTagCompound nmsOldTag = new NBTTagCompound();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (NBTBase)NBTAdapter.toNMS(oldTag));
        NBTTagCompound nmsUpdatedTag = (NBTTagCompound)MinecraftServer.getServer().M.update(DataConverterTypes.x, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        NBTTagCompound nmsCurrentTag = ItemHelperImpl.serializeNmsItem(CraftItemStack.asNMSCopy((ItemStack)item));
        NBTTagCompound nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ItemHelperImpl.parseNmsItem(nmsMergedTag));
    }

    public CompoundBinaryTag getEntityData(ItemStack item) {
        TypedEntityData entityData = (TypedEntityData)CraftItemStack.asNMSCopy((ItemStack)item).a(DataComponents.af);
        return entityData != null ? NBTAdapter.toAPI(entityData.b()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundBinaryTag entityNbt, EntityType entityType) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (entityNbt == null || entityNbt.isEmpty() || entityNbt.size() == 1 && entityNbt.contains("id")) {
            nmsItemStack.e(DataComponents.af);
        } else {
            NBTTagCompound nmsEntityNbt = NBTAdapter.toNMS(entityNbt);
            nmsEntityNbt.r("id");
            nmsItemStack.b(DataComponents.af, (Object)TypedEntityData.a((Object)CraftEntityType.bukkitToMinecraft((EntityType)entityType), (NBTTagCompound)nmsEntityNbt));
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        DataComponentPatch patch = nmsItemStack.d();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                MinecraftKey componentId = BuiltInRegistries.am.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        RegistryOps registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a);
        NBTTagCompound nmsPatch = (NBTTagCompound)DataComponentPatch.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.nbtTagToObject((BinaryTag)NBTAdapter.toAPI(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        CompoundBinaryTag rawComponents = (CompoundBinaryTag)ItemRawNBT.convertObjectToNbt((ObjectTag)rawComponentsMap, (TagContext)CoreUtilities.errorButNoDebugContext, (String)"");
        NBTTagCompound nmsRawComponents = NBTAdapter.toNMS(rawComponents);
        RegistryOps registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a);
        if (dataVersion < currentDataVersion) {
            NBTTagCompound legacyItemData = new NBTTagCompound();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (NBTBase)nmsRawComponents);
            NBTTagCompound nmsUpdatedTag = (NBTTagCompound)MinecraftServer.getServer().M.update(DataConverterTypes.x, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.m("components").orElseGet(NBTTagCompound::new);
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        DataComponentPatch.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((net.minecraft.world.item.ItemStack)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.p);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.p, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.q);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.q, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, DataComponentType<AdventureModePredicate> nmsComponent) {
        List nmsPredicates;
        AdventureModePredicate nmsAdventurePredicate = (AdventureModePredicate)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (CriterionConditionBlock nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (Holder nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((Block)((Block)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, DataComponentType<AdventureModePredicate> nmsComponent, List<Material> materials) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        AdventureModePredicate nmsAdventurePredicate = (AdventureModePredicate)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.e(nmsComponent);
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
        }
        CriterionConditionBlock nmsPredicate = new CriterionConditionBlock(Optional.of(HolderSet.a(material -> (Holder)BuiltInRegistries.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty(), DataComponentMatchers.a);
        nmsItemStack.b(nmsComponent, (Object)new AdventureModePredicate(List.of(nmsPredicate)));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().j == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        IChatBaseComponent nmsDisplayName = (IChatBaseComponent)nmsItemStack.a(DataComponents.h);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        ItemLore nmsLore = (ItemLore)nmsItemStack.a(DataComponents.m);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (IChatBaseComponent nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.e(DataComponents.h);
        } else {
            nmsItemStack.b(DataComponents.h, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.e(DataComponents.m);
        } else {
            ArrayList<IChatBaseComponent> nmsLore = new ArrayList<IChatBaseComponent>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(DataComponents.m, (Object)new ItemLore(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
    }

    public static IBlockData getCorrectStateForFluidBlock(World world, IBlockData blockState, BlockPosition blockPos) {
        Fluid fluid = blockState.y();
        return !fluid.c() && !blockState.c((IBlockAccess)world, blockPos, EnumDirection.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(WorldMap worldmap, int xMin, int zMin, int xMax, int zMax) {
        WorldServer world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.g;
        int mapX = worldmap.d;
        int mapZ = worldmap.e;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                MaterialMapColor materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                Chunk chunk = world.q(new BlockPosition(k2, 0, l2));
                if (chunk.F()) continue;
                ChunkCoordIntPair chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.F_().f()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)Blocks.j.m().a((IBlockAccess)world, BlockPosition.c), 10);
                    } else {
                        multiset.add((Object)Blocks.b.m().a((IBlockAccess)world, BlockPosition.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            IBlockData iblockdata;
                            int k4 = chunk.a(HeightMap.Type.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.K_() + 1) {
                                iblockdata = Blocks.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.e() + i4 + i3, --k4, chunkcoordintpair.f() + j4 + j3);
                                } while ((iblockdata = chunk.a_((BlockPosition)blockposition_mutableblockposition)).a((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition) == MaterialMapColor.a && k4 > world.K_());
                                if (k4 > world.K_() && !iblockdata.y().c()) {
                                    IBlockData iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((BaseBlockPosition)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((BlockPosition)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.K_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((World)world, iblockdata, (BlockPosition)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((IBlockAccess)world, chunkcoordintpair.e() + i4 + i3, chunkcoordintpair.f() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.a)) == MaterialMapColor.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        WorldMap worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(World.h).a(new MapId(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        Item nmsItem = BuiltInRegistries.h.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof ItemBlock) {
            Block block = ((ItemBlock)nmsItem).c();
            return CraftBlockData.fromData((IBlockData)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        net.minecraft.world.item.ItemStack nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        net.minecraft.world.item.ItemStack nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().br().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(PotionBrewer.class, (String)"customMixes", (Object)MinecraftServer.getServer().br())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<net.minecraft.world.item.ItemStack> nmsPredicate) {
        if (nmsPredicate instanceof RecipeItemStack) {
            RecipeItemStack ingredient = (RecipeItemStack)nmsPredicate;
            return CraftRecipe.toBukkit((RecipeItemStack)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((FoodInfo)CraftMagicNumbers.getItem((Material)itemType).f().a(DataComponents.y)).a();
    }
}

