/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.npc;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NPCNavigationScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static NPCNavigationScriptEvent instance;
    public NPCTag npc;
    public String type;

    public NPCNavigationScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("npc")) {
            return false;
        }
        if (!path.eventArgLowerAt(2).equals("navigation")) {
            return false;
        }
        String arg1 = path.eventArgLowerAt(1);
        return arg1.equals("begins") || arg1.equals("completes") || arg1.equals("cancels");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.npc.getLocation())) {
            return false;
        }
        if (!path.eventArgLowerAt(1).equals(this.type)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "NPCNavigation";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, this.npc);
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.type = "completes";
        this.fire((Event)event);
    }

    @EventHandler
    public void navBegin(NavigationBeginEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.type = "begins";
        this.fire((Event)event);
    }

    @EventHandler
    public void navCancel(NavigationCancelEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.type = "cancels";
        this.fire((Event)event);
    }
}

