/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerHoldsItemEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerHoldsItemEvent instance;
    public PlayerTag player;
    public boolean state;
    public boolean enabled = false;
    public static HashSet<UUID> raisedShields;

    public PlayerHoldsItemEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(0).equals("player")) {
            return false;
        }
        String middleWord = path.eventArgAt(1);
        if (!(middleWord.equals("raises") || middleWord.equals("lowers") || middleWord.equals("toggles"))) {
            return false;
        }
        return this.couldMatchItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("raises") && !this.state) {
            return false;
        }
        if (cmd.equals("lowers") && this.state) {
            return false;
        }
        if (!this.runInCheck(path, this.player.getLocation())) {
            return false;
        }
        String item = path.eventArgLowerAt(2);
        if (!item.equals("item") && !PlayerHoldsItemEvent.tryItem(this.player.getHeldItem(), item)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerHoldsItem";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("state")) {
            return new ElementTag(this.state);
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public static void signalDidRaise(Player player) {
        if (raisedShields.contains(player.getUniqueId())) {
            return;
        }
        raisedShields.add(player.getUniqueId());
        PlayerHoldsItemEvent.instance.state = true;
        PlayerHoldsItemEvent.instance.player = new PlayerTag(player);
        PlayerHoldsItemEvent.instance.cancelled = false;
        instance.fire();
    }

    public static void signalDidLower(Player player) {
        if (!raisedShields.remove(player.getUniqueId())) {
            return;
        }
        PlayerHoldsItemEvent.instance.state = false;
        PlayerHoldsItemEvent.instance.player = new PlayerTag(player);
        PlayerHoldsItemEvent.instance.cancelled = false;
        instance.fire();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerHoldsItemEvent.signalDidLower(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        PlayerHoldsItemEvent.signalDidLower(event.getEntity());
    }

    @EventHandler
    public void onPlayerChangeItem(PlayerItemHeldEvent event) {
        PlayerHoldsItemEvent.signalDidLower(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        PlayerHoldsItemEvent.signalDidLower(event.getPlayer());
    }

    static {
        raisedShields = new HashSet();
    }
}

