/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.ItemTag;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public abstract class ItemHelper {
    public void setMaxStackSize(Material material, int size) {
        throw new UnsupportedOperationException();
    }

    public abstract Integer burnTime(Material var1);

    public abstract Recipe getRecipeById(NamespacedKey var1);

    public abstract void removeRecipe(NamespacedKey var1);

    public abstract void clearDenizenRecipes();

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        throw new UnsupportedOperationException();
    }

    public abstract void registerFurnaceRecipe(String var1, String var2, ItemStack var3, ItemStack[] var4, float var5, int var6, String var7, boolean var8);

    public abstract void registerShapelessRecipe(String var1, String var2, ItemStack var3, List<ItemStack[]> var4, boolean[] var5);

    public abstract void setShapedRecipeIngredient(ShapedRecipe var1, char var2, ItemStack[] var3, boolean var4);

    public abstract String getInternalNameFromMaterial(Material var1);

    public abstract Material getMaterialFromInternalName(String var1);

    public abstract String getJsonString(ItemStack var1);

    public abstract String getRawHoverText(ItemStack var1);

    public abstract PlayerProfile getSkullSkin(ItemStack var1);

    public abstract ItemStack setSkullSkin(ItemStack var1, PlayerProfile var2);

    public abstract ItemStack addNbtData(ItemStack var1, String var2, Tag var3);

    public abstract CompoundTag getNbtData(ItemStack var1);

    public abstract ItemStack setNbtData(ItemStack var1, CompoundTag var2);

    public abstract PotionEffect getPotionEffect(PotionEffectType var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact) {
        throw new UnsupportedOperationException();
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        inventory.setItem(slot, item);
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        throw new UnsupportedOperationException();
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        return item.getItemMeta().getDisplayName();
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        return item.getItemMeta().getLore();
    }

    public void setDisplayName(ItemTag item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
    }

    public void setLore(ItemTag item, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        throw new UnsupportedOperationException();
    }
}

