/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;

public class MaterialSwitchFace
implements Property {
    public static final String[] handledMechs = new String[]{"switch_face"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData() instanceof Switch || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_15) && ((MaterialTag)material).getModernData() instanceof FaceAttachable);
    }

    public static MaterialSwitchFace getFrom(ObjectTag _material) {
        if (!MaterialSwitchFace.describes(_material)) {
            return null;
        }
        return new MaterialSwitchFace((MaterialTag)_material);
    }

    private MaterialSwitchFace(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "switch_face", (attribute, material) -> {
            if (material.isSwitch()) {
                return new ElementTag(material.getSwitch().getFace().name());
            }
            return new ElementTag(material.getFaceAttachable().getAttachedFace().name());
        }, new String[0]);
    }

    public boolean isSwitch() {
        return this.material.getModernData() instanceof Switch;
    }

    public Switch getSwitch() {
        return (Switch)this.material.getModernData();
    }

    public FaceAttachable getFaceAttachable() {
        return (FaceAttachable)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        if (this.isSwitch()) {
            return this.getSwitch().getFace().name();
        }
        return this.getFaceAttachable().getAttachedFace().name();
    }

    public BlockFace getAttachedTo() {
        if (this.isSwitch()) {
            switch (this.getSwitch().getFace()) {
                case WALL: {
                    return this.getSwitch().getFacing().getOppositeFace();
                }
                case FLOOR: {
                    return BlockFace.DOWN;
                }
                case CEILING: {
                    return BlockFace.UP;
                }
            }
            return BlockFace.SELF;
        }
        switch (this.getFaceAttachable().getAttachedFace()) {
            case WALL: {
                if (this.material.getModernData() instanceof Directional) {
                    return ((Directional)this.material.getModernData()).getFacing().getOppositeFace();
                }
            }
            case FLOOR: {
                return BlockFace.DOWN;
            }
            case CEILING: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    @Override
    public String getPropertyId() {
        return "switch_face";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("switch_face") && mechanism.requireEnum(false, (Enum<?>[])Switch.Face.values())) {
            if (this.isSwitch()) {
                this.getSwitch().setFace(Switch.Face.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                this.getFaceAttachable().setAttachedFace(FaceAttachable.AttachedFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            }
        }
    }
}

