/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewingStandFuelEvent;

public class BrewingStandFueledScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BrewingStandFueledScriptEvent instance;
    public LocationTag location;
    public ItemTag item;
    public BrewingStandFuelEvent event;

    public BrewingStandFueledScriptEvent() {
        instance = this;
        this.registerCouldMatcher("brewing stand fueled (with <item>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("with") && !BrewingStandFueledScriptEvent.tryItem(this.item, path.eventArgLowerAt(4))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BrewingStandFueled";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String val = ((ElementTag)determinationObj).asString();
            if (val.startsWith("fuel_power:")) {
                this.event.setFuelPower(Integer.parseInt(val.substring("fuel_power:".length())));
                return true;
            }
            if (val.equalsIgnoreCase("consuming")) {
                this.event.setConsuming(true);
                return true;
            }
            if (val.equalsIgnoreCase("not_consuming")) {
                this.event.setConsuming(false);
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "item": {
                return this.item;
            }
            case "fuel_power": {
                return new ElementTag(this.event.getFuelPower());
            }
            case "consuming": {
                return new ElementTag(this.event.isConsuming());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBrewingStandFueled(BrewingStandFuelEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item = new ItemTag(event.getFuel());
        this.event = event;
        this.fire((Event)event);
    }
}

