/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.trade;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class TradeInputs
implements Property {
    public static final String[] handledMechs = new String[]{"inputs"};
    private TradeTag recipe;

    public static boolean describes(ObjectTag recipe) {
        return recipe instanceof TradeTag;
    }

    public static TradeInputs getFrom(ObjectTag recipe) {
        if (!TradeInputs.describes(recipe)) {
            return null;
        }
        return new TradeInputs((TradeTag)recipe);
    }

    public TradeInputs(TradeTag recipe) {
        this.recipe = recipe;
    }

    @Override
    public String getPropertyString() {
        if (this.recipe.getRecipe() == null) {
            return null;
        }
        return this.getIngredientsList().identify();
    }

    public ListTag getIngredientsList() {
        ListTag result = new ListTag();
        for (ItemStack item : this.recipe.getRecipe().getIngredients()) {
            result.addObject(new ItemTag(item));
        }
        return result;
    }

    @Override
    public String getPropertyId() {
        return "inputs";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ListTag.class, "inputs", (attribute, recipe) -> recipe.getIngredientsList(), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("inputs")) {
            List<Object> ingredients = new ArrayList<ItemStack>();
            List<ItemTag> list = mechanism.valueAsType(ListTag.class).filter(ItemTag.class, mechanism.context);
            if (!mechanism.hasValue() || list.isEmpty()) {
                this.recipe.getRecipe().setIngredients(ingredients);
                return;
            }
            for (ItemTag item : list) {
                ingredients.add(item.getItemStack());
            }
            if (ingredients.size() > 2) {
                mechanism.echoError("Trade recipe input was given " + list.size() + " items. Only using the first two items!");
                ingredients = ingredients.subList(0, 2);
            }
            this.recipe.getRecipe().setIngredients(ingredients);
        }
    }
}

