/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardCommand
extends AbstractCommand {
    public ScoreboardCommand() {
        this.setName("scoreboard");
        this.setSyntax("scoreboard ({add}/remove) (viewers:<player>|...) (lines:<player>/<text>|...) (id:<value>/player/{main}) (objective:<value>) (criteria:<criteria>/{dummy}) (score:<#>) (displayslot:<value>/{sidebar}/none) (displayname:<name>) (rendertype:<type>)");
        this.setRequiredArguments(1, 10);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lines") && arg.matchesPrefix("lines", "l")) {
                scriptEntry.addObject("lines", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("objective") && arg.matchesPrefix("objective", "obj", "o")) {
                scriptEntry.addObject("objective", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("criteria") && arg.matchesPrefix("criteria", "c")) {
                scriptEntry.addObject("criteria", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("score") && arg.matchesInteger()) {
                scriptEntry.addObject("score", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("displayslot") && (arg.matchesEnum((Enum<?>[])DisplaySlot.values()) || arg.matches("none"))) {
                scriptEntry.addObject("displayslot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("displayslot") && arg.matchesPrefix("displayname")) {
                scriptEntry.addObject("displayname", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("rendertype") && arg.matchesPrefix("rendertype") && arg.matchesEnum((Enum<?>[])RenderType.values())) {
                scriptEntry.addObject("rendertype", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("viewers") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("viewers", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new ElementTag("add"));
        scriptEntry.defaultObject("id", new ElementTag("main"));
    }

    public static String checkLine(ObjectTag obj) {
        PlayerTag player;
        if (obj instanceof PlayerTag) {
            return ((PlayerTag)obj).getName();
        }
        if (obj instanceof EntityTag && ((EntityTag)obj).isSpawned()) {
            Entity ent = ((EntityTag)obj).getBukkitEntity();
            if (ent instanceof Player) {
                return ent.getName();
            }
            return ent.getUniqueId().toString();
        }
        String raw = obj.toString();
        if (raw.startsWith("p@") && (player = PlayerTag.valueOf(raw, CoreUtilities.noDebugContext)) != null) {
            return player.getName();
        }
        return raw;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Objective obj;
        boolean hadDisplaySlot;
        List viewers = (List)scriptEntry.getObject("viewers");
        ListTag lines = scriptEntry.hasObject("lines") ? ListTag.valueOf(scriptEntry.getElement("lines").asString(), scriptEntry.getContext()) : new ListTag();
        ElementTag action = scriptEntry.getElement("action");
        ElementTag id = scriptEntry.getElement("id");
        ElementTag objective = scriptEntry.getElement("objective");
        ElementTag criteria = scriptEntry.getElement("criteria");
        ElementTag score = scriptEntry.getElement("score");
        ElementTag displaySlot = scriptEntry.getElement("displayslot");
        ElementTag displayName = scriptEntry.getElement("displayname");
        ElementTag renderType = scriptEntry.getElement("rendertype");
        Action act = Action.valueOf(action.asString().toUpperCase());
        boolean hadCriteria = criteria != null;
        boolean bl = hadDisplaySlot = displaySlot != null;
        if (!hadCriteria) {
            criteria = new ElementTag("dummy");
        }
        if (!hadDisplaySlot) {
            displaySlot = new ElementTag("sidebar");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), action, id, ScoreboardCommand.db("viewers", viewers), objective, lines, score, objective, displaySlot, criteria, displayName, renderType);
        }
        Scoreboard board = null;
        if (id.asString().equalsIgnoreCase("main")) {
            board = ScoreboardHelper.getMain();
        } else if (id.asString().equalsIgnoreCase("player")) {
            board = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().getScoreboard();
        } else if (ScoreboardHelper.hasScoreboard(id.asString())) {
            board = ScoreboardHelper.getScoreboard(id.asString());
        } else if (act.equals((Object)Action.ADD)) {
            board = ScoreboardHelper.createScoreboard(id.asString());
        }
        if (board == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Scoreboard " + id.asString() + " does not exist!");
            return;
        }
        if (act.equals((Object)Action.ADD)) {
            if (objective != null) {
                boolean existedAlready;
                obj = board.getObjective(objective.asString());
                boolean bl2 = existedAlready = obj != null;
                if (obj == null) {
                    obj = board.registerNewObjective(objective.asString(), criteria.asString());
                } else if (hadCriteria && !obj.getCriteria().equals(criteria.asString())) {
                    obj.unregister();
                    obj = board.registerNewObjective(objective.asString(), criteria.asString());
                }
                if (!(existedAlready && !hadDisplaySlot || displaySlot.asString().equalsIgnoreCase("none"))) {
                    obj.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.asString().toUpperCase()));
                }
                if (renderType != null) {
                    obj.setRenderType(RenderType.valueOf((String)renderType.asString().toUpperCase()));
                }
                if (displayName != null) {
                    obj.setDisplayName(displayName.asString());
                } else if (!existedAlready) {
                    obj.setDisplayName(objective.asString());
                }
                if (!lines.isEmpty()) {
                    if (score == null) {
                        score = new ElementTag(0);
                    }
                    for (ObjectTag line : lines.objectForms) {
                        ScoreboardHelper.addScore(obj, ScoreboardCommand.checkLine(line), score.asInt());
                    }
                }
            } else if (viewers == null && !lines.isEmpty()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Cannot add lines without specifying an objective!");
            }
        } else if (act.equals((Object)Action.REMOVE)) {
            if (objective != null) {
                obj = board.getObjective(objective.asString());
                if (obj != null) {
                    if (lines.isEmpty()) {
                        Debug.echoDebug((Debuggable)scriptEntry, "Removing objective " + obj.getName() + " from scoreboard " + id.asString());
                        obj.unregister();
                    } else {
                        for (ObjectTag line : lines.objectForms) {
                            ScoreboardHelper.removeScore(obj, ScoreboardCommand.checkLine(line));
                        }
                    }
                } else {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Objective " + objective.asString() + " does not exist in scoreboard " + id.asString());
                }
            } else if (!lines.isEmpty()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Removing lines " + lines.identify() + " from all objectives in scoreboard " + id.asString());
                for (ObjectTag line : lines.objectForms) {
                    ScoreboardHelper.removePlayer(id.asString(), ScoreboardCommand.checkLine(line));
                }
            } else if (viewers == null) {
                Debug.echoDebug((Debuggable)scriptEntry, "Removing scoreboard " + id.asString());
                ScoreboardHelper.deleteScoreboard(id.asString());
            }
        }
        if (viewers != null) {
            for (PlayerTag viewer : viewers) {
                if (act.equals((Object)Action.ADD)) {
                    if (!id.asString().equalsIgnoreCase("main")) {
                        ScoreboardHelper.viewerMap.put(viewer.getUUID(), id.asString());
                    }
                    if (!viewer.isOnline()) continue;
                    viewer.getPlayerEntity().setScoreboard(board);
                    continue;
                }
                if (!act.equals((Object)Action.REMOVE)) continue;
                ScoreboardHelper.viewerMap.remove(viewer.getUUID());
                if (!viewer.isOnline()) continue;
                viewer.getPlayerEntity().setScoreboard(ScoreboardHelper.createScoreboard());
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE;

    }
}

