/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.SimpleDefinitionProvider;
import com.denizenscript.denizencore.utilities.YamlConfiguration;

public class FormatScriptContainer
extends ScriptContainer {
    public FormatScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
    }

    public String getFormat() {
        return this.getString("format", "<text>");
    }

    public String getFormattedText(String text, ScriptEntry entry) {
        return this.getFormattedText(text, Utilities.getEntryNPC(entry), Utilities.getEntryPlayer(entry));
    }

    public String getFormattedText(String textToReplace, NPCTag npc, PlayerTag player) {
        String name = npc != null ? npc.getName() : (player != null ? player.getName() : "");
        String text = this.getFormat();
        if (text.contains("<text") || text.contains("<name")) {
            Deprecations.pseudoTagBases.warn(this);
            text = text.replace("<text", "<element[" + EscapeTagBase.escape(textToReplace) + "].unescaped").replace("<name", "<element[" + EscapeTagBase.escape(name) + "].unescaped");
        }
        BukkitTagContext context = new BukkitTagContext(player, npc, new ScriptTag(this));
        context.definitionProvider = new SimpleDefinitionProvider();
        context.definitionProvider.addDefinition("text", new ElementTag(textToReplace));
        context.definitionProvider.addDefinition("name", new ElementTag(name));
        return TagManager.tag(text, context);
    }

    public String getFormatText(NPCTag npc, PlayerTag player) {
        String text = this.getFormat();
        if (text.contains("<text") || text.contains("<name")) {
            Deprecations.pseudoTagBases.warn(this);
            text = text.replace("<text>", String.valueOf('\u0000')).replace("<name>", String.valueOf('\u0004'));
        }
        text = text.replace("<[text]>", String.valueOf('\u0000')).replace("<[name]>", String.valueOf('\u0004'));
        return TagManager.tag(text, new BukkitTagContext(player, npc, new ScriptTag(this))).replace("%", "%%").replace(String.valueOf('\u0000'), "%2$s").replace(String.valueOf('\u0004'), "%1$s");
    }
}

