/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.DenizenJedisPubSub;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.shaded.redis.clients.jedis.Jedis;
import com.denizenscript.shaded.redis.clients.jedis.JedisPubSub;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedisCommand
extends AbstractCommand
implements Holdable {
    public static Map<String, Jedis> connections = new HashMap<String, Jedis>();
    public static Map<String, JedisPubSub> subscriptions = new HashMap<String, JedisPubSub>();

    public RedisCommand() {
        this.setName("com.denizenscript.shaded.redis");
        this.setSyntax("com/denizenscript/shaded/redis [id:<ID>] [connect:<host> (port:<port>/{6379}) (ssl:true/{false})/disconnect/subscribe:<channel>|.../unsubscribe/publish:<channel> message:<message>/command:<command> (args:<arg>|...)]");
        this.setRequiredArguments(2, 4);
        this.isProcedural = false;
    }

    @Override
    public void onDisable() {
        for (Map.Entry<String, JedisPubSub> entry : subscriptions.entrySet()) {
            try {
                entry.getValue().punsubscribe();
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        subscriptions.clear();
        for (Map.Entry<String, Object> entry : connections.entrySet()) {
            try {
                ((Jedis)entry.getValue()).close();
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        connections.clear();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("connect")) {
                scriptEntry.addObject("action", new ElementTag("connect"));
                scriptEntry.addObject("host", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("port") && arg.matchesPrefix("port") && arg.matchesInteger()) {
                scriptEntry.addObject("port", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("ssl") && arg.matchesPrefix("ssl") && arg.matchesBoolean()) {
                scriptEntry.addObject("ssl", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("disconnect")) {
                scriptEntry.addObject("action", new ElementTag("disconnect"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("subscribe")) {
                scriptEntry.addObject("action", new ElementTag("subscribe"));
                scriptEntry.addObject("channels", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("unsubscribe")) {
                scriptEntry.addObject("action", new ElementTag("unsubscribe"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("publish")) {
                scriptEntry.addObject("action", new ElementTag("publish"));
                scriptEntry.addObject("channel", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("message") && arg.matchesPrefix("message")) {
                scriptEntry.addObject("message", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("command") && arg.matchesPrefix("command")) {
                scriptEntry.addObject("action", new ElementTag("command"));
                scriptEntry.addObject("command", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("args") && arg.matchesPrefix("args")) {
                scriptEntry.addObject("args", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an ID!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid redis action!");
        }
        scriptEntry.defaultObject("port", new ElementTag(6379));
        scriptEntry.defaultObject("ssl", new ElementTag(false));
    }

    public ObjectTag processResponse(Object response) {
        if (response instanceof List) {
            ListTag list = new ListTag();
            for (Object o : (List)response) {
                list.addObject(this.processResponse(o));
            }
            return list;
        }
        if (response instanceof byte[]) {
            return new ElementTag(new String((byte[])response));
        }
        if (response instanceof Long) {
            return new ElementTag((Long)response);
        }
        return null;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        block39: {
            ElementTag id = scriptEntry.getElement("id");
            ElementTag action = scriptEntry.getElement("action");
            ElementTag host = scriptEntry.getElement("host");
            ElementTag port = scriptEntry.getElement("port");
            ElementTag ssl = scriptEntry.getElement("ssl");
            ListTag channels = (ListTag)scriptEntry.getObjectTag("channels");
            ElementTag channel = scriptEntry.getElement("channel");
            ElementTag message = scriptEntry.getElement("message");
            ElementTag command = scriptEntry.getElement("command");
            ListTag args = (ListTag)scriptEntry.getObjectTag("args");
            String redisID = CoreUtilities.toLowerCase(id.asString());
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), id, action, host, port, ssl, channels, channel, message, command, args);
            }
            if (!(action.asString().equalsIgnoreCase("connect") || action.asString().equalsIgnoreCase("command") && scriptEntry.shouldWaitFor())) {
                scriptEntry.setFinished(true);
            }
            try {
                if (action.asString().equalsIgnoreCase("connect")) {
                    if (host == null) {
                        Debug.echoError(scriptEntry, "Must specify a valid redis host!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (connections.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Already connected to a server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(() -> {
                        Jedis con = null;
                        if (Debug.verbose) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Connecting to " + host + " on port " + port);
                        }
                        try {
                            con = new Jedis(host.asString(), port.asInt(), ssl.asBoolean());
                        }
                        catch (Exception e) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoError(scriptEntry.getResidingQueue(), "Redis Exception: " + e.getMessage());
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                                }
                            }, 0.0f));
                        }
                        if (Debug.verbose) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Connection did not error");
                        }
                        Jedis conn = con;
                        if (con != null) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                connections.put(redisID, conn);
                                Debug.echoDebug((Debuggable)scriptEntry, "Successfully connected to " + host + " on port " + port);
                                scriptEntry.setFinished(true);
                            }, 0.0f));
                        } else {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoDebug((Debuggable)scriptEntry, "Connecting errored!");
                                }
                            }, 0.0f));
                        }
                    }, 0.0f)));
                    break block39;
                }
                if (action.asString().equalsIgnoreCase("disconnect")) {
                    if (!connections.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Jedis con = connections.remove(redisID);
                    JedisPubSub pubSub = subscriptions.remove(redisID);
                    if (pubSub != null) {
                        try {
                            pubSub.punsubscribe();
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                    }
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Disconnected from '" + redisID + "'.");
                    break block39;
                }
                if (action.asString().equalsIgnoreCase("subscribe")) {
                    Jedis con = connections.get(redisID);
                    if (con == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (subscriptions.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Already subscribed to a channel on redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    DenizenJedisPubSub jedisPubSub = new DenizenJedisPubSub(redisID);
                    subscriptions.put(redisID, jedisPubSub);
                    String[] channelArr = new String[channels.size()];
                    for (int i = 0; i < channels.size(); ++i) {
                        channelArr[i] = CoreUtilities.toLowerCase(channels.get(i));
                    }
                    Thread thr = new Thread(() -> con.psubscribe(jedisPubSub, channelArr));
                    thr.start();
                } else if (action.asString().equalsIgnoreCase("unsubscribe")) {
                    if (!connections.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (!subscriptions.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not subscribed to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    JedisPubSub pubSub = subscriptions.remove(redisID);
                    try {
                        pubSub.punsubscribe();
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                    }
                } else if (action.asString().equalsIgnoreCase("publish")) {
                    if (message == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid message to publish!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Jedis con = connections.get(redisID);
                    if (con == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (subscriptions.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Cannot publish messages while subscribed to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Publishing message '" + message.asString() + "' to channel '" + channel.asString() + "'");
                    Runnable doQuery = () -> {
                        try {
                            ElementTag result = new ElementTag(con.publish(CoreUtilities.toLowerCase(channel.asString()), message.asString()));
                            scriptEntry.addObject("result", result);
                            DenizenCore.schedule(new OneTimeSchedulable(() -> scriptEntry.setFinished(true), 0.0f));
                        }
                        catch (Exception ex) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoError(scriptEntry.getResidingQueue(), "Redis Exception: " + ex.getMessage());
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoError(scriptEntry.getResidingQueue(), ex);
                                }
                            }, 0.0f));
                        }
                    };
                    if (scriptEntry.shouldWaitFor()) {
                        DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(doQuery, 0.0f)));
                    } else {
                        doQuery.run();
                    }
                } else if (action.asString().equalsIgnoreCase("command")) {
                    if (command == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid redis command!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Jedis con = connections.get(redisID);
                    if (con == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (subscriptions.containsKey(redisID)) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Cannot run commands while subscribed to redis server with ID '" + redisID + "'!");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Running command " + command.asString());
                    Runnable doQuery = () -> {
                        try {
                            String[] redisArgs;
                            String redisCommand;
                            if (args == null) {
                                String[] splitCommand = ArgumentHelper.buildArgs(command.asString());
                                redisCommand = splitCommand[0];
                                redisArgs = Arrays.copyOfRange(splitCommand, 1, splitCommand.length);
                            } else {
                                redisCommand = command.asString();
                                redisArgs = args.toArray(new String[0]);
                            }
                            ObjectTag result = this.processResponse(con.sendCommand(() -> SafeEncoder.encode(redisCommand), redisArgs));
                            scriptEntry.addObject("result", result);
                            DenizenCore.schedule(new OneTimeSchedulable(() -> scriptEntry.setFinished(true), 0.0f));
                        }
                        catch (Exception ex) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoError(scriptEntry.getResidingQueue(), "Redis Exception: " + ex.getMessage());
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoError(scriptEntry.getResidingQueue(), ex);
                                }
                            }, 0.0f));
                        }
                    };
                    if (scriptEntry.shouldWaitFor()) {
                        DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(doQuery, 0.0f)));
                    } else {
                        doQuery.run();
                    }
                } else {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Unknown action '" + action.asString() + "'");
                }
            }
            catch (Exception ex) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Redis Exception: " + ex.getMessage());
                if (!Debug.verbose) break block39;
                Debug.echoError(scriptEntry.getResidingQueue(), ex);
            }
        }
    }
}

