/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis;

import com.denizenscript.shaded.redis.clients.jedis.Protocol;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ZParams {
    private final List<byte[]> params = new ArrayList<byte[]>();

    public ZParams weights(double ... weights) {
        this.params.add(Protocol.Keyword.WEIGHTS.getRaw());
        for (double weight : weights) {
            this.params.add(Protocol.toByteArray(weight));
        }
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public ZParams aggregate(Aggregate aggregate) {
        this.params.add(Protocol.Keyword.AGGREGATE.getRaw());
        this.params.add(aggregate.raw);
        return this;
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

        @Deprecated
        public final byte[] raw = SafeEncoder.encode(this.name());

        public byte[] getRaw() {
            return this.raw;
        }
    }
}

