/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class WaitCommand
extends AbstractCommand {
    public WaitCommand() {
        this.setName("wait");
        this.setSyntax("wait (<duration>) (queue:<name>) (system)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
        this.setBooleansHandled("system");
        this.setPrefixesHandled("queue");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("delay") && arg.limitToOnlyPrefix("delay")) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("delay", new DurationTag(3));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        QueueTag queue = scriptEntry.argForPrefix("queue", QueueTag.class, true);
        if (queue == null) {
            queue = new QueueTag(scriptEntry.getResidingQueue());
        }
        DurationTag delay = (DurationTag)scriptEntry.getObjectTag("delay");
        boolean system = scriptEntry.argAsBoolean("system");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), queue, delay, WaitCommand.db("mode", system ? "system" : "delta"));
        }
        TimedQueue.DelayTracker tracker = system ? new SystemTimeDelayTracker(delay.getMillis()) : new TimedQueue.DeltaTimeDelayTracker(delay.getMillis());
        if (queue.queue instanceof TimedQueue) {
            ((TimedQueue)queue.queue).delay = tracker;
        } else {
            scriptEntry.setInstant(false);
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Forcing queue " + queue.queue.id + " into a timed queue...");
            }
            queue.queue.forceToTimed(tracker);
        }
    }

    public static class SystemTimeDelayTracker
    implements TimedQueue.DelayTracker {
        public long systemTimeEnd;

        public SystemTimeDelayTracker(long millis) {
            this.systemTimeEnd = System.currentTimeMillis() + millis;
        }

        @Override
        public boolean isDelayed() {
            return this.systemTimeEnd > System.currentTimeMillis();
        }
    }
}

