/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class EntityArmorBonus
implements Property {
    public static final String[] handledTags = new String[]{"armor_bonus"};
    public static final String[] handledMechs = new String[]{"armor_bonus"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).isLivingEntity();
    }

    public static EntityArmorBonus getFrom(ObjectTag entity) {
        if (!EntityArmorBonus.describes(entity)) {
            return null;
        }
        return new EntityArmorBonus((EntityTag)entity);
    }

    private EntityArmorBonus(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        if (this.entity.getLivingEntity().getAttribute(org.bukkit.attribute.Attribute.GENERIC_ARMOR).getValue() > 0.0) {
            return this.getArmorBonus().asString();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "armor_bonus";
    }

    public ElementTag getArmorBonus() {
        return new ElementTag(this.entity.getLivingEntity().getAttribute(org.bukkit.attribute.Attribute.GENERIC_ARMOR).getValue());
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("armor_bonus")) {
            return this.getArmorBonus().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("armor_bonus") && mechanism.requireDouble()) {
            this.entity.getLivingEntity().getAttribute(org.bukkit.attribute.Attribute.GENERIC_ARMOR).setBaseValue(mechanism.getValue().asDouble());
        }
    }
}

