/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.ContextTagBase;
import com.denizenscript.denizencore.tags.core.CustomTagBase;
import com.denizenscript.denizencore.tags.core.DefinitionTagBase;
import com.denizenscript.denizencore.tags.core.DurationTagBase;
import com.denizenscript.denizencore.tags.core.ElementTagBase;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.tags.core.ListSingleTagBase;
import com.denizenscript.denizencore.tags.core.ListTagBase;
import com.denizenscript.denizencore.tags.core.MapTagBase;
import com.denizenscript.denizencore.tags.core.ProcedureScriptTagBase;
import com.denizenscript.denizencore.tags.core.QueueTagBase;
import com.denizenscript.denizencore.tags.core.ScriptTagBase;
import com.denizenscript.denizencore.tags.core.TernaryTagBase;
import com.denizenscript.denizencore.tags.core.TimeTagBase;
import com.denizenscript.denizencore.tags.core.UtilTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.codegen.TagCodeGenerator;
import com.denizenscript.denizencore.utilities.codegen.TagNamer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

public class TagManager {
    public static HashMap<String, TagBaseData> baseTags = new HashMap();
    public static boolean isInTag = false;
    public static boolean recentTagError = true;
    public static Pattern OBJECTTAG_CONFUSION_PATTERN = Pattern.compile("<\\w+tag[\\[.>].*", 2);
    public static HashMap<String, ParseableTag> preCalced = new HashMap();
    public static ParseableTag DEFAULT_PARSEABLE_EMPTY = new ParseableTag("");

    public static void registerCoreTags() {
        new CustomTagBase();
        new DurationTagBase();
        new ElementTagBase();
        new ListTagBase();
        new MapTagBase();
        new QueueTagBase();
        new ScriptTagBase();
        new TimeTagBase();
        new ContextTagBase();
        new DefinitionTagBase();
        new EscapeTagBase();
        new ListSingleTagBase();
        new ProcedureScriptTagBase();
        new TernaryTagBase();
        new UtilTagBase();
    }

    public static <R extends ObjectTag> void registerStaticTagBaseHandler(Class<R> returnType, String name, TagRunnable.BaseInterface<R> run) {
        baseTags.put(name, new TagBaseData(name, returnType, TagNamer.nameBaseInterface(name, run), true));
    }

    public static <R extends ObjectTag> void registerTagHandler(Class<R> returnType, String name, TagRunnable.BaseInterface<R> run) {
        baseTags.put(name, new TagBaseData(name, returnType, TagNamer.nameBaseInterface(name, run), false));
    }

    @Deprecated
    public static void registerTagHandler(TagRunnable.RootForm run, String ... names) {
        for (String name : names) {
            TagBaseData root = new TagBaseData();
            root.name = name;
            root.rootForm = run;
            baseTags.put(name, root);
        }
    }

    public static void fireEvent(ReplaceableTagEvent event) {
        TagBaseData baseHandler;
        if (Debug.verbose) {
            Debug.log("Tag fire: " + event.raw_tag + ", " + event.getAttributes().attributes[0].rawKey.contains("@") + ", " + event.hasAlternative() + "...");
        }
        TagBaseData tagBaseData = baseHandler = event.alternateBase != null ? event.alternateBase : event.mainRef.tagBase;
        if (baseHandler != null) {
            Attribute attribute = event.getAttributes();
            try {
                if (event.mainRef.compiledStart != null && event.alternateBase == null) {
                    ObjectTag result = event.mainRef.compiledStart.run(attribute);
                    if (result != null) {
                        event.setReplacedObject(result.getObjectAttribute(attribute));
                        return;
                    }
                } else if (baseHandler.baseForm != null) {
                    Object result = baseHandler.baseForm.run(attribute);
                    if (result != null) {
                        event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
                        return;
                    }
                } else if (baseHandler.rootForm != null) {
                    baseHandler.rootForm.run(event);
                    if (event.replaced()) {
                        return;
                    }
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            attribute.echoError("Tag-base '" + attribute.attributes[0].key + "' returned null.");
            return;
        }
        if (!event.hasAlternative()) {
            Debug.echoError("No tag-base handler for '" + event.getName() + "'.");
        }
        if (Debug.verbose) {
            Debug.log("Tag unhandled!");
        }
    }

    public static void executeWithTimeLimit(ReplaceableTagEvent event, int seconds) {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Future<?> future = executor.submit(() -> {
            try {
                DenizenCore.implementation.preTagExecute();
                if (isInTag) {
                    TagManager.fireEvent(event);
                } else {
                    isInTag = true;
                    TagManager.fireEvent(event);
                    isInTag = false;
                }
            }
            finally {
                DenizenCore.implementation.postTagExecute();
            }
        });
        executor.shutdown();
        try {
            future.get(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Debug.echoError("Tag filling was interrupted!");
        }
        catch (ExecutionException e) {
            Debug.echoError(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            Debug.echoError("Tag filling timed out!");
        }
        executor.shutdownNow();
    }

    public static ObjectTag readSingleTagObject(ParseableTagPiece tag, TagContext context) {
        ReplaceableTagEvent event = new ReplaceableTagEvent(tag.tagData, tag.content, context);
        return TagManager.readSingleTagObject(context, event);
    }

    public static ObjectTag readSingleTagObjectNoDebug(TagContext context, ReplaceableTagEvent event) {
        int tT = DenizenCore.implementation.getTagTimeout();
        if (Debug.verbose) {
            Debug.log("Tag read: " + event.raw_tag + ", " + tT + "...");
        }
        if (tT <= 0 || isInTag || !DenizenCore.implementation.shouldDebug(context) && !DenizenCore.implementation.tagTimeoutWhenSilent()) {
            TagManager.fireEvent(event);
        } else {
            TagManager.executeWithTimeLimit(event, tT);
        }
        if (!event.replaced() && event.hasAlternative()) {
            event.setReplacedObject(event.getAlternative());
        }
        return event.getReplacedObj();
    }

    public static ObjectTag readSingleTagObject(TagContext context, ReplaceableTagEvent event) {
        TagManager.readSingleTagObjectNoDebug(context, event);
        if (context.debug && event.replaced()) {
            Debug.echoDebug((Debuggable)context, "<G>Filled tag <<W>" + event.toString() + "<G>> with '<W>" + event.getReplacedObj().debuggable() + "<G>'.");
        }
        if (!event.replaced()) {
            String tagStr = "<LG><" + event.toString() + "<LG>><W>";
            Debug.echoError(context, "Tag " + tagStr + " is invalid!");
            recentTagError = true;
            if (OBJECTTAG_CONFUSION_PATTERN.matcher(tagStr).matches()) {
                Debug.echoError(context, "'ObjectTag' notation is for documentation purposes, and not to be used literally. An actual object must be inserted instead. If confused, join our Discord at https://discord.gg/Q6pZGSR to ask for help!");
            }
            if (!event.hasAlternative()) {
                Attribute attribute = event.getAttributes();
                if (attribute.fulfilled < attribute.attributes.length) {
                    Debug.echoDebug((Debuggable)event.getScriptEntry(), "   Unfilled or unrecognized sub-tag(s) '<R>" + attribute.unfilledString() + "<W>' for tag <LG><" + attribute.origin + "<LG>><W>!");
                    if (attribute.lastValid != null) {
                        Debug.echoDebug((Debuggable)event.getScriptEntry(), "   The returned value from initial tag fragment '<LG>" + attribute.filledString() + "<W>' was: '<LG>" + attribute.lastValid.debuggable() + "<W>'.");
                    }
                    if (attribute.seemingSuccesses.size() > 0) {
                        String almost = attribute.seemingSuccesses.get(attribute.seemingSuccesses.size() - 1);
                        if (attribute.hasContextFailed) {
                            Debug.echoDebug((Debuggable)event.getScriptEntry(), "   Almost matched but failed (missing [context] parameter?): " + almost);
                        } else {
                            Debug.echoDebug((Debuggable)event.getScriptEntry(), "   Almost matched but failed (possibly bad input?): " + almost);
                        }
                    }
                }
            }
            return new ElementTag(event.raw_tag);
        }
        return event.getReplacedObj();
    }

    public static ObjectTag parseChainObject(List<ParseableTagPiece> pieces, TagContext context) {
        if (Debug.verbose) {
            Debug.log("Tag parse chain: " + pieces + "...");
        }
        if (pieces.size() < 2) {
            if (pieces.isEmpty()) {
                return new ElementTag("", true);
            }
            ParseableTagPiece pzero = pieces.get(0);
            if (pzero.isError) {
                Debug.echoError(context, pzero.content);
            } else if (pzero.isTag) {
                return TagManager.readSingleTagObject(pzero, context);
            }
            ElementTag result = new ElementTag(pieces.get((int)0).content);
            result.isRawInput = true;
            return result;
        }
        StringBuilder helpy = new StringBuilder();
        for (ParseableTagPiece p : pieces) {
            if (p.isError) {
                Debug.echoError(context, p.content);
                continue;
            }
            if (p.isTag) {
                helpy.append(TagManager.readSingleTagObject(p, context).toString());
                continue;
            }
            helpy.append(p.content);
        }
        ElementTag result = new ElementTag(helpy.toString(), true);
        result.isRawInput = true;
        return result;
    }

    public static String tag(String arg, TagContext context) {
        return TagManager.tagObject(arg, context).toString();
    }

    public static ParseableTag parseTextToTag(String arg, TagContext context) {
        if (arg == null) {
            return null;
        }
        ParseableTag preParsed = preCalced.get(arg);
        if (preParsed != null) {
            return preParsed;
        }
        ParseableTag result = TagManager.parseTextToTagInternal(arg, context);
        preCalced.put(arg, result);
        return result;
    }

    public static ParseableTag parseTextToTagInternal(String arg, TagContext context) {
        ArrayList<ParseableTagPiece> pieces = new ArrayList<ParseableTagPiece>(1);
        if (arg.indexOf(62) == -1 || arg.length() < 3) {
            ParseableTagPiece txt = new ParseableTagPiece();
            txt.content = arg;
            pieces.add(txt);
            ParseableTag result = new ParseableTag(arg);
            result.pieces = pieces;
            return result;
        }
        int[] positions = new int[2];
        positions[0] = -1;
        TagManager.locateTag(arg, positions, 0);
        if (positions[0] == -1) {
            ParseableTagPiece txt = new ParseableTagPiece();
            txt.content = arg;
            pieces.add(txt);
            ParseableTag result = new ParseableTag(arg);
            result.pieces = pieces;
            return result;
        }
        String orig = arg;
        while (positions[0] != -1) {
            ParseableTagPiece preText = null;
            if (positions[0] > 0) {
                preText = new ParseableTagPiece();
                preText.content = arg.substring(0, positions[0]);
                pieces.add(preText);
            }
            String tagToProc = arg.substring(positions[0] + 1, positions[1]);
            ParseableTagPiece midTag = new ParseableTagPiece();
            midTag.content = tagToProc;
            midTag.isTag = true;
            try {
                midTag.tagData = new ReplaceableTagEvent((String)tagToProc, (TagContext)context).mainRef;
                if (midTag.tagData.rawObject != null) {
                    midTag.rawObject = midTag.tagData.rawObject;
                    midTag.content = midTag.tagData.rawObject.toString();
                    midTag.isTag = false;
                } else if (!midTag.tagData.noGenerate && midTag.tagData.tagBase != null && midTag.tagData.tagBase.baseForm != null) {
                    midTag.tagData.noGenerate = true;
                    midTag.tagData.compiledStart = TagCodeGenerator.generatePartialTag(midTag, context);
                }
                pieces.add(midTag);
                if (Debug.verbose) {
                    Debug.log("Tag: " + (preText == null ? "<null>" : preText.content) + " ||| " + midTag.content);
                }
            }
            catch (TagProcessingException ex) {
                Debug.echoError(context, "(Initial detection) Tag processing failed: " + ex.getMessage());
                ParseableTagPiece errorNote = new ParseableTagPiece();
                errorNote.isError = true;
                errorNote.content = "Tag processing failed: " + ex.getMessage();
                pieces.add(errorNote);
            }
            arg = arg.substring(positions[1] + 1);
            TagManager.locateTag(arg, positions, 0);
        }
        if (arg.indexOf(60) != -1 && !arg.contains(":<-")) {
            ParseableTagPiece errorNote = new ParseableTagPiece();
            errorNote.isError = true;
            errorNote.content = "Potential issue: inconsistent tag marks in command! (issue snippet: " + arg + "; from: " + orig + ")";
            pieces.add(errorNote);
        }
        if (arg.length() > 0) {
            ParseableTagPiece postText = new ParseableTagPiece();
            postText.content = arg;
            pieces.add(postText);
        }
        if (Debug.verbose) {
            Debug.log("Tag chainify complete: " + arg);
        }
        ParseableTagPiece priorPiece = (ParseableTagPiece)pieces.get(0);
        for (int i = 1; i < pieces.size(); ++i) {
            ParseableTagPiece currentPiece = (ParseableTagPiece)pieces.get(i);
            if (!(priorPiece.isTag || priorPiece.isError || currentPiece.isTag || currentPiece.isError)) {
                ParseableTagPiece newPiece = new ParseableTagPiece();
                newPiece.content = priorPiece.content + currentPiece.content;
                ElementTag element = new ElementTag(newPiece.content, true);
                element.isRawInput = true;
                newPiece.rawObject = element;
                if (Debug.verbose) {
                    Debug.log("Tag chain can simplify: " + priorPiece + " with " + currentPiece + " yields " + newPiece);
                }
                pieces.set(i - 1, newPiece);
                pieces.remove(i--);
                priorPiece = newPiece;
                continue;
            }
            priorPiece = currentPiece;
        }
        ParseableTag result = new ParseableTag();
        result.pieces = pieces;
        if (pieces.size() == 1) {
            ParseableTagPiece piece = (ParseableTagPiece)pieces.get(0);
            result.hasTag = piece.isTag;
            if (piece.isTag) {
                result.singleTag = piece;
            } else {
                result.rawObject = piece.rawObject;
            }
        } else {
            result.hasTag = true;
        }
        return result;
    }

    public static ObjectTag tagObject(String arg, TagContext context) {
        return TagManager.parseTextToTag(arg, context).parse(context);
    }

    private static void locateTag(String arg, int[] holder, int start) {
        int first;
        holder[0] = first = arg.indexOf(60, start);
        if (first == -1) {
            return;
        }
        int len = arg.length();
        if (first + 1 < len && arg.charAt(first + 1) == '-') {
            TagManager.locateTag(arg, holder, first + 1);
            return;
        }
        int bracks = 1;
        for (int i = first + 1; i < len; ++i) {
            if (arg.charAt(i) == '<') {
                ++bracks;
                continue;
            }
            if (arg.charAt(i) != '>' || --bracks != 0) continue;
            holder[1] = i;
            return;
        }
        holder[0] = -1;
    }

    public static void fillArgumentObjects(ScriptEntry.InternalArgument arg, Argument ahArg, TagContext context) {
        ahArg.lower_value = null;
        ahArg.unsetValue();
        if (arg.prefix != null) {
            if (arg.prefix.value.hasTag) {
                ahArg.prefix = arg.prefix.value.parse(context).toString();
                ahArg.lower_prefix = CoreUtilities.toLowerCase(ahArg.prefix);
            }
            if (arg.value.hasTag) {
                ahArg.object = arg.value.parse(context);
            }
        } else {
            ahArg.object = arg.value.parse(context);
            ahArg.prefix = null;
            ahArg.lower_prefix = null;
        }
    }

    public static class TagBaseData {
        public String name;
        public TagRunnable.RootForm rootForm;
        public TagRunnable.BaseInterface<?> baseForm;
        public Class<? extends ObjectTag> returnType;
        public ObjectTagProcessor<? extends ObjectTag> processor;
        public boolean isStatic;

        public TagBaseData() {
        }

        public <R extends ObjectTag> TagBaseData(String name, Class<R> returnType, TagRunnable.BaseInterface<R> baseForm, boolean isStatic) {
            this.name = name;
            this.returnType = returnType;
            this.baseForm = baseForm;
            this.isStatic = isStatic;
            ObjectFetcher.ObjectType<? extends ObjectTag> type = ObjectFetcher.objectsByClass.get(returnType);
            this.processor = type == null ? null : type.tagProcessor;
        }
    }

    public static class ParseableTagPiece {
        public String content;
        public boolean isTag = false;
        public boolean isError = false;
        public ReplaceableTagEvent.ReferenceData tagData = null;
        public ObjectTag rawObject;

        public String toString() {
            return "(" + this.isError + ", " + this.isTag + ", " + (this.isTag ? this.tagData.rawTag : "") + ", " + this.content + ", " + this.rawObject + ")";
        }
    }
}

