/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemNBT
implements Property {
    public static final String[] handledTags = new String[]{"has_nbt", "nbt_keys", "nbt"};
    public static final String[] handledMechs = new String[]{"remove_nbt", "nbt"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemNBT getFrom(ObjectTag item) {
        if (!ItemNBT.describes(item)) {
            return null;
        }
        return new ItemNBT((ItemTag)item);
    }

    private ItemNBT(ItemTag item) {
        this.item = item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_nbt")) {
            Deprecations.itemNbt.warn(attribute.context);
            return new ElementTag(CustomNBT.hasCustomNBT(this.item.getItemStack(), attribute.getParam(), "Denizen NBT")).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("nbt_keys")) {
            Deprecations.itemNbt.warn(attribute.context);
            return new ListTag(CustomNBT.listNBT(this.item.getItemStack(), "Denizen NBT")).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("nbt")) {
            Deprecations.itemNbt.warn(attribute.context);
            if (!attribute.hasParam()) {
                ListTag list = this.getNBTDataList();
                if (list == null) {
                    return null;
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
            String res = CustomNBT.getCustomNBT(this.item.getItemStack(), attribute.getParam(), "Denizen NBT");
            if (res == null) {
                return null;
            }
            return new ElementTag(res).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public ListTag getNBTDataList() {
        ItemStack itemStack = this.item.getItemStack();
        List<String> nbtKeys = CustomNBT.listNBT(itemStack, "Denizen NBT");
        if (nbtKeys != null && !nbtKeys.isEmpty()) {
            ListTag list = new ListTag();
            for (String key : nbtKeys) {
                list.add(EscapeTagBase.escape(key) + "/" + EscapeTagBase.escape(CustomNBT.getCustomNBT(itemStack, key, "Denizen NBT")));
            }
            return list;
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag list = this.getNBTDataList();
        if (list == null) {
            return null;
        }
        return list.identify();
    }

    @Override
    public String getPropertyId() {
        return "nbt";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("remove_nbt")) {
            Deprecations.itemNbt.warn(mechanism.context);
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                mechanism.echoError("Cannot apply NBT to AIR!");
                return;
            }
            ItemStack itemStack = this.item.getItemStack();
            List list = mechanism.hasValue() ? (List)mechanism.valueAsType(ListTag.class) : CustomNBT.listNBT(itemStack, "Denizen NBT");
            for (String string : list) {
                itemStack = CustomNBT.removeCustomNBT(itemStack, string, "Denizen NBT");
            }
            this.item.setItemStack(itemStack);
        }
        if (mechanism.matches("nbt")) {
            Deprecations.itemNbt.warn(mechanism.context);
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                mechanism.echoError("Cannot apply NBT to AIR!");
                return;
            }
            ListTag list = mechanism.valueAsType(ListTag.class);
            ItemStack itemStack = this.item.getItemStack();
            for (String string : list) {
                String[] split = string.split("/", 2);
                itemStack = CustomNBT.addCustomNBT(itemStack, EscapeTagBase.unEscape(split[0]), EscapeTagBase.unEscape(split[1]), "Denizen NBT");
            }
            this.item.setItemStack(itemStack);
        }
    }
}

