/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.WorldBorder;

public class WorldBorderCommand
extends AbstractCommand {
    public WorldBorderCommand() {
        this.setName("worldborder");
        this.setSyntax("worldborder [<world>/<player>|...] (center:<location>) (size:<#.#>) (current_size:<#.#>) (damage:<#.#>) (damagebuffer:<#.#>) (warningdistance:<#>) (warningtime:<duration>) (duration:<duration>) (reset)");
        this.setRequiredArguments(2, 10);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("center") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("center")) {
                scriptEntry.addObject("center", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("damage") && arg.matchesFloat() && arg.matchesPrefix("damage")) {
                scriptEntry.addObject("damage", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("damagebuffer") && arg.matchesFloat() && arg.matchesPrefix("damagebuffer")) {
                scriptEntry.addObject("damagebuffer", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("size") && arg.matchesFloat() && arg.matchesPrefix("size")) {
                scriptEntry.addObject("size", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("current_size") && arg.matchesFloat() && arg.matchesPrefix("current_size")) {
                scriptEntry.addObject("current_size", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("warningdistance") && arg.matchesInteger() && arg.matchesPrefix("warningdistance")) {
                scriptEntry.addObject("warningdistance", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("warningtime") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("warningtime")) {
                scriptEntry.addObject("warningtime", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("reset") && arg.matches("reset")) {
                scriptEntry.addObject("reset", new ElementTag("true"));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world") && !scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must specify a world or players!");
        }
        if (!(scriptEntry.hasObject("center") || scriptEntry.hasObject("size") || scriptEntry.hasObject("damage") || scriptEntry.hasObject("damagebuffer") || scriptEntry.hasObject("warningdistance") || scriptEntry.hasObject("warningtime") || scriptEntry.hasObject("reset"))) {
            throw new InvalidArgumentsException("Must specify at least one option!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(0));
        scriptEntry.defaultObject("reset", new ElementTag("false"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        List players = (List)scriptEntry.getObject("players");
        LocationTag center = (LocationTag)scriptEntry.getObjectTag("center");
        ElementTag size = scriptEntry.getElement("size");
        ElementTag currSize = scriptEntry.getElement("current_size");
        ElementTag damage = scriptEntry.getElement("damage");
        ElementTag damagebuffer = scriptEntry.getElement("damagebuffer");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag warningdistance = scriptEntry.getElement("warningdistance");
        DurationTag warningtime = (DurationTag)scriptEntry.getObjectTag("warningtime");
        ElementTag reset = (ElementTag)scriptEntry.getObjectTag("reset");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), world, WorldBorderCommand.db("players", players), center, size, currSize, damage, damagebuffer, warningdistance, warningtime, duration, reset);
        }
        if (players != null) {
            if (reset.asBoolean()) {
                for (PlayerTag player : players) {
                    NMSHandler.getPacketHelper().resetWorldBorder(player.getPlayerEntity());
                }
                return;
            }
            for (PlayerTag player : players) {
                WorldBorder wb = player.getWorld().getWorldBorder();
                NMSHandler.getPacketHelper().setWorldBorder(player.getPlayerEntity(), center != null ? center : wb.getCenter(), size != null ? size.asDouble() : wb.getSize(), currSize != null ? currSize.asDouble() : wb.getSize(), duration.getMillis(), warningdistance != null ? warningdistance.asInt() : wb.getWarningDistance(), warningtime != null ? warningtime.getSecondsAsInt() : wb.getWarningTime());
            }
            return;
        }
        WorldBorder worldborder = world.getWorld().getWorldBorder();
        if (reset.asBoolean()) {
            worldborder.reset();
            return;
        }
        if (center != null) {
            worldborder.setCenter((Location)center);
        }
        if (size != null) {
            if (currSize != null) {
                worldborder.setSize(currSize.asDouble());
            }
            worldborder.setSize(size.asDouble(), (long)duration.getSecondsAsInt());
        }
        if (damage != null) {
            worldborder.setDamageAmount(damage.asDouble());
        }
        if (damagebuffer != null) {
            worldborder.setDamageBuffer(damagebuffer.asDouble());
        }
        if (warningdistance != null) {
            worldborder.setWarningDistance(warningdistance.asInt());
        }
        if (warningtime != null) {
            worldborder.setWarningTime(warningtime.getSecondsAsInt());
        }
    }
}

