/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15.impl.jnbt;

import com.denizenscript.denizen.nms.util.jnbt.ByteArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.ByteTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.DoubleTag;
import com.denizenscript.denizen.nms.util.jnbt.EndTag;
import com.denizenscript.denizen.nms.util.jnbt.FloatTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.IntTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.ListTagBuilder;
import com.denizenscript.denizen.nms.util.jnbt.LongTag;
import com.denizenscript.denizen.nms.util.jnbt.ShortTag;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagByte;
import net.minecraft.server.v1_15_R1.NBTTagByteArray;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.NBTTagDouble;
import net.minecraft.server.v1_15_R1.NBTTagEnd;
import net.minecraft.server.v1_15_R1.NBTTagFloat;
import net.minecraft.server.v1_15_R1.NBTTagInt;
import net.minecraft.server.v1_15_R1.NBTTagIntArray;
import net.minecraft.server.v1_15_R1.NBTTagList;
import net.minecraft.server.v1_15_R1.NBTTagLong;
import net.minecraft.server.v1_15_R1.NBTTagShort;
import net.minecraft.server.v1_15_R1.NBTTagString;

public class CompoundTagImpl
extends CompoundTag {
    public CompoundTagImpl(Map<String, Tag> value) {
        super(value);
    }

    public NBTTagCompound toNMSTag() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry entry : this.value.entrySet()) {
            if (entry.getValue() instanceof IntTag) {
                tag.setInt((String)entry.getKey(), ((IntTag)entry.getValue()).getValue().intValue());
                continue;
            }
            if (entry.getValue() instanceof ByteTag) {
                tag.setByte((String)entry.getKey(), ((ByteTag)entry.getValue()).getValue().byteValue());
                continue;
            }
            if (entry.getValue() instanceof ByteArrayTag) {
                tag.setByteArray((String)entry.getKey(), ((ByteArrayTag)entry.getValue()).getValue());
                continue;
            }
            if (entry.getValue() instanceof CompoundTag) {
                tag.set((String)entry.getKey(), (NBTBase)((CompoundTagImpl)entry.getValue()).toNMSTag());
                continue;
            }
            if (entry.getValue() instanceof DoubleTag) {
                tag.setDouble((String)entry.getKey(), ((DoubleTag)entry.getValue()).getValue().doubleValue());
                continue;
            }
            if (entry.getValue() instanceof FloatTag) {
                tag.setFloat((String)entry.getKey(), ((FloatTag)entry.getValue()).getValue().floatValue());
                continue;
            }
            if (entry.getValue() instanceof IntArrayTag) {
                tag.setIntArray((String)entry.getKey(), ((IntArrayTag)entry.getValue()).getValue());
                continue;
            }
            if (entry.getValue() instanceof JNBTListTag) {
                NBTTagList list = new NBTTagList();
                Object tags = ((JNBTListTag)entry.getValue()).getValue();
                Iterator iterator = tags.iterator();
                while (iterator.hasNext()) {
                    Tag btag = (Tag)iterator.next();
                    HashMap<String, Tag> btags = new HashMap<String, Tag>();
                    btags.put("test", btag);
                    CompoundTagImpl comp = new CompoundTagImpl(btags);
                    list.add((Object)comp.toNMSTag().get("test"));
                }
                tag.set((String)entry.getKey(), (NBTBase)list);
                continue;
            }
            if (entry.getValue() instanceof LongTag) {
                tag.setLong((String)entry.getKey(), ((LongTag)entry.getValue()).getValue().longValue());
                continue;
            }
            if (entry.getValue() instanceof ShortTag) {
                tag.setShort((String)entry.getKey(), ((ShortTag)entry.getValue()).getValue().shortValue());
                continue;
            }
            if (!(entry.getValue() instanceof StringTag)) continue;
            tag.setString((String)entry.getKey(), ((StringTag)entry.getValue()).getValue());
        }
        return tag;
    }

    public static CompoundTag fromNMSTag(NBTTagCompound tag) {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        for (String key : tag.getKeys()) {
            NBTTagList list;
            NBTBase base = tag.get(key);
            if (base instanceof NBTTagInt) {
                tags.put(key, new IntTag(((NBTTagInt)base).asInt()));
                continue;
            }
            if (base instanceof NBTTagByte) {
                tags.put(key, new ByteTag(((NBTTagByte)base).asByte()));
                continue;
            }
            if (base instanceof NBTTagFloat) {
                tags.put(key, new FloatTag(((NBTTagFloat)base).asFloat()));
                continue;
            }
            if (base instanceof NBTTagDouble) {
                tags.put(key, new DoubleTag(((NBTTagDouble)base).asDouble()));
                continue;
            }
            if (base instanceof NBTTagByteArray) {
                tags.put(key, new ByteArrayTag(((NBTTagByteArray)base).getBytes()));
                continue;
            }
            if (base instanceof NBTTagIntArray) {
                tags.put(key, new IntArrayTag(((NBTTagIntArray)base).getInts()));
                continue;
            }
            if (base instanceof NBTTagCompound) {
                tags.put(key, CompoundTagImpl.fromNMSTag((NBTTagCompound)base));
                continue;
            }
            if (base instanceof NBTTagEnd) {
                tags.put(key, new EndTag());
                continue;
            }
            if (base instanceof NBTTagLong) {
                tags.put(key, new LongTag(((NBTTagLong)base).asLong()));
                continue;
            }
            if (base instanceof NBTTagShort) {
                tags.put(key, new ShortTag(((NBTTagShort)base).asShort()));
                continue;
            }
            if (base instanceof NBTTagString) {
                tags.put(key, new StringTag(base.asString()));
                continue;
            }
            if (!(base instanceof NBTTagList) || (list = (NBTTagList)base).size() <= 0) continue;
            NBTBase nbase = list.get(0);
            NBTTagCompound comp = new NBTTagCompound();
            comp.set("test", nbase);
            ListTagBuilder ltb = new ListTagBuilder(((Tag)CompoundTagImpl.fromNMSTag(comp).getValue().get("test")).getClass());
            for (int i = 0; i < list.size(); ++i) {
                NBTBase nbase2 = list.get(i);
                NBTTagCompound comp2 = new NBTTagCompound();
                comp2.set("test", nbase2);
                ltb.add((Tag)CompoundTagImpl.fromNMSTag(comp2).getValue().get("test"));
            }
            tags.put(key, ltb.build());
        }
        return new CompoundTagImpl(tags);
    }
}

