/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Material;
import org.bukkit.entity.Witch;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
implements Property {
    public static final String[] handledMechs = new String[]{"held_potion", "potion_drink_duration"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Witch;
    }

    public static EntityWitch getFrom(ObjectTag _entity) {
        if (!EntityWitch.describes(_entity)) {
            return null;
        }
        return new EntityWitch((EntityTag)_entity);
    }

    private EntityWitch(EntityTag _entity) {
        this.entity = _entity;
    }

    public static void registerTags() {
        PropertyParser.registerTag(ItemTag.class, "held_potion", (attribute, object) -> {
            ItemStack potion = object.getWitch().getDrinkingPotion();
            if (potion == null) {
                return new ItemTag(Material.AIR);
            }
            return new ItemTag(object.getWitch().getDrinkingPotion());
        }, new String[0]);
        PropertyParser.registerTag(DurationTag.class, "potion_drink_duration", (attribute, object) -> new DurationTag((long)object.getWitch().getPotionUseTimeLeft()), new String[0]);
    }

    public Witch getWitch() {
        return (Witch)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "held_potion";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("held_potion") && mechanism.requireObject(ItemTag.class)) {
            ItemTag potion = mechanism.valueAsType(ItemTag.class);
            if (potion.getBukkitMaterial() != Material.POTION) {
                mechanism.echoError("Invalid item input '" + potion + "': item must be a potion");
                return;
            }
            this.getWitch().setDrinkingPotion(potion.getItemStack());
        }
        if (mechanism.matches("potion_drink_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWitch().setPotionUseTimeLeft(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
    }
}

