/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public class EntityExplodesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityExplodesScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public EntityExplodeEvent event;

    public EntityExplodesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("explodes")) {
            return false;
        }
        return EntityExplodesScriptEvent.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!EntityExplodesScriptEvent.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityExplodes";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ArgumentHelper.matchesDouble(determination)) {
            this.event.setYield(Float.parseFloat(determination));
            return true;
        }
        if (determination.contains(",")) {
            this.event.blockList().clear();
            for (String loc : ListTag.valueOf(determination, this.getTagContext(path))) {
                LocationTag location = LocationTag.valueOf(loc, this.getTagContext(path));
                if (location == null) {
                    Debug.echoError("Invalid location '" + loc + "' check [" + this.getName() + "]: '  for " + path.container.getName());
                    continue;
                }
                this.event.blockList().add(location.getWorld().getBlockAt((Location)location));
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "location": {
                return this.location;
            }
            case "blocks": {
                ListTag blocks = new ListTag();
                for (Block block : this.event.blockList()) {
                    blocks.addObject(new LocationTag(block.getLocation()));
                }
                return blocks;
            }
            case "strength": {
                return new ElementTag(this.event.getYield());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

