/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_14.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_14_R1.AxisAlignedBB;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.ChatHoverable;
import net.minecraft.server.v1_14_R1.CombatMath;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.EnchantmentManager;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EntityPose;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.EnumMonsterType;
import net.minecraft.server.v1_14_R1.EnumMoveType;
import net.minecraft.server.v1_14_R1.GenericAttributes;
import net.minecraft.server.v1_14_R1.MinecraftKey;
import net.minecraft.server.v1_14_R1.MovingObjectPosition;
import net.minecraft.server.v1_14_R1.MovingObjectPositionBlock;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NavigationAbstract;
import net.minecraft.server.v1_14_R1.PathEntity;
import net.minecraft.server.v1_14_R1.PlayerChunkMap;
import net.minecraft.server.v1_14_R1.RayTrace;
import net.minecraft.server.v1_14_R1.RecipeBook;
import net.minecraft.server.v1_14_R1.RecipeBookServer;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final Field RECIPE_BOOK_DISCOVERED_SET = ReflectionHelper.getFields(RecipeBook.class).get("a");
    public static final MethodHandle ENTITY_HOVER_TEXT_GETTER = ReflectionHelper.getMethodHandle(Entity.class, "bK", new Class[0]);
    public static final MethodHandle ENTITY_SETPOSE = ReflectionHelper.getMethodHandle(Entity.class, "setPose", EntityPose.class);
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();

    @Override
    public double getAbsorption(LivingEntity entity) {
        return entity.getAbsorptionAmount();
    }

    @Override
    public void setAbsorption(LivingEntity entity, double value) {
        entity.setAbsorptionAmount(value);
    }

    @Override
    public void setSneaking(org.bukkit.entity.Entity player, boolean sneak) {
        if (player instanceof Player) {
            ((Player)player).setSneaking(sneak);
        }
        EntityPose pose = sneak ? EntityPose.SNEAKING : EntityPose.STANDING;
        try {
            ENTITY_SETPOSE.invoke(((CraftEntity)player).getHandle(), pose);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public double getDamageTo(LivingEntity attacker, org.bukkit.entity.Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().getMonsterType() : EnumMonsterType.UNDEFINED;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((net.minecraft.server.v1_14_R1.ItemStack)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            DamageSource source = attacker instanceof Player ? DamageSource.playerAttack((EntityHuman)((CraftPlayer)attacker).getHandle()) : DamageSource.mobAttack((EntityLiving)((CraftLivingEntity)attacker).getHandle());
            Entity nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.isInvulnerable(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.getArmorStrength(), (float)((float)livingTarget.getAttributeInstance(GenericAttributes.ARMOR_TOUGHNESS).getValue()));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.getArmorItems(), (DamageSource)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    @Override
    public String getRawHoverText(org.bukkit.entity.Entity entity) {
        try {
            ChatHoverable hoverable = ENTITY_HOVER_TEXT_GETTER.invoke(((CraftEntity)entity).getHandle());
            return hoverable.b().getText();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getDiscoveredRecipes(Player player) {
        try {
            RecipeBookServer book = ((CraftPlayer)player).getHandle().B();
            Set set = (Set)RECIPE_BOOK_DISCOVERED_SET.get(book);
            ArrayList<String> output = new ArrayList<String>();
            for (MinecraftKey key : set) {
                output.add(key.toString());
            }
            return output;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public String getArrowPickupStatus(org.bukkit.entity.Entity entity) {
        return ((Arrow)entity).getPickupStatus().name();
    }

    @Override
    public void setArrowPickupStatus(org.bukkit.entity.Entity entity, String status) {
        ((Arrow)entity).setPickupStatus(AbstractArrow.PickupStatus.valueOf((String)status));
    }

    @Override
    public double getArrowDamage(org.bukkit.entity.Entity arrow) {
        return ((Arrow)arrow).getDamage();
    }

    @Override
    public void setArrowDamage(org.bukkit.entity.Entity arrow, double damage) {
        ((Arrow)arrow).setDamage(damage);
    }

    @Override
    public void setRiptide(org.bukkit.entity.Entity entity, boolean state) {
        ((CraftLivingEntity)entity).getHandle().q(state ? 0 : 1);
    }

    @Override
    public int getBodyArrows(org.bukkit.entity.Entity entity) {
        return ((CraftLivingEntity)entity).getHandle().getArrowCount();
    }

    @Override
    public void setBodyArrows(org.bukkit.entity.Entity entity, int numArrows) {
        ((CraftLivingEntity)entity).getHandle().setArrowCount(numArrows);
    }

    @Override
    public org.bukkit.entity.Entity getFishHook(PlayerFishEvent event) {
        return event.getHook();
    }

    @Override
    public ItemStack getItemFromTrident(org.bukkit.entity.Entity entity) {
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)((CraftTrident)entity).getHandle().trident);
    }

    @Override
    public void setItemForTrident(org.bukkit.entity.Entity entity, ItemStack item) {
        ((CraftTrident)entity).getHandle().trident = CraftItemStack.asNMSCopy((ItemStack)item);
    }

    @Override
    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().interact((World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.MAIN_HAND, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, pos, false));
    }

    @Override
    public org.bukkit.entity.Entity getEntity(org.bukkit.World world, UUID uuid) {
        Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.entity.Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().c(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    @Override
    public void setNbtData(org.bukkit.entity.Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().f(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    @Override
    public void stopFollowing(org.bukkit.entity.Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    @Override
    public void stopWalking(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().o();
    }

    @Override
    public double getSpeed(org.bukkit.entity.Entity entity) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
    }

    @Override
    public void setSpeed(org.bukkit.entity.Entity entity, double speed) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
    }

    @Override
    public void follow(final org.bukkit.entity.Entity target, final org.bukkit.entity.Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    @Override
    public void walkTo(final LivingEntity entity, Location location, Double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            nmsEntity.onGround = true;
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 0)) != null) {
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
            if (speed != null) {
                nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.n() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(oldSpeed);
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    @Override
    public List<Player> getPlayersThatSee(org.bukkit.entity.Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().world).getChunkProvider().playerChunkMap;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (EntityPlayer player : entityTracker.trackedPlayers) {
            output.add((Player)player.getBukkitEntity());
        }
        return output;
    }

    @Override
    public void sendHidePacket(Player pl, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            pl.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().world).getChunkProvider().playerChunkMap;
            Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
        }
    }

    @Override
    public void sendShowPacket(Player pl, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().world).getChunkProvider().playerChunkMap;
            Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    @Override
    public void rotate(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    @Override
    public float getBaseYaw(org.bukkit.entity.Entity entity) {
        Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aL;
    }

    @Override
    public void look(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.yaw = yaw;
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aL = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.aK = yaw;
                }
                livingHandle.aM = yaw;
            }
            handle.pitch = pitch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovingObjectPosition rayTrace(org.bukkit.World world, Vector start, Vector end) {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(world);
            MovingObjectPositionBlock movingObjectPositionBlock = ((CraftWorld)world).getHandle().rayTrace(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.OUTLINE, RayTrace.FluidCollisionOption.NONE, null));
            return movingObjectPositionBlock;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(world);
        }
    }

    @Override
    public boolean canTrace(org.bukkit.World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    @Override
    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, endVec);
        if (!(l instanceof MovingObjectPositionBlock) || l.getPos() == null) {
            return null;
        }
        Vector finalVec = new Vector(l.getPos().x, l.getPos().y, l.getPos().z);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (((MovingObjectPositionBlock)l).getDirection()) {
            case NORTH: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case SOUTH: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case WEST: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    @Override
    public void snapPositionTo(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public void move(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.SELF, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    @Override
    public void teleport(org.bukkit.entity.Entity entity, Location vector) {
        ((CraftEntity)entity).getHandle().setPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public BoundingBox getBoundingBox(org.bukkit.entity.Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        Vector size = new Vector(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        return new BoundingBox(position, size);
    }

    @Override
    public void setBoundingBox(org.bukkit.entity.Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    @Override
    public boolean isChestedHorse(org.bukkit.entity.Entity horse) {
        return horse instanceof ChestedHorse;
    }

    @Override
    public boolean isCarryingChest(org.bukkit.entity.Entity horse) {
        return horse instanceof ChestedHorse && ((ChestedHorse)horse).isCarryingChest();
    }

    @Override
    public void setCarryingChest(org.bukkit.entity.Entity horse, boolean carrying) {
        if (horse instanceof ChestedHorse) {
            ((ChestedHorse)horse).setCarryingChest(carrying);
        }
    }
}

