/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;

public class EntityItem
implements Property {
    public static final String[] handledMechs = new String[]{"item"};
    EntityTag item;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        Entity entity = ((EntityTag)object).getBukkitEntity();
        return entity instanceof Item || entity instanceof Enderman || entity instanceof Trident || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_15) && entity instanceof ThrowableProjectile || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16) && entity instanceof EnderSignal;
    }

    public static EntityItem getFrom(ObjectTag entity) {
        if (!EntityItem.describes(entity)) {
            return null;
        }
        return new EntityItem((EntityTag)entity);
    }

    private EntityItem(EntityTag entity) {
        this.item = entity;
    }

    public ItemTag getItem(boolean includeDeprecated, TagContext context) {
        if (this.isDroppedItem()) {
            return new ItemTag(this.getDroppedItem().getItemStack());
        }
        if (includeDeprecated && this.isEnderman()) {
            Deprecations.entityItemEnderman.warn(context);
            BlockData data = this.getEnderman().getCarriedBlock();
            if (data == null) {
                return new ItemTag(Material.AIR);
            }
            return new ItemTag(data.getMaterial());
        }
        if (this.isTrident()) {
            return new ItemTag(NMSHandler.getEntityHelper().getItemFromTrident(this.item.getBukkitEntity()));
        }
        if (this.isThrowableProjectile()) {
            return new ItemTag(((ThrowableProjectile)this.item.getBukkitEntity()).getItem());
        }
        if (this.isEnderSignal()) {
            return new ItemTag(this.getEnderSignal().getItem());
        }
        return null;
    }

    public boolean isDroppedItem() {
        return this.item.getBukkitEntity() instanceof Item;
    }

    public boolean isEnderman() {
        return this.item.getBukkitEntity() instanceof Enderman;
    }

    public boolean isTrident() {
        return this.item.getBukkitEntity() instanceof Trident;
    }

    public boolean isThrowableProjectile() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_15) && this.item.getBukkitEntity() instanceof ThrowableProjectile;
    }

    public boolean isEnderSignal() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16) && this.item.getBukkitEntity() instanceof EnderSignal;
    }

    public Item getDroppedItem() {
        return (Item)this.item.getBukkitEntity();
    }

    public Enderman getEnderman() {
        return (Enderman)this.item.getBukkitEntity();
    }

    public Trident getTrident() {
        return (Trident)this.item.getBukkitEntity();
    }

    public EnderSignal getEnderSignal() {
        return (EnderSignal)this.item.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        ItemTag item = this.getItem(false, null);
        if (item.getBukkitMaterial() != Material.AIR) {
            return item.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "item";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ItemTag.class, "item", (attribute, object) -> object.getItem(true, attribute.context), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("item") && mechanism.requireObject(ItemTag.class)) {
            ItemStack itemStack = mechanism.valueAsType(ItemTag.class).getItemStack();
            if (this.item.isCitizensNPC()) {
                this.item.getDenizenNPC().getCitizen().data().setPersistent("item-type-id", (Object)itemStack.getType().name());
            }
            if (this.isDroppedItem()) {
                this.getDroppedItem().setItemStack(itemStack);
            } else if (this.isEnderman()) {
                Deprecations.entityItemEnderman.warn(mechanism.context);
                this.getEnderman().setCarriedBlock(itemStack.getType().createBlockData());
            } else if (this.isTrident()) {
                NMSHandler.getEntityHelper().setItemForTrident(this.item.getBukkitEntity(), itemStack);
            } else if (this.isThrowableProjectile()) {
                ((ThrowableProjectile)this.item.getBukkitEntity()).setItem(itemStack);
            } else if (this.isEnderSignal()) {
                this.getEnderSignal().setItem(itemStack);
            }
        }
    }
}

