/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class LookCommand
extends AbstractCommand {
    public static HashMap<UUID, BukkitTask> lookTasks = new HashMap();

    public LookCommand() {
        this.setName("look");
        this.setSyntax("look (<entity>|...) [<location>/cancel/yaw:<yaw> pitch:<pitch>] (duration:<duration>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("cancel") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && !scriptEntry.hasObject("location") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("yaw") && arg.matchesPrefix("yaw") && arg.matchesFloat()) {
                scriptEntry.addObject("yaw", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrefix("pitch") && arg.matchesFloat()) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("duration", "d")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, false));
        }
        if (!(scriptEntry.hasObject("location") || scriptEntry.hasObject("cancel") || scriptEntry.hasObject("yaw"))) {
            throw new InvalidArgumentsException("Must specify a location or 'cancel'!");
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify an entity!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        final LocationTag loc = (LocationTag)scriptEntry.getObjectTag("location");
        List entities = (List)scriptEntry.getObject("entities");
        if (entities == null) {
            throw new InvalidArgumentsRuntimeException("Missing entity target input");
        }
        final DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag yaw = scriptEntry.getElement("yaw");
        ElementTag pitch = scriptEntry.getElement("pitch");
        ElementTag cancel = scriptEntry.getElement("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), cancel, loc, duration, yaw, pitch, LookCommand.db("entities", entities));
        }
        for (EntityTag entity : entities) {
            BukkitTask task;
            if (!entity.isSpawned() || (task = lookTasks.remove(entity.getUUID())) == null) continue;
            task.cancel();
        }
        if (cancel != null && cancel.asBoolean()) {
            return;
        }
        final float yawRaw = yaw == null ? 0.0f : yaw.asFloat();
        final float pitchRaw = pitch == null ? 0.0f : pitch.asFloat();
        for (final EntityTag entity : entities) {
            if (!entity.isSpawned()) continue;
            if (loc != null) {
                NMSHandler.getEntityHelper().faceLocation(entity.getBukkitEntity(), (Location)loc);
                continue;
            }
            NMSHandler.getEntityHelper().rotate(entity.getBukkitEntity(), yawRaw, pitchRaw);
        }
        if (duration != null && duration.getTicks() > 2L) {
            for (final EntityTag entity : entities) {
                BukkitRunnable task = new BukkitRunnable(){
                    long bounces = 0L;

                    public void run() {
                        this.bounces += 2L;
                        if (this.bounces > duration.getTicks()) {
                            this.cancel();
                            lookTasks.remove(entity.getUUID());
                            return;
                        }
                        if (entity.isSpawned()) {
                            if (loc != null) {
                                NMSHandler.getEntityHelper().faceLocation(entity.getBukkitEntity(), (Location)loc);
                            } else {
                                NMSHandler.getEntityHelper().rotate(entity.getBukkitEntity(), yawRaw, pitchRaw);
                            }
                        }
                    }
                };
                BukkitTask newTask = task.runTaskTimer((Plugin)Denizen.getInstance(), 0L, 2L);
                lookTasks.put(entity.getUUID(), newTask);
            }
        }
    }
}

