/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class AnnounceCommand
extends AbstractCommand {
    public AnnounceCommand() {
        this.setName("announce");
        this.setSyntax("announce [<text>] (to_ops/to_console/to_flagged:<flag_name>/to_permission:<node>) (format:<name>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("type") && arg.matches("to_ops")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_OPS);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("to_console")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_CONSOLE);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("to_flagged")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_FLAGGED);
                scriptEntry.addObject("flag", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("to_permission")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_PERMISSION);
                scriptEntry.addObject("flag", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("format") && arg.matchesPrefix("format")) {
                String formatStr = arg.getValue();
                FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(formatStr);
                if (format == null) {
                    Debug.echoError("Could not find format script matching '" + formatStr + '\'');
                }
                scriptEntry.addObject("format", format);
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", arg.getRawElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Missing text argument!");
        }
        scriptEntry.defaultObject("type", new Object[]{AnnounceType.ALL});
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (scriptEntry.getResidingQueue().procedural) {
            Debug.echoError("'Announce' should not be used in a procedure script. Consider the 'debug' command instead.");
        }
        ElementTag text = scriptEntry.getElement("text");
        AnnounceType type = (AnnounceType)((Object)scriptEntry.getObject("type"));
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        ElementTag flag = scriptEntry.getElement("flag");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), AnnounceCommand.db("message", text), format != null ? AnnounceCommand.db("format", format.getName()) : "", AnnounceCommand.db("type", type.name()), flag);
        }
        String message = format != null ? format.getFormattedText(text.asString(), scriptEntry) : text.asString();
        switch (type) {
            case ALL: {
                Denizen.getInstance().getServer().spigot().broadcast(FormattedTextHelper.parse(message, ChatColor.WHITE));
                break;
            }
            case TO_OPS: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.isOp()) continue;
                    player.spigot().sendMessage(FormattedTextHelper.parse(message, ChatColor.WHITE));
                }
                break;
            }
            case TO_PERMISSION: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission(flag.asString())) continue;
                    player.spigot().sendMessage(FormattedTextHelper.parse(message, ChatColor.WHITE));
                }
            }
            case TO_FLAGGED: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!new PlayerTag(player).getFlagTracker().hasFlag(flag.asString())) continue;
                    player.spigot().sendMessage(FormattedTextHelper.parse(message, ChatColor.WHITE));
                }
                break;
            }
            case TO_CONSOLE: {
                Bukkit.getServer().getConsoleSender().spigot().sendMessage(FormattedTextHelper.parse(message, ChatColor.WHITE));
            }
        }
    }

    static enum AnnounceType {
        ALL,
        TO_OPS,
        TO_FLAGGED,
        TO_CONSOLE,
        TO_PERMISSION;

    }
}

