/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;

public class AttachCommand
extends AbstractCommand {
    public AttachCommand() {
        this.setName("attach");
        this.setSyntax("attach [<entity>|...] [to:<entity>/cancel] (offset:<offset>) (relative) (yaw_offset:<#.#>) (pitch_offset:<#.#>) (sync_server) (no_rotate/no_pitch) (for:<player>|...)");
        this.setRequiredArguments(2, 9);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("to") && !scriptEntry.hasObject("cancel") && arg.matchesPrefix("to") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("to", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && !scriptEntry.hasObject("to") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("relative") && arg.matches("relative")) {
                scriptEntry.addObject("relative", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("sync_server") && arg.matches("sync_server")) {
                scriptEntry.addObject("sync_server", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("no_rotate") && arg.matches("no_rotate")) {
                scriptEntry.addObject("no_rotate", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("no_pitch") && arg.matches("no_pitch")) {
                scriptEntry.addObject("no_pitch", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("yaw_offset") && arg.matchesPrefix("yaw_offset") && arg.matchesFloat()) {
                scriptEntry.addObject("yaw_offset", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch_offset") && arg.matchesPrefix("pitch_offset") && arg.matchesFloat()) {
                scriptEntry.addObject("pitch_offset", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesPrefix("offset") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("offset", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("for") && arg.matchesPrefix("for") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("for", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify attaching entities!");
        }
        if (!scriptEntry.hasObject("to") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a target entity, or 'cancel'!");
        }
        scriptEntry.defaultObject("cancel", new ElementTag(false));
        scriptEntry.defaultObject("relative", new ElementTag(false));
        scriptEntry.defaultObject("sync_server", new ElementTag(false));
        scriptEntry.defaultObject("no_rotate", new ElementTag(false));
        scriptEntry.defaultObject("no_pitch", new ElementTag(false));
        scriptEntry.defaultObject("yaw_offset", new ElementTag(0.0f));
        scriptEntry.defaultObject("pitch_offset", new ElementTag(0.0f));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag offset = (LocationTag)scriptEntry.getObjectTag("offset");
        List entities = (List)scriptEntry.getObject("entities");
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("to");
        List forPlayers = (List)scriptEntry.getObject("for");
        ElementTag cancel = scriptEntry.getElement("cancel");
        ElementTag relative = scriptEntry.getElement("relative");
        ElementTag sync_server = scriptEntry.getElement("sync_server");
        ElementTag no_rotate = scriptEntry.getElement("no_rotate");
        ElementTag no_pitch = scriptEntry.getElement("no_pitch");
        ElementTag yaw_offset = scriptEntry.getElement("yaw_offset");
        ElementTag pitch_offset = scriptEntry.getElement("pitch_offset");
        boolean shouldCancel = cancel.asBoolean();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), AttachCommand.db("entities", entities), shouldCancel ? cancel : target, relative, offset, yaw_offset, pitch_offset, sync_server, no_rotate, no_pitch, AttachCommand.db("for", forPlayers));
        }
        BiConsumer<EntityTag, UUID> procPlayer = (entity, player) -> {
            if (shouldCancel) {
                EntityAttachmentHelper.removeAttachment(entity.getUUID(), player);
            } else {
                EntityAttachmentHelper.AttachmentData attachment = new EntityAttachmentHelper.AttachmentData();
                attachment.attached = entity;
                attachment.to = target;
                attachment.positionalOffset = offset == null ? null : offset.clone();
                attachment.offsetRelative = relative.asBoolean();
                attachment.yawAngleOffset = yaw_offset.asFloat();
                attachment.pitchAngleOffset = pitch_offset.asFloat();
                attachment.syncServer = sync_server.asBoolean();
                attachment.forPlayer = player;
                attachment.noRotate = no_rotate.asBoolean();
                attachment.noPitch = no_pitch.asBoolean();
                EntityAttachmentHelper.registerAttachment(attachment);
            }
        };
        for (EntityTag entity2 : entities) {
            if (!(entity2.isSpawned() || entity2.isFake || shouldCancel)) {
                Debug.echoError("Cannot attach entity '" + entity2 + "': entity is not spawned.");
                continue;
            }
            if (forPlayers == null || forPlayers.isEmpty() && sync_server.asBoolean()) {
                procPlayer.accept(entity2, null);
                continue;
            }
            for (PlayerTag player2 : forPlayers) {
                procPlayer.accept(entity2, player2.getUUID());
            }
        }
    }
}

