/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.nbt.LeatherColorer;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    String hash = "";
    public boolean allowInMaterialRecipes;
    private ItemTag cleanReference;
    boolean isProcessing = false;

    public ItemScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
        this.allowInMaterialRecipes = this.getString("allow in material recipes", "false").equalsIgnoreCase("true");
        ItemScriptHelper.item_scripts.put(CoreUtilities.toLowerCase(this.getName()), this);
        ItemScriptHelper.item_scripts_by_hash_id.put(ItemScriptHelper.createItemScriptID(this), this);
    }

    public ItemTag getCleanReference() {
        if (this.cleanReference == null) {
            this.cleanReference = this.getItemFrom();
            if (this.cleanReference == null) {
                Debug.echoError("Item script '" + this.getName() + "' is invalid and unable to construct an ItemTag.");
                return null;
            }
        }
        return new ItemTag(this.cleanReference.getItemStack().clone());
    }

    public void setHashID(String HashID) {
        this.hash = HashID;
    }

    public ItemTag getItemFrom() {
        return this.getItemFrom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemTag getItemFrom(TagContext context) {
        ItemTag stack;
        if (this.isProcessing) {
            Debug.echoError("Item script contains (or chains to) a reference to itself. Cannot process.");
            return null;
        }
        if (context == null) {
            context = new BukkitTagContext(null, null, new ScriptTag(this));
        } else {
            context = new BukkitTagContext((BukkitTagContext)context);
            context.script = new ScriptTag(this);
        }
        this.isProcessing = true;
        try {
            if (!this.contains("material", String.class)) {
                Debug.echoError("Item script '" + this.getName() + "' does not contain a material. Script cannot function.");
                ItemTag itemTag = null;
                return itemTag;
            }
            String material = TagManager.tag(this.getString("material"), context);
            if (material.startsWith("m@")) {
                material = material.substring(2);
            }
            if ((stack = ItemTag.valueOf(material, this)) == null) {
                Debug.echoError("Item script '" + this.getName() + "' contains an invalid or incorrect material '" + material + "' (did you spell the material name wrong?). Script cannot function.");
                ItemTag itemTag = null;
                return itemTag;
            }
            if (this.contains("mechanisms", Map.class)) {
                YamlConfiguration mechs = this.getConfigurationSection("mechanisms");
                for (StringHolder key : mechs.getKeys(false)) {
                    ObjectTag obj = CoreUtilities.objectToTagForm(mechs.get(key.low), context, true, true);
                    stack.safeAdjust(new Mechanism(key.low, obj, context));
                }
            }
            if (this.contains("display name", String.class)) {
                String displayName = TagManager.tag(this.getString("display name"), context);
                NMSHandler.itemHelper.setDisplayName(stack, displayName);
            }
            if (this.contains("bound", String.class)) {
                Deprecations.boundWarning.warn(context);
            }
            if (this.contains("lore", List.class)) {
                List<String> lore = NMSHandler.itemHelper.getLore(stack);
                if (lore == null) {
                    lore = new ArrayList<String>();
                }
                for (String line : this.getStringList("lore")) {
                    line = TagManager.tag(line, context);
                    lore.add(line);
                }
                CoreUtilities.fixNewLinesToListSeparation(lore);
                NMSHandler.itemHelper.setLore(stack, lore);
            }
            if (this.contains("durability", String.class)) {
                short durability = Short.parseShort(this.getString("durability"));
                stack.setDurability(durability);
            }
            if (this.contains("enchantments", List.class)) {
                for (String enchantment : this.getStringList("enchantments")) {
                    enchantment = TagManager.tag(enchantment, context);
                    try {
                        int level = 1;
                        int colon = enchantment.lastIndexOf(58);
                        if (colon == -1) {
                            Debug.echoError("Item script '" + this.getName() + "' has enchantment '" + enchantment + "' without a level.");
                        } else {
                            level = Integer.parseInt(enchantment.substring(colon + 1).replace(" ", ""));
                            enchantment = enchantment.substring(0, colon).replace(" ", "");
                        }
                        EnchantmentTag ench = EnchantmentTag.valueOf(enchantment, context);
                        if (ench == null) {
                            Debug.echoError("Item script '" + this.getName() + "' specifies enchantment '" + enchantment + "' which is invalid.");
                            continue;
                        }
                        if (stack.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)stack.getItemMeta();
                            meta.addStoredEnchant(ench.enchantment, level, true);
                            stack.setItemMeta((ItemMeta)meta);
                            continue;
                        }
                        stack.getItemStack().addUnsafeEnchantment(ench.enchantment, level);
                        stack.resetCache();
                    }
                    catch (Exception ex) {
                        Debug.echoError("While constructing item script '" + this.getName() + "', encountered error while applying enchantment '" + enchantment + "':");
                        Debug.echoError(ex);
                    }
                }
            }
            if (this.contains("color", String.class)) {
                Deprecations.itemScriptColor.warn(context);
                String color = TagManager.tag(this.getString("color"), context);
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("book", String.class)) {
                BookScriptContainer book = (BookScriptContainer)ScriptRegistry.getScriptContainer(TagManager.tag(this.getString("book"), context).replace("s@", ""));
                stack = book.writeBookTo(stack, context);
            }
            if (this.contains("flags", Map.class)) {
                YamlConfiguration flagSection = this.getConfigurationSection("flags");
                AbstractFlagTracker tracker = stack.getFlagTracker();
                for (StringHolder key : flagSection.getKeys(false)) {
                    tracker.setFlag(key.str, CoreUtilities.objectToTagForm(flagSection.get(key.str), context, true, true), null);
                }
                stack.reapplyTracker(tracker);
            }
            stack.setItemScript(this);
        }
        catch (Exception e) {
            Debug.echoError("Woah! An exception has been called with this item script!");
            Debug.echoError(e);
            stack = null;
        }
        finally {
            this.isProcessing = false;
        }
        return stack;
    }
}

