/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.Repeater;

public class MaterialDelay
implements Property {
    public static final String[] handledMechs = new String[]{"delay"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof Repeater;
    }

    public static MaterialDelay getFrom(ObjectTag _material) {
        if (!MaterialDelay.describes(_material)) {
            return null;
        }
        return new MaterialDelay((MaterialTag)_material);
    }

    private MaterialDelay(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "delay", (attribute, material) -> new ElementTag(material.getCurrent()), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "max_delay", (attribute, material) -> new ElementTag(material.getMax()), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "min_delay", (attribute, material) -> new ElementTag(material.getMin()), new String[0]);
    }

    public Repeater getRepeater() {
        return (Repeater)this.material.getModernData();
    }

    public int getCurrent() {
        return this.getRepeater().getDelay();
    }

    public int getMax() {
        return this.getRepeater().getMaximumDelay();
    }

    public int getMin() {
        return this.getRepeater().getMinimumDelay();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "delay";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("delay") && mechanism.requireInteger()) {
            int delay = mechanism.getValue().asInt();
            if (delay < this.getMin() || delay > this.getMax()) {
                mechanism.echoError("Delay value '" + delay + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + ".");
                return;
            }
            this.getRepeater().setDelay(delay);
        }
    }
}

