/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;

public class AssignmentCommand
extends AbstractCommand {
    public AssignmentCommand() {
        this.setName("assignment");
        this.setSyntax("assignment [set/add/remove/clear] (script:<name>) (to:<npc>|...)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.add("set", "add", "remove", "clear");
        tab.addScriptsOfType(AssignmentScriptContainer.class);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesEnum(Action.class) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(ScriptTag.class) && !scriptEntry.hasObject("script")) {
                if (arg.asType(ScriptTag.class) != null && arg.asType(ScriptTag.class).getContainer() instanceof AssignmentScriptContainer) {
                    scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                    continue;
                }
                throw new InvalidArgumentsException("Script specified is not an 'assignment-type' container.");
            }
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsException("This command requires a linked NPC!");
            }
            scriptEntry.addObject("npcs", Collections.singletonList(Utilities.getEntryNPC(scriptEntry)));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), AssignmentCommand.db("action", (Object)action), script, AssignmentCommand.db("npc", npcs));
        }
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        for (NPCTag npc : npcs) {
            switch (action) {
                case SET: {
                    if (script == null) {
                        throw new InvalidArgumentsRuntimeException("Missing script!");
                    }
                    AssignmentTrait assignment = (AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class);
                    assignment.clearAssignments(player);
                    assignment.addAssignmentScript((AssignmentScriptContainer)script.getContainer(), player);
                    break;
                }
                case ADD: {
                    if (script == null) {
                        throw new InvalidArgumentsRuntimeException("Missing script!");
                    }
                    ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).addAssignmentScript((AssignmentScriptContainer)script.getContainer(), player);
                    break;
                }
                case REMOVE: {
                    if (script == null) {
                        BukkitImplDeprecations.assignmentRemove.warn(scriptEntry);
                        if (!npc.getCitizen().hasTrait(AssignmentTrait.class)) break;
                        ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).clearAssignments(player);
                        npc.getCitizen().removeTrait(AssignmentTrait.class);
                        break;
                    }
                    if (!npc.getCitizen().hasTrait(AssignmentTrait.class)) break;
                    AssignmentTrait trait = (AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class);
                    trait.removeAssignmentScript(script.getName(), player);
                    trait.checkAutoRemove();
                    break;
                }
                case CLEAR: {
                    if (!npc.getCitizen().hasTrait(AssignmentTrait.class)) break;
                    ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).clearAssignments(player);
                    npc.getCitizen().removeTrait(AssignmentTrait.class);
                }
            }
        }
    }

    private static enum Action {
        SET,
        ADD,
        REMOVE,
        CLEAR;

    }
}

