/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class EntitySpawnerSpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntitySpawnerSpawnScriptEvent instance;
    private EntityTag entity;
    private LocationTag location;
    private LocationTag spawnerLocation;
    public SpawnerSpawnEvent event;

    public EntitySpawnerSpawnScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("spawner spawns")) {
            return false;
        }
        return EntitySpawnerSpawnScriptEvent.couldMatchEntity(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(2))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "SpawnerSpawn";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "location": {
                return this.location;
            }
            case "spawner_location": {
                return this.spawnerLocation;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        Entity entity = event.getEntity();
        this.entity = new EntityTag(entity);
        this.location = new LocationTag(event.getLocation());
        this.spawnerLocation = new LocationTag(event.getSpawner().getLocation());
        this.event = event;
        EntityTag.rememberEntity(entity);
        this.fire((Event)event);
        EntityTag.forgetEntity(entity);
    }
}

