/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlayerRightClicksEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerRightClicksEntityScriptEvent instance;
    PlayerInteractEntityEvent event;
    EntityTag entity;
    ItemTag item;

    public PlayerRightClicksEntityScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player right clicks <entity>");
        this.registerSwitches("with", "type");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        boolean isAt = path.eventArgLowerAt(3).equals("at");
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(isAt ? 4 : 3))) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!PlayerRightClicksEntityScriptEvent.runWithCheck(path, this.item)) {
            return false;
        }
        if (path.eventArgLowerAt(isAt ? 5 : 4).equals("with") && !this.item.tryAdvancedMatcher(path.eventArgLowerAt(isAt ? 6 : 5))) {
            return false;
        }
        if (path.switches.containsKey("type") && !this.entity.tryAdvancedMatcher(path.switches.get("type"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerRightClicksEntity";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), this.entity.isNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "item": {
                return this.item;
            }
            case "hand": {
                return new ElementTag(this.event.getHand() == EquipmentSlot.OFF_HAND ? "offhand" : "mainhand");
            }
            case "location": {
                BukkitImplDeprecations.playerRightClicksEntityContext.warn();
                return this.entity.getLocation();
            }
            case "click_position": {
                if (!(this.event instanceof PlayerInteractAtEntityEvent)) break;
                return new LocationTag(((PlayerInteractAtEntityEvent)this.event).getClickedPosition());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerRightClicksAtEntity(PlayerInteractAtEntityEvent event) {
        this.playerRightClicksEntityHandler((PlayerInteractEntityEvent)event);
    }

    @EventHandler
    public void playerRightClicksEntity(PlayerInteractEntityEvent event) {
        if (event instanceof PlayerInteractAtEntityEvent) {
            return;
        }
        this.playerRightClicksEntityHandler(event);
    }

    public void playerRightClicksEntityHandler(PlayerInteractEntityEvent event) {
        this.entity = new EntityTag(event.getRightClicked());
        this.item = new ItemTag(event.getPlayer().getEquipment().getItem(event.getHand()));
        this.event = event;
        this.fire((Event)event);
    }
}

