/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.HorseJumpEvent;

public class HorseJumpsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HorseJumpsScriptEvent instance;
    public EntityTag entity;
    public ElementTag color;
    public HorseJumpEvent event;

    public HorseJumpsScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> jumps");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            if (path.eventArgLowerAt(2).equals("jumps") && HorseJumpsScriptEvent.couldMatchEntity(path.eventArgLowerAt(1))) {
                BukkitImplDeprecations.horseJumpsFormat.warn(path.container);
                return true;
            }
            return false;
        }
        return !path.eventLower.startsWith("player");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String tamed;
        String arg1 = path.eventArgLowerAt(0);
        String arg2 = path.eventArgLowerAt(1);
        String string = tamed = arg2.equals("jumps") ? arg1 : arg2;
        if (!this.entity.tryAdvancedMatcher(tamed)) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("jumps") && (this.color == null || !arg1.equals(CoreUtilities.toLowerCase(this.color.toString())))) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "HorseJumps";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isFloat()) {
            this.event.setPower(((ElementTag)determinationObj).asFloat());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "color": {
                return this.color;
            }
            case "power": {
                return new ElementTag(this.event.getPower());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHorseJumps(HorseJumpEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.color = event.getEntity() instanceof Horse ? new ElementTag(((Horse)event.getEntity()).getColor().name()) : null;
        this.event = event;
        this.fire((Event)event);
    }
}

