/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;

public class EngageCommand
extends AbstractCommand {
    private static Map<String, Long> currentlyEngaged = new HashMap<String, Long>();

    public EngageCommand() {
        this.setName("engage");
        this.setSyntax("engage (<duration>) (player)");
        this.setRequiredArguments(0, 2);
        this.isProcedural = false;
        this.setBooleansHandled("player");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("duration", new DurationTag(0));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsRuntimeException("This command requires a linked NPC!");
        }
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        boolean linkedPlayer = scriptEntry.argAsBoolean("player");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), npc, duration, EngageCommand.db("player", linkedPlayer));
        }
        if (duration.getSecondsAsInt() > 0) {
            EngageCommand.setEngaged(npc.getCitizen(), linkedPlayer ? Utilities.getEntryPlayer(scriptEntry) : null, duration.getSecondsAsInt());
        } else {
            EngageCommand.setEngaged(npc.getCitizen(), linkedPlayer ? Utilities.getEntryPlayer(scriptEntry) : null, true);
        }
    }

    public static String getID(NPC npc, PlayerTag player) {
        if (player == null) {
            return npc.getUniqueId().toString();
        }
        return npc.getUniqueId().toString() + "_" + player.getUUID().toString();
    }

    public static boolean getEngaged(NPC npc, PlayerTag player) {
        String id = EngageCommand.getID(npc, player);
        if (currentlyEngaged.containsKey(id) && currentlyEngaged.get(id) > CoreUtilities.monotonicMillis()) {
            return true;
        }
        if (player != null) {
            return EngageCommand.getEngaged(npc, null);
        }
        return false;
    }

    public static void setEngaged(NPC npc, PlayerTag player, boolean engaged) {
        if (engaged) {
            EngageCommand.setEngaged(npc, player, (int)DurationTag.valueOf(Settings.engageTimeoutInSeconds(), CoreUtilities.basicContext).getSeconds());
        }
        if (!engaged) {
            currentlyEngaged.remove(EngageCommand.getID(npc, player));
        }
    }

    public static void setEngaged(NPC npc, PlayerTag player, int duration) {
        currentlyEngaged.put(EngageCommand.getID(npc, player), CoreUtilities.monotonicMillis() + (long)duration * 1000L);
    }
}

