/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class ScoreboardHelper {
    public static ScoreboardManager manager = Bukkit.getScoreboardManager();
    public static Map<String, Scoreboard> scoreboardMap = new HashMap<String, Scoreboard>();
    public static Map<UUID, String> viewerMap = new HashMap<UUID, String>();

    public static void _recallScoreboards() {
        for (Map.Entry<String, Scoreboard> entry : scoreboardMap.entrySet()) {
            ScoreboardHelper.clearScoreboard(entry.getValue());
        }
        Scoreboard emptyBoard = ScoreboardHelper.createScoreboard();
        for (Map.Entry<UUID, String> entry : viewerMap.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) continue;
            player.getPlayer().setScoreboard(emptyBoard);
        }
        scoreboardMap.clear();
        viewerMap.clear();
        ConfigurationSection configurationSection = Denizen.getInstance().getScoreboards().getConfigurationSection("Scoreboards");
        if (configurationSection == null) {
            return;
        }
        for (String id : configurationSection.getKeys(false)) {
            Scoreboard scoreboard = ScoreboardHelper.createScoreboard(id);
            List viewerList = configurationSection.getStringList(id + ".Viewers");
            for (String viewer : viewerList) {
                if (!PlayerTag.matches(viewer)) continue;
                PlayerTag player = PlayerTag.valueOf(viewer, CoreUtilities.basicContext);
                viewerMap.put(player.getUUID(), id);
                if (!player.isOnline()) continue;
                player.getPlayerEntity().setScoreboard(scoreboard);
            }
            ConfigurationSection objSection = configurationSection.getConfigurationSection(id + ".Objectives");
            if (objSection == null) {
                return;
            }
            for (String obj : objSection.getKeys(false)) {
                ConfigurationSection scoreSection;
                String displaySlot = objSection.getString(obj + ".Display slot");
                String criteria = objSection.getString(obj + ".Criteria");
                if (criteria == null) {
                    criteria = "dummy";
                }
                if (displaySlot == null) {
                    displaySlot = "NONE";
                }
                Objective o = scoreboard.registerNewObjective(obj, criteria);
                o.setDisplayName(obj);
                if (Argument.valueOf(displaySlot).matchesEnum(DisplaySlot.class)) {
                    o.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.toUpperCase()));
                }
                if ((scoreSection = objSection.getConfigurationSection(obj + ".Scores")) == null) continue;
                for (String scoreName : scoreSection.getKeys(false)) {
                    int scoreInt = scoreSection.getInt(scoreName);
                    ScoreboardHelper.addScore(o, scoreName, scoreInt);
                }
            }
        }
    }

    public static void _saveScoreboards() {
        try {
            Denizen.getInstance().getScoreboards().set("Scoreboards", null);
            for (Map.Entry<String, Scoreboard> scoreboardEntry : scoreboardMap.entrySet()) {
                String id = scoreboardEntry.getKey();
                ArrayList<String> viewerList = new ArrayList<String>();
                for (Map.Entry<UUID, String> viewerEntry : viewerMap.entrySet()) {
                    if (!id.equalsIgnoreCase(viewerEntry.getValue())) continue;
                    viewerList.add(viewerEntry.getKey().toString());
                }
                Denizen.getInstance().getScoreboards().set("Scoreboards." + id + ".Viewers", viewerList);
                for (Objective obj : scoreboardEntry.getValue().getObjectives()) {
                    String objPath = "Scoreboards." + id + ".Objectives." + obj.getName();
                    Denizen.getInstance().getScoreboards().set(objPath + ".Criteria", (Object)obj.getCriteria());
                    String displaySlot = obj.getDisplaySlot() != null ? obj.getDisplaySlot().name() : "NONE";
                    Denizen.getInstance().getScoreboards().set(objPath + ".Display slot", (Object)displaySlot);
                    for (String player : scoreboardEntry.getValue().getEntries()) {
                        int score = obj.getScore(player).getScore();
                        Team team = scoreboardEntry.getValue().getTeam(player);
                        player = (team != null && team.getPrefix() != null ? team.getPrefix() : "") + player + (team != null && team.getSuffix() != null ? team.getSuffix() : "");
                        if (score == 0) continue;
                        Denizen.getInstance().getScoreboards().set(objPath + ".Scores." + player, (Object)score);
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    public static void addScore(Objective o, String playerName, int score) {
        Score sc = o.getScore(playerName);
        if (score == 0) {
            sc.setScore(1);
            sc.setScore(0);
        } else {
            sc.setScore(score);
        }
    }

    public static void removeScore(Objective o, String playerName) {
        Scoreboard board = o.getScoreboard();
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        for (Score score : board.getScores(playerName)) {
            if (score.getObjective().equals(o)) continue;
            scoreMap.put(score.getObjective().getName(), score.getScore());
        }
        board.resetScores(playerName);
        for (Map.Entry entry : scoreMap.entrySet()) {
            board.getObjective((String)entry.getKey()).getScore(playerName).setScore(((Integer)entry.getValue()).intValue());
        }
    }

    public static void clearScoreboard(Scoreboard board) {
        for (Objective o : board.getObjectives()) {
            o.unregister();
        }
    }

    public static Scoreboard createScoreboard() {
        return manager.getNewScoreboard();
    }

    public static Scoreboard createScoreboard(String id) {
        Scoreboard board = manager.getNewScoreboard();
        scoreboardMap.put(id.toUpperCase(), board);
        return board;
    }

    public static void deleteScoreboard(String id) {
        if (id.equalsIgnoreCase("main")) {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getMain());
        } else {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getScoreboard(id));
            scoreboardMap.remove(id.toUpperCase());
        }
    }

    public static Scoreboard getMain() {
        return manager.getMainScoreboard();
    }

    public static Scoreboard getScoreboard(String id) {
        return scoreboardMap.get(id.toUpperCase());
    }

    public static boolean hasScoreboard(String id) {
        return scoreboardMap.containsKey(id.toUpperCase());
    }

    public static void removePlayer(String id, String name) {
        scoreboardMap.get(id.toUpperCase()).resetScores(name);
    }
}

