/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.FishingTrait;
import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.npc.traits.MirrorEquipmentTrait;
import com.denizenscript.denizen.npc.traits.MirrorNameTrait;
import com.denizenscript.denizen.npc.traits.MirrorTrait;
import com.denizenscript.denizen.npc.traits.NicknameTrait;
import com.denizenscript.denizen.npc.traits.PushableTrait;
import com.denizenscript.denizen.npc.traits.SittingTrait;
import com.denizenscript.denizen.npc.traits.SleepingTrait;
import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.utilities.command.manager.messaging.Messaging;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Anchors;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Campfire;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class NPCCommandHandler {
    public NPCCommandHandler(Citizens citizens) {
    }

    @Command(aliases={"npc"}, usage="pushable -t (-r) (--delay #)", desc="Makes an NPC pushable.", flags="rt", modifiers={"pushable", "push"}, min=1, max=2, permission="denizen.npc.pushable")
    @Requirements(selected=true, ownership=true)
    public void pushable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        PushableTrait trait = (PushableTrait)npc.getOrAddTrait(PushableTrait.class);
        if (args.hasFlag('r') && !args.hasFlag('t')) {
            trait.setReturnable(!trait.isReturnable());
            Messaging.sendInfo(sender, npc.getName() + (trait.isReturnable() ? " will " : " will not ") + "return when being pushed" + (!trait.isReturnable() || trait.isPushable() ? "." : ", but is currently not pushable."));
            return;
        }
        if (args.hasValueFlag("delay") && !args.hasFlag('t')) {
            if (args.getFlag("delay").matches("\\d+") && args.getFlagInteger("delay") > 0) {
                trait.setDelay(Integer.parseInt(args.getFlag("delay")));
                trait.setReturnable(true);
                Messaging.sendInfo(sender, npc.getName() + " will return after '" + args.getFlag("delay") + "' seconds" + (trait.isPushable() ? "." : ", but is currently not pushable."));
                return;
            }
            Messaging.sendError(sender, "Delay must be a valid number of seconds!");
            return;
        }
        if (args.hasFlag('t') && !args.hasValueFlag("delay") && !args.hasFlag('r')) {
            trait.toggle();
            Messaging.sendInfo(sender, npc.getName() + (trait.isPushable() ? " is" : " is not") + " currently pushable" + (trait.isReturnable() && trait.isPushable() ? " and will return when pushed after '" + trait.getDelay() + "' seconds." : "."));
            return;
        }
        if (args.hasFlag('t')) {
            trait.toggle();
            if (args.hasFlag('r')) {
                trait.setReturnable(true);
            }
            if (args.hasValueFlag("delay") && args.getFlag("delay").matches("\\d+") && args.getFlagInteger("delay") > 0) {
                trait.setDelay(args.getFlagInteger("delay"));
            }
            Messaging.sendInfo(sender, npc.getName() + (trait.isPushable() ? " is" : " is not") + " currently pushable" + (trait.isReturnable() && trait.isPushable() ? " and will return when pushed after '" + trait.getDelay() + "' seconds." : "."));
            return;
        }
        if (args.length() > 2) {
            Messaging.send(sender, "");
            Messaging.send(sender, "<f>Use '-t' to toggle pushable state. <b>Example: /npc pushable -t");
            Messaging.send(sender, "<f>To have the NPC return when pushed, use '-r'.");
            Messaging.send(sender, "<f>Change the return delay with '--delay #'.");
            Messaging.send(sender, "");
        }
        Messaging.sendInfo(sender, npc.getName() + (trait.isPushable() ? " is" : " is not") + " currently pushable" + (trait.isReturnable() ? " and will return when pushed after " + trait.getDelay() + " seconds." : "."));
    }

    @Command(aliases={"npc"}, usage="constant --set|remove name --value constant value", desc="Views/adds/removes NPC string constants.", flags="r", modifiers={"constants", "constant", "cons"}, min=1, max=3, permission="denizen.npc.constants")
    @Requirements(selected=true, ownership=true)
    public void constants(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ConstantsTrait trait = (ConstantsTrait)npc.getOrAddTrait(ConstantsTrait.class);
        if (args.hasValueFlag("set")) {
            if (!args.hasValueFlag("value")) {
                throw new CommandException("--SET requires use of the '--VALUE \"constant value\"' argument.");
            }
            trait.setConstant(args.getFlag("set"), args.getFlag("value"));
            Messaging.sendInfo(sender, npc.getName() + " has added constant '" + args.getFlag("set") + "'.");
            return;
        }
        if (args.hasValueFlag("remove")) {
            trait.removeConstant(args.getFlag("remove"));
            Messaging.sendInfo(sender, npc.getName() + " has removed constant '" + args.getFlag("remove") + "'.");
            return;
        }
        Messaging.send(sender, "");
        Messaging.send(sender, "<f>Use '--set name' to add/set a new NPC-specific constant.");
        Messaging.send(sender, "<f>Must also specify '--value \"constant value\"'.");
        Messaging.send(sender, "<b>Example: /npc constant --set constant_1 --value \"test value\"");
        Messaging.send(sender, "<f>Remove NPC-specific constants with '--remove name'");
        Messaging.send(sender, "<f>Note: Constants set will override any specified in an");
        Messaging.send(sender, "<f>assignment. Constants specified in assignments cannot be");
        Messaging.send(sender, "<f>removed with this command.");
        Messaging.send(sender, "");
    }

    @Command(aliases={"npc"}, usage="assignment ((--set|--remove|--add) assignment_name) (-c)", desc="Controls the assignment for an NPC.", flags="rc", modifiers={"assignment", "assign"}, min=1, max=3, permission="denizen.npc.assign")
    @Requirements(selected=true, ownership=true)
    public void assignment(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.hasFlag('r') || args.hasFlag('c')) {
            if (!npc.hasTrait(AssignmentTrait.class)) {
                Messaging.sendError(sender, "That NPC has no assignments.");
                return;
            }
            ((AssignmentTrait)npc.getOrAddTrait(AssignmentTrait.class)).clearAssignments(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            npc.removeTrait(AssignmentTrait.class);
            Messaging.sendInfo(sender, npc.getName() + "<f>'s assignments have been cleared.");
            return;
        }
        if (args.hasValueFlag("set")) {
            String script = args.getFlag("set").replace("\"", "");
            Object container = ScriptRegistry.getScriptContainer(script);
            if (container == null) {
                Messaging.sendError(sender, "Invalid assignment! Has the script successfully loaded, or has it been misspelled?");
            } else if (!(container instanceof AssignmentScriptContainer)) {
                Messaging.sendError(sender, "A script with that name exists, but it is not an assignment script!");
            } else {
                AssignmentTrait trait = (AssignmentTrait)npc.getOrAddTrait(AssignmentTrait.class);
                trait.clearAssignments(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
                trait.addAssignmentScript((AssignmentScriptContainer)container, PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
                Messaging.sendInfo(sender, npc.getName() + "<f>'s assignment is now just: '" + ((ScriptContainer)container).getName() + "'.");
            }
            return;
        }
        if (args.hasValueFlag("add")) {
            String script = args.getFlag("add").replace("\"", "");
            Object container = ScriptRegistry.getScriptContainer(script);
            AssignmentTrait trait = (AssignmentTrait)npc.getOrAddTrait(AssignmentTrait.class);
            if (container == null) {
                Messaging.sendError(sender, "Invalid assignment! Has the script successfully loaded, or has it been misspelled?");
            } else if (!(container instanceof AssignmentScriptContainer)) {
                Messaging.sendError(sender, "A script with that name exists, but it is not an assignment script!");
            } else if (trait.addAssignmentScript((AssignmentScriptContainer)container, PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player))) {
                Messaging.sendInfo(sender, npc.getName() + "<f> is now assigned to '" + ((ScriptContainer)container).getName() + "'.");
            } else {
                Messaging.sendError(sender, "That NPC was already assigned that script.");
            }
            return;
        }
        if (args.hasValueFlag("remove")) {
            String script = args.getFlag("remove").replace("\"", "");
            AssignmentTrait trait = (AssignmentTrait)npc.getOrAddTrait(AssignmentTrait.class);
            if (trait.removeAssignmentScript(script, PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player))) {
                trait.checkAutoRemove();
                if (npc.hasTrait(AssignmentTrait.class)) {
                    Messaging.sendInfo(sender, npc.getName() + "<f> is no longer assigned to '" + script + "'.");
                } else {
                    Messaging.sendInfo(sender, npc.getName() + "<f> no longer has any assignment.");
                }
            } else {
                Messaging.sendError(sender, "That NPC was already not assigned that script.");
            }
            return;
        }
        Messaging.send(sender, "");
        Messaging.send(sender, "<f>Use '--set name' to set a single assignment script to this NPC.");
        Messaging.send(sender, "<b>Example: /npc assignment --set \"Magic Shop\"");
        Messaging.send(sender, "<f>Use '--add name' to add an assignment, or '--remove name' to remove one assignment.");
        Messaging.send(sender, "<f>Clear all assignments with '-c'.");
        Messaging.send(sender, "<f>Note: Assigning a script will fire an 'On Assignment:' action.");
        Messaging.send(sender, "");
    }

    @Command(aliases={"npc"}, usage="trigger [trigger name] [(--cooldown [seconds])|(--radius [radius])|(-t)]", desc="Controls the various triggers for an NPC.", flags="t", modifiers={"trigger", "tr"}, min=1, max=3, permission="denizen.npc.trigger")
    @Requirements(selected=true, ownership=true)
    public void trigger(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        TriggerTrait trait = (TriggerTrait)npc.getOrAddTrait(TriggerTrait.class);
        if (args.hasValueFlag("name") || args.argsLength() > 1 && args.getJoinedStrings(1) != null && !args.getString(1).matches("\\d+")) {
            String triggerName = args.hasValueFlag("name") ? args.getFlag("name") : args.getJoinedStrings(1);
            if (Denizen.getInstance().triggerRegistry.get(triggerName) == null) {
                Messaging.sendError(sender, "'" + triggerName.toUpperCase() + "' trigger does not exist.");
                Messaging.send(sender, "<f>Usage: /npc trigger [trigger_name] [(--cooldown #)|(--radius #)|(-t)]");
                Messaging.send(sender, "");
                Messaging.send(sender, "<f>Use '--name trigger_name' to specify a specific trigger, and '-t' to toggle.");
                Messaging.send(sender, "<b>Example: /npc trigger --name damage -t");
                Messaging.send(sender, "<f>You may also use '--cooldown #' to specify a new cooldown time, and '--radius #' to specify a specific radius, when applicable.");
                Messaging.send(sender, "");
                return;
            }
            if (args.hasFlag('t')) {
                trait.toggleTrigger(triggerName);
            }
            if (args.hasValueFlag("cooldown")) {
                trait.setLocalCooldown(triggerName, args.getFlagDouble("cooldown"));
            }
            if (args.hasValueFlag("radius")) {
                trait.setLocalRadius(triggerName, args.getFlagInteger("radius"));
                Messaging.sendInfo(sender, triggerName.toUpperCase() + " trigger radius now " + args.getFlag("radius") + ".");
            }
            Messaging.sendInfo(sender, triggerName.toUpperCase() + " trigger " + (trait.isEnabled(triggerName) ? "is" : "is not") + " currently enabled" + (trait.isEnabled(triggerName) ? " with a cooldown of '" + trait.getCooldownDuration(triggerName) + "' seconds." : "."));
            return;
        }
        try {
            trait.describe(sender, args.getInteger(1, 1));
        }
        catch (CommandException e) {
            throw new CommandException(e.getMessage());
        }
    }

    @Command(aliases={"npc"}, usage="nickname [--set nickname]", desc="Gives the NPC a nickname, used with a Denizen-compatible Speech Engine.", modifiers={"nickname", "nick", "ni"}, min=1, max=3, permission="denizen.npc.nickname")
    @Requirements(selected=true, ownership=true)
    public void nickname(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        NicknameTrait trait = (NicknameTrait)npc.getOrAddTrait(NicknameTrait.class);
        if (args.hasValueFlag("set")) {
            trait.setNickname(args.getFlag("set"));
            Messaging.send(sender, "Nickname set.");
            return;
        }
        if (args.hasFlag('r')) {
            trait.setNickname("");
            Messaging.sendInfo(sender, "Nickname removed.");
            return;
        }
        if (trait.hasNickname()) {
            Messaging.sendInfo(sender, npc.getName() + "'s nickname is '" + trait.getNickname() + "'.");
        } else {
            Messaging.sendInfo(sender, npc.getName() + " does not have a nickname!");
        }
    }

    @Command(aliases={"npc"}, usage="sit (--location x,y,z,world) (--anchor anchor_name) (-c)", desc="Makes the NPC sit.", flags="c", modifiers={"sit"}, min=1, max=3, permission="denizen.npc.sit")
    @Requirements(selected=true, ownership=true)
    public void sitting(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location targetLocation;
        if (npc.hasTrait(SneakingTrait.class)) {
            ((SneakingTrait)npc.getOrAddTrait(SneakingTrait.class)).stand();
            npc.removeTrait(SneakingTrait.class);
        }
        if (npc.hasTrait(SleepingTrait.class)) {
            ((SleepingTrait)npc.getOrAddTrait(SleepingTrait.class)).wakeUp();
            npc.removeTrait(SleepingTrait.class);
        }
        SittingTrait trait = (SittingTrait)npc.getOrAddTrait(SittingTrait.class);
        if (args.hasValueFlag("location")) {
            LocationTag location = LocationTag.valueOf(args.getFlag("location"), CoreUtilities.basicContext);
            if (location == null) {
                Messaging.sendError(sender, "Usage: /npc sit --location x,y,z,world");
                return;
            }
            trait.sit(location);
            return;
        }
        if (args.hasValueFlag("anchor")) {
            Anchors anchors;
            if (npc.hasTrait(Anchors.class) && (anchors = (Anchors)npc.getOrAddTrait(Anchors.class)).getAnchor(args.getFlag("anchor")) != null) {
                trait.sit(anchors.getAnchor(args.getFlag("anchor")).getLocation());
                Messaging.send(sender, npc.getName() + " is now sitting.");
                return;
            }
            Messaging.sendError(sender, "The NPC does not have the specified anchor!");
            return;
        }
        if (args.hasFlag('c')) {
            targetLocation = args.getSenderTargetBlockLocation().clone().add(0.5, 0.0, 0.5);
            targetLocation.setYaw(npc.getStoredLocation().getYaw());
        } else {
            targetLocation = npc.getStoredLocation().clone();
            targetLocation.add(0.0, -0.2, 0.0);
        }
        if (trait.isSitting()) {
            Messaging.send(sender, npc.getName() + " is already sitting, use '/npc stand' to stand the NPC back up.");
            return;
        }
        Block block = targetLocation.getBlock();
        BlockData data = block.getBlockData();
        if (data instanceof Stairs || data instanceof Bed || data instanceof Slab && ((Slab)data).getType() == Slab.Type.BOTTOM) {
            targetLocation.setY((double)targetLocation.getBlockY() + 0.3);
        } else if (data instanceof Campfire) {
            targetLocation.setY((double)targetLocation.getBlockY() + 0.2);
        } else if (block.getType().name().endsWith("CARPET")) {
            targetLocation.setY((double)targetLocation.getBlockY());
        } else if (block.getType().isSolid()) {
            targetLocation.setY((double)targetLocation.getBlockY() + 0.8);
        }
        trait.sit(targetLocation);
        Messaging.send(sender, npc.getName() + " is now sitting.");
    }

    @Command(aliases={"npc"}, usage="stand", desc="Makes the NPC stand.", modifiers={"stand"}, min=1, max=1, permission="denizen.npc.stand")
    @Requirements(selected=true, ownership=true)
    public void standing(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc.hasTrait(SittingTrait.class)) {
            SittingTrait trait = (SittingTrait)npc.getOrAddTrait(SittingTrait.class);
            if (!trait.isSitting()) {
                npc.removeTrait(SittingTrait.class);
                Messaging.sendError(sender, npc.getName() + " is already standing!");
                return;
            }
            trait.stand();
            npc.removeTrait(SittingTrait.class);
            Messaging.send(sender, npc.getName() + " is now standing.");
        } else if (npc.hasTrait(SneakingTrait.class)) {
            SneakingTrait trait = (SneakingTrait)npc.getOrAddTrait(SneakingTrait.class);
            if (!trait.isSneaking()) {
                npc.removeTrait(SneakingTrait.class);
                Messaging.sendError(sender, npc.getName() + " is already standing!");
                return;
            }
            trait.stand();
            npc.removeTrait(SneakingTrait.class);
            Messaging.send(sender, npc.getName() + " is now standing.");
        } else if (npc.hasTrait(SleepingTrait.class)) {
            SleepingTrait trait = (SleepingTrait)npc.getOrAddTrait(SleepingTrait.class);
            if (!trait.isSleeping()) {
                npc.removeTrait(SleepingTrait.class);
                Messaging.sendError(sender, npc.getName() + " is already standing!");
                return;
            }
            trait.wakeUp();
            npc.removeTrait(SleepingTrait.class);
            Messaging.send(sender, npc.getName() + " is now standing.");
        } else {
            Messaging.sendError(sender, npc.getName() + " is already standing!");
        }
    }

    @Command(aliases={"npc"}, usage="sleep (--location x,y,z,world) (--anchor anchor_name)", desc="Makes the NPC sleep.", modifiers={"sleep"}, min=1, max=3, permission="denizen.npc.sleep")
    @Requirements(selected=true, ownership=true, types={EntityType.VILLAGER, EntityType.PLAYER})
    public void sleeping(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        SleepingTrait trait;
        if (npc.hasTrait(SneakingTrait.class)) {
            ((SneakingTrait)npc.getOrAddTrait(SneakingTrait.class)).stand();
            npc.removeTrait(SneakingTrait.class);
        }
        if (npc.hasTrait(SittingTrait.class)) {
            ((SittingTrait)npc.getOrAddTrait(SittingTrait.class)).stand();
            npc.removeTrait(SittingTrait.class);
        }
        if ((trait = (SleepingTrait)npc.getOrAddTrait(SleepingTrait.class)).isSleeping()) {
            Messaging.send(sender, npc.getName() + " was already sleeping, and is now standing!");
            trait.wakeUp();
            npc.removeTrait(SleepingTrait.class);
            return;
        }
        if (args.hasValueFlag("location")) {
            LocationTag location = LocationTag.valueOf(args.getFlag("location"), CoreUtilities.basicContext);
            if (location == null) {
                Messaging.sendError(sender, "Usage: /npc sleep --location x,y,z,world");
                return;
            }
            trait.toSleep(location);
        } else {
            if (args.hasValueFlag("anchor")) {
                Anchors anchors;
                if (npc.hasTrait(Anchors.class) && (anchors = (Anchors)npc.getOrAddTrait(Anchors.class)).getAnchor(args.getFlag("anchor")) != null) {
                    trait.toSleep(anchors.getAnchor(args.getFlag("anchor")).getLocation());
                    Messaging.send(sender, npc.getName() + " is now sleeping.");
                    return;
                }
                Messaging.sendError(sender, "The NPC does not have the specified anchor!");
                return;
            }
            trait.toSleep();
        }
        if (!trait.isSleeping()) {
            npc.removeTrait(SleepingTrait.class);
        }
        Messaging.send(sender, npc.getName() + " is now sleeping.");
    }

    @Command(aliases={"npc"}, usage="wakeup", desc="Makes the NPC wake up.", modifiers={"wakeup"}, min=1, max=1, permission="denizen.npc.sleep")
    @Requirements(selected=true, ownership=true)
    public void wakingup(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        SleepingTrait trait = (SleepingTrait)npc.getOrAddTrait(SleepingTrait.class);
        if (!trait.isSleeping()) {
            npc.removeTrait(SleepingTrait.class);
            Messaging.sendError(sender, npc.getName() + " is already awake!");
            return;
        }
        trait.wakeUp();
        npc.removeTrait(SleepingTrait.class);
        Messaging.send(sender, npc.getName() + " is no longer sleeping.");
    }

    @Command(aliases={"npc"}, usage="fish (--location x,y,z,world) (--anchor anchor_name) (-c) (--reel_time <duration>) (--cast_time <duration>)", desc="Makes the NPC fish, casting at the given location.", flags="c", modifiers={"fish"}, min=1, max=3, permission="denizen.npc.fish")
    @Requirements(selected=true, ownership=true)
    public void startFishing(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        DurationTag duration;
        FishingTrait trait = (FishingTrait)npc.getOrAddTrait(FishingTrait.class);
        if (trait.isFishing()) {
            Messaging.sendError(sender, npc.getName() + " is already fishing! Use '/npc stopfishing' to stop.");
            return;
        }
        if (args.hasValueFlag("percent")) {
            trait.setCatchPercent(args.getFlagInteger("percent"));
        }
        if (args.hasValueFlag("reel_time")) {
            duration = DurationTag.valueOf(args.getFlag("reel_time"), CoreUtilities.basicContext);
            if (duration == null) {
                Messaging.sendError(sender, "Invalid reel duration.");
                return;
            }
            trait.reelTickRate = duration.getTicksAsInt();
            Messaging.send(sender, "Set reel rate to " + duration.formatted(true));
        }
        if (args.hasValueFlag("cast_time")) {
            duration = DurationTag.valueOf(args.getFlag("cast_time"), CoreUtilities.basicContext);
            if (duration == null) {
                Messaging.sendError(sender, "Invalid cast duration.");
                return;
            }
            trait.reelTickRate = duration.getTicksAsInt();
            Messaging.send(sender, "Set cast rate to " + duration.formatted(true));
        }
        if (args.hasFlag('c')) {
            trait.startFishing(args.getSenderTargetBlockLocation());
        } else if (args.hasValueFlag("location")) {
            String[] argsArray = args.getFlag("location").split(",");
            if (argsArray.length != 4) {
                Messaging.sendError(sender, "Usage: /npc fish --location x,y,z,world");
                return;
            }
            trait.startFishing(LocationTag.valueOf(argsArray[0] + "," + argsArray[1] + "," + argsArray[2] + "," + argsArray[3], CoreUtilities.basicContext));
        } else if (args.hasValueFlag("anchor")) {
            Anchors anchors;
            if (npc.hasTrait(Anchors.class) && (anchors = (Anchors)npc.getOrAddTrait(Anchors.class)).getAnchor(args.getFlag("anchor")) != null) {
                trait.startFishing(anchors.getAnchor(args.getFlag("anchor")).getLocation());
            }
            Messaging.sendError(sender, "The NPC does not have the specified anchor!");
        } else {
            trait.startFishing();
        }
        Messaging.send(sender, npc.getName() + " is now fishing.");
    }

    @Command(aliases={"npc"}, usage="stopfishing", desc="Makes the NPC stop fishing.", modifiers={"stopfishing"}, min=1, max=1, permission="denizen.npc.fish")
    @Requirements(selected=true, ownership=true)
    public void stopFishing(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        FishingTrait trait = (FishingTrait)npc.getOrAddTrait(FishingTrait.class);
        if (!trait.isFishing()) {
            npc.removeTrait(FishingTrait.class);
            Messaging.sendError(sender, npc.getName() + " isn't fishing!");
            return;
        }
        trait.stopFishing();
        npc.removeTrait(FishingTrait.class);
        Messaging.send(sender, npc.getName() + " is no longer fishing.");
    }

    @Command(aliases={"npc"}, usage="sneak", desc="Makes the NPC crouch.", modifiers={"sneak", "crouch"}, min=1, max=1, permission="denizen.npc.sneak")
    @Requirements(selected=true, ownership=true)
    public void sneaking(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc.hasTrait(SleepingTrait.class)) {
            ((SleepingTrait)npc.getOrAddTrait(SleepingTrait.class)).wakeUp();
            npc.removeTrait(SleepingTrait.class);
        }
        if (npc.hasTrait(SleepingTrait.class)) {
            ((SleepingTrait)npc.getOrAddTrait(SleepingTrait.class)).wakeUp();
            npc.removeTrait(SleepingTrait.class);
        }
        if (npc.getEntity().getType() != EntityType.PLAYER) {
            Messaging.sendError(sender, npc.getName() + " needs to be a Player type NPC to sneak!");
            return;
        }
        SneakingTrait trait = (SneakingTrait)npc.getOrAddTrait(SneakingTrait.class);
        if (trait.isSneaking()) {
            trait.stand();
            Messaging.send(sender, npc.getName() + " was already sneaking, and is now standing.");
        } else {
            trait.sneak();
            Messaging.send(sender, npc.getName() + " is now sneaking.");
        }
    }

    @Command(aliases={"npc"}, usage="mirrorskin", desc="Makes the NPC mirror the skin of the player looking at it.", modifiers={"mirrorskin", "mirror"}, min=1, max=1, permission="denizen.npc.mirror")
    @Requirements(selected=true, ownership=true)
    public void mirror(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc.getEntity().getType() != EntityType.PLAYER) {
            Messaging.sendError(sender, npc.getName() + " needs to be a Player type NPC to be a skin-mirror!");
            return;
        }
        if (!npc.hasTrait(MirrorTrait.class)) {
            ((MirrorTrait)npc.getOrAddTrait(MirrorTrait.class)).enableMirror();
            Messaging.send(sender, npc.getName() + " is now mirroring player skins.");
            return;
        }
        MirrorTrait trait = (MirrorTrait)npc.getOrAddTrait(MirrorTrait.class);
        if (trait.mirror) {
            trait.disableMirror();
            npc.removeTrait(MirrorTrait.class);
            Messaging.send(sender, npc.getName() + " is no longer mirroring player skins.");
        } else {
            trait.enableMirror();
            Messaging.send(sender, npc.getName() + " is now mirroring player skins.");
        }
    }

    @Command(aliases={"npc"}, usage="mirrorname", desc="Makes the NPC mirror the username of the player looking at it.", modifiers={"mirrorname"}, min=1, max=1, permission="denizen.npc.mirror")
    @Requirements(selected=true, ownership=true)
    public void mirrorName(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(MirrorNameTrait.class)) {
            ((MirrorNameTrait)npc.getOrAddTrait(MirrorNameTrait.class)).enableMirror();
            Messaging.send(sender, npc.getName() + " is now mirroring player names.");
            return;
        }
        MirrorNameTrait trait = (MirrorNameTrait)npc.getOrAddTrait(MirrorNameTrait.class);
        if (trait.mirror) {
            trait.disableMirror();
            npc.removeTrait(MirrorNameTrait.class);
            Messaging.send(sender, npc.getName() + " is no longer mirroring player names.");
        } else {
            trait.enableMirror();
            Messaging.send(sender, npc.getName() + " is now mirroring player names.");
        }
    }

    @Command(aliases={"npc"}, usage="mirrorequipment", desc="Makes the NPC mirror the equipment of the player looking at it.", modifiers={"mirrorequipment", "mirrorequip"}, min=1, max=1, permission="denizen.npc.mirror")
    @Requirements(selected=true, ownership=true)
    public void mirrorEquipment(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(MirrorEquipmentTrait.class)) {
            ((MirrorEquipmentTrait)npc.getOrAddTrait(MirrorEquipmentTrait.class)).enableMirror();
            Messaging.send(sender, npc.getName() + " is now mirroring player equipment.");
            return;
        }
        MirrorEquipmentTrait trait = (MirrorEquipmentTrait)npc.getOrAddTrait(MirrorEquipmentTrait.class);
        if (trait.mirror) {
            trait.disableMirror();
            npc.removeTrait(MirrorEquipmentTrait.class);
            Messaging.send(sender, npc.getName() + " is no longer mirroring player equipment.");
        } else {
            trait.enableMirror();
            Messaging.send(sender, npc.getName() + " is now mirroring player equipment.");
        }
    }

    @Command(aliases={"npc"}, usage="invisible", desc="Turns the NPC invisible.", modifiers={"invisible"}, min=1, max=3, permission="denizen.npc.invisible")
    @Requirements(selected=true, ownership=true)
    public void invisible(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(InvisibleTrait.class)) {
            ((InvisibleTrait)npc.getOrAddTrait(InvisibleTrait.class)).setInvisible(true);
            Messaging.send(sender, npc.getName() + " is now invisible.");
            return;
        }
        InvisibleTrait trait = (InvisibleTrait)npc.getOrAddTrait(InvisibleTrait.class);
        trait.toggle();
        if (trait.isInvisible()) {
            Messaging.send(sender, npc.getName() + " is now invisible.");
        } else {
            Messaging.send(sender, npc.getName() + " is no longer invisible.");
        }
    }

    @Command(aliases={"npc"}, usage="health (--set #) (--max #) (-r)", desc="Sets the max health for an NPC.", modifiers={"health", "he", "hp"}, min=1, max=3, permission="denizen.npc.health", flags="sra")
    @Requirements(selected=true, ownership=true)
    public void health(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        HealthTrait trait = (HealthTrait)npc.getOrAddTrait(HealthTrait.class);
        boolean showMore = true;
        if (args.hasValueFlag("max")) {
            trait.setMaxhealth(args.getFlagInteger("max"));
            trait.setHealth();
            Messaging.send(sender, npc.getName() + "'s health maximum is now " + trait.getMaxhealth() + ".");
            showMore = false;
        }
        if (args.hasValueFlag("set")) {
            trait.setHealth(args.getFlagInteger("set"));
        }
        if (args.hasValueFlag("respawndelay")) {
            trait.setRespawnDelay(args.getFlag("respawndelay"));
            Messaging.send(sender, npc.getName() + "'s respawn delay now " + trait.getRespawnDelay() + (trait.isRespawnable() ? "." : ", but is not currently auto-respawnable upon death."));
            showMore = false;
        }
        if (args.hasValueFlag("respawnlocation")) {
            trait.setRespawnLocation(args.getFlag("respawnlocation"));
            Messaging.send(sender, npc.getName() + "'s respawn location now " + trait.getRespawnLocationAsString() + (trait.isRespawnable() ? "." : ", but is not currently auto-respawnable upon death."));
            showMore = false;
        }
        if (args.hasFlag('s')) {
            trait.setRespawnable(!trait.isRespawnable());
            Messaging.send(sender, npc.getName() + (trait.isRespawnable() ? " will now auto-respawn on death after " + trait.getRespawnDelay() + " seconds." : " will no longer auto-respawn on death."));
            showMore = false;
        }
        if (args.hasFlag('a')) {
            trait.animateOnDeath(!trait.animatesOnDeath());
            Messaging.send(sender, npc.getName() + (trait.animatesOnDeath() ? " will now animate on death." : " will no longer animate on death."));
            showMore = false;
        } else if (args.hasFlag('r')) {
            trait.setHealth();
            Messaging.send(sender, npc.getName() + "'s health reset to " + trait.getMaxhealth() + ".");
            showMore = false;
        }
        if (showMore) {
            Messaging.sendInfo(sender, npc.getName() + "'s health is '" + trait.getHealth() + "/" + trait.getMaxhealth() + "'.");
        }
    }
}

