/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ZombieVillager;

public class EntityConversionPlayer
implements Property {
    public static final String[] handledMechs = new String[]{"conversion_player"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        Entity entity = ((EntityTag)object).getBukkitEntity();
        return entity instanceof ZombieVillager;
    }

    public static EntityConversionPlayer getFrom(ObjectTag entity) {
        if (!EntityConversionPlayer.describes(entity)) {
            return null;
        }
        return new EntityConversionPlayer((EntityTag)entity);
    }

    private EntityConversionPlayer(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        OfflinePlayer player = this.getZombieVillager().getConversionPlayer();
        if (player != null && player.hasPlayedBefore()) {
            return new PlayerTag(player).identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "conversion_player";
    }

    public static void registerTags() {
        PropertyParser.registerTag(PlayerTag.class, "conversion_player", (attribute, object) -> {
            OfflinePlayer player = object.getZombieVillager().getConversionPlayer();
            if (player != null && player.hasPlayedBefore()) {
                return new PlayerTag(player);
            }
            return null;
        }, new String[0]);
    }

    public ZombieVillager getZombieVillager() {
        return (ZombieVillager)this.entity.getBukkitEntity();
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("conversion_player")) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(PlayerTag.class)) {
                    this.getZombieVillager().setConversionPlayer(mechanism.valueAsType(PlayerTag.class).getOfflinePlayer());
                }
            } else {
                this.getZombieVillager().setConversionPlayer(null);
            }
        }
    }
}

