/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.ReflectionRefuse;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.function.Function;

public class ReflectionSetCommand
extends AbstractCommand {
    public static HashMap<Class<?>, Function<ObjectTag, Object>> typeConverters = new HashMap();

    public ReflectionSetCommand() {
        this.setName("reflectionset");
        this.setSyntax("reflectionset [object:<object>] [field:<name>] (value:<value>)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
        this.setPrefixesHandled("object", "field", "value");
    }

    public static Object convertObjectTypeFor(Class<?> type, ObjectTag value) {
        Object res;
        if (value == null) {
            return null;
        }
        if (value instanceof JavaReflectedObjectTag) {
            return ((JavaReflectedObjectTag)value).object;
        }
        Object javaForm = value.getJavaObject();
        if (javaForm != null && type.isAssignableFrom(javaForm.getClass())) {
            return javaForm;
        }
        Function<ObjectTag, Object> converter = typeConverters.get(type);
        if (converter != null && (res = converter.apply(value)) != null) {
            return res;
        }
        if (type.isEnum()) {
            Object enumVal = value.asElement().asEnum(type);
            if (enumVal == null) {
                Debug.echoError("Cannot convert value '" + value + "' to type '" + type.getName() + "' - value is not recognized as an enum constant.");
            }
            return enumVal;
        }
        Debug.echoError("Cannot convert value '" + value + "' to type '" + type.getName() + "' - no known conversion registered.");
        return null;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Class<?> clazz;
        if (!CoreConfiguration.allowReflectionSet) {
            Debug.echoError("The 'reflectionset' command is disabled in the Denizen config.");
            return;
        }
        JavaReflectedObjectTag object = scriptEntry.requiredArgForPrefix("object", JavaReflectedObjectTag.class);
        ElementTag fieldName = scriptEntry.requiredArgForPrefixAsElement("field");
        ObjectTag value = scriptEntry.argForPrefix("value", ObjectTag.class, true);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), object, fieldName, value);
        }
        Field field = null;
        if (object.object instanceof Class) {
            clazz = (Class<?>)object.object;
            field = ReflectionHelper.getFields(clazz).get(fieldName.asString());
            if (field == null) {
                Debug.echoError("Field '" + fieldName + "' does not exist in class: " + ((Class)object.object).getName());
                return;
            }
        } else {
            clazz = object.object.getClass();
            while (field == null && clazz != Object.class) {
                field = ReflectionHelper.getFields(clazz).get(fieldName.asString());
                if (field != null) continue;
                clazz = clazz.getSuperclass();
            }
            if (field == null) {
                Debug.echoError("Field '" + fieldName + "' does not exist in class: " + object.object.getClass().getName());
                return;
            }
        }
        if (field.isAnnotationPresent(ReflectionRefuse.class) || field.getType().isAnnotationPresent(ReflectionRefuse.class)) {
            Debug.echoError("Cannot ReflectionSet field '" + field + "' because it is marked for reflection refusal.");
            return;
        }
        if (!Modifier.isPublic(field.getModifiers()) && !CoreConfiguration.allowReflectionSetPrivate) {
            Debug.echoError("Cannot ReflectionSet field '" + field + "' because it is private, and modifying private fields is disabled in the Denizen config.");
            return;
        }
        if (Modifier.isFinal(field.getModifiers()) && !CoreConfiguration.allowReflectionSetFinal) {
            Debug.echoError("Cannot ReflectionSet field '" + field + "' because it is final, and modifying private fields is disabled in the Denizen config.");
            return;
        }
        Object setVal = ReflectionSetCommand.convertObjectTypeFor(field.getType(), value);
        if (setVal == null && value != null) {
            return;
        }
        MethodHandle handle = ReflectionHelper.getFinalSetter(clazz, field.getName());
        try {
            if (object.object instanceof Class) {
                handle.invoke(setVal);
            } else {
                handle.invoke(object.object, setVal);
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    static {
        typeConverters.put(Byte.TYPE, o -> (byte)o.asElement().asInt());
        typeConverters.put(Byte.class, o -> (byte)o.asElement().asInt());
        typeConverters.put(Short.TYPE, o -> (short)o.asElement().asInt());
        typeConverters.put(Short.class, o -> (short)o.asElement().asInt());
        typeConverters.put(Integer.TYPE, o -> o.asElement().asInt());
        typeConverters.put(Integer.class, o -> o.asElement().asInt());
        typeConverters.put(Long.TYPE, o -> o.asElement().asLong());
        typeConverters.put(Long.class, o -> o.asElement().asLong());
        typeConverters.put(Float.TYPE, o -> Float.valueOf(o.asElement().asFloat()));
        typeConverters.put(Float.class, o -> Float.valueOf(o.asElement().asFloat()));
        typeConverters.put(Double.TYPE, o -> o.asElement().asDouble());
        typeConverters.put(Double.class, o -> o.asElement().asDouble());
        typeConverters.put(Boolean.TYPE, o -> o.asElement().asBoolean());
        typeConverters.put(Boolean.class, o -> o.asElement().asBoolean());
        typeConverters.put(String.class, o -> o.asElement().asString());
    }
}

