/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffectType;

public class EntityDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public ElementTag cause;
    public EntityTag damager;
    public EntityTag projectile;
    public ItemTag held;
    public EntityDamageEvent event;

    public EntityDamagedScriptEvent() {
        this.registerCouldMatcher("<entity> damaged (by <'cause'>)");
        this.registerCouldMatcher("<entity> damaged by <entity>");
        this.registerCouldMatcher("<entity> damages <entity>");
        this.registerSwitches("with", "type");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("damaged")) {
            if (path.eventArgLowerAt(0).equals("vehicle")) {
                return false;
            }
        } else if (cmd.equals("damages")) {
            if (path.eventArgLowerAt(2).equals("vehicle")) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target;
        String cmd = path.eventArgLowerAt(1);
        String attacker = cmd.equals("damages") ? path.eventArgLowerAt(0) : (path.eventArgLowerAt(2).equals("by") ? path.eventArgLowerAt(3) : "");
        String string = target = cmd.equals("damages") ? path.eventArgLowerAt(2) : path.eventArgLowerAt(0);
        if (!attacker.isEmpty() && (this.damager != null ? !(this.cause.asString().equals(attacker) || this.projectile != null && this.projectile.tryAdvancedMatcher(attacker) || this.damager != null && this.damager.tryAdvancedMatcher(attacker)) : !this.cause.asString().equals(attacker))) {
            return false;
        }
        if (!this.entity.tryAdvancedMatcher(target) || !path.tryObjectSwitch("type", this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!EntityDamagedScriptEvent.runWithCheck(path, this.held)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            if (CoreUtilities.equalsIgnoreCase(determinationObj.toString(), "clear_modifiers")) {
                for (EntityDamageEvent.DamageModifier modifier : EntityDamageEvent.DamageModifier.values()) {
                    if (modifier == EntityDamageEvent.DamageModifier.BASE || !this.event.isApplicable(modifier)) continue;
                    this.event.setDamage(modifier, 0.0);
                }
                return true;
            }
            if (((ElementTag)determinationObj).isDouble()) {
                this.event.setDamage(((ElementTag)determinationObj).asDouble());
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.damager != null && this.damager.isPlayer() ? this.damager.getDenizenPlayer() : (this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null), this.damager != null && this.damager.isCitizensNPC() ? this.damager.getDenizenNPC() : (this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null));
    }

    public boolean calculateWasCritical() {
        if (!(this.event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        if (!this.damager.isPlayer()) {
            return false;
        }
        if (this.event.getDamage() <= 0.9) {
            return false;
        }
        if (!(this.event.getEntity() instanceof LivingEntity)) {
            return false;
        }
        Player player = this.damager.getPlayer();
        if ((double)NMSHandler.playerHelper.getAttackCooldownPercent(player) < 0.999) {
            return false;
        }
        if (player.getFallDistance() <= 0.0f || player.isOnGround() || player.isClimbing() || player.isInWater()) {
            return false;
        }
        if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
            return false;
        }
        return !player.isInsideVehicle();
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "damage": {
                return new ElementTag(this.event.getDamage());
            }
            case "final_damage": {
                return new ElementTag(this.event.getFinalDamage());
            }
            case "cause": {
                return this.cause;
            }
            case "damager": {
                if (this.damager == null) break;
                return this.damager.getDenizenObject();
            }
            case "projectile": {
                if (this.projectile == null) break;
                return this.projectile.getDenizenObject();
            }
            case "damage_type_map": {
                MapTag map = new MapTag();
                for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
                    map.putObject(dm.name(), new ElementTag(this.event.getDamage(dm)));
                }
                return map;
            }
            case "was_critical": {
                return new ElementTag(this.calculateWasCritical());
            }
        }
        if (name.startsWith("damage_")) {
            BukkitImplDeprecations.damageEventTypeMap.warn();
            for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
                if (!name.equals("damage_" + CoreUtilities.toLowerCase(dm.name()))) continue;
                return new ElementTag(this.event.getDamage(dm));
            }
        }
        return super.getContext((String)name);
    }

    @EventHandler
    public void onEntityDamaged(EntityDamageEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.cause = new ElementTag(CoreUtilities.toLowerCase(event.getCause().name()));
        this.damager = null;
        this.projectile = null;
        this.held = null;
        if (event instanceof EntityDamageByEntityEvent) {
            this.damager = new EntityTag(((EntityDamageByEntityEvent)event).getDamager());
            EntityTag shooter = this.damager.getShooter();
            if (this.damager instanceof Projectile) {
                this.projectile = this.damager;
            }
            if (shooter != null) {
                this.projectile = this.damager;
                this.damager = shooter;
            }
            if (this.damager != null) {
                this.held = this.damager.getItemInHand();
                if (this.held != null) {
                    this.held.setAmount(1);
                }
            }
        }
        this.event = event;
        this.fire((Event)event);
    }
}

