/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizen.utilities.flags.LocationFlagSearchHelper;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class ChunkTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    int chunkX;
    int chunkZ;
    WorldTag world;
    Chunk cachedChunk;
    String prefix = "Chunk";
    public static ObjectTagProcessor<ChunkTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static ChunkTag valueOf(String string) {
        return ChunkTag.valueOf(string, null);
    }

    @Fetchable(value="ch")
    public static ChunkTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = CoreUtilities.toLowerCase(string).replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new ChunkTag(new WorldTag(parts[2]), Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            }
            catch (Exception e) {
                if (context == null || context.showErrors()) {
                    Debug.log("Minor: valueOf ChunkTag returning null: ch@" + string);
                }
                return null;
            }
        }
        if (context == null || context.showErrors()) {
            Debug.log("Minor: valueOf ChunkTag unable to handle malformed format: ch@" + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("ch@");
    }

    public Chunk getChunkForTag(Attribute attribute) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getBukkitWorld());
        try {
            if (!this.isLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Cannot get chunk at " + this.chunkX + ", " + this.chunkZ + ": Chunk is not loaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Chunk chunk = null;
                return chunk;
            }
            Chunk chunk = this.getChunk();
            return chunk;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getBukkitWorld());
        }
    }

    public Chunk getChunk() {
        if (this.cachedChunk == null) {
            this.cachedChunk = this.getBukkitWorld().getChunkAt(this.chunkX, this.chunkZ);
        }
        return this.cachedChunk;
    }

    public ChunkTag(Chunk chunk) {
        this.cachedChunk = chunk;
        this.world = new WorldTag(chunk.getWorld());
        this.chunkX = chunk.getX();
        this.chunkZ = chunk.getZ();
    }

    public ChunkTag(WorldTag world, int x, int z) {
        this.world = world;
        this.chunkX = x;
        this.chunkZ = z;
    }

    public ChunkTag(Location location) {
        this.world = location instanceof LocationTag ? new WorldTag(((LocationTag)location).getWorldName()) : new WorldTag(location.getWorld());
        this.chunkX = location.getBlockX() >> 4;
        this.chunkZ = location.getBlockZ() >> 4;
    }

    public LocationTag getCenter() {
        return new LocationTag(this.getWorldName(), (double)(this.getX() * 16 + 8), 128.0, (double)(this.getZ() * 16 + 8), 0.0f, 0.0f);
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public String getWorldName() {
        return this.world.getName();
    }

    public World getBukkitWorld() {
        return this.world.getWorld();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ChunkTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "ch@" + this.getX() + ',' + this.getZ() + ',' + this.getWorldName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.getChunk();
    }

    public boolean isLoaded() {
        if (this.getBukkitWorld() == null) {
            return false;
        }
        return this.getBukkitWorld().isChunkLoaded(this.chunkX, this.chunkZ);
    }

    public boolean isLoadedSafe() {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(this.getBukkitWorld());
            boolean bl = this.isLoaded();
            return bl;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getBukkitWorld());
        }
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new DataPersistenceFlagTracker((PersistentDataHolder)this.getChunk(), "flag_chunk_");
    }

    @Override
    public AbstractFlagTracker getFlagTrackerForTag() {
        if (!this.isLoadedSafe()) {
            return null;
        }
        return this.getFlagTracker();
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    @Override
    public String getReasonNotFlaggable() {
        return "is the chunk loaded?";
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ChunkTag.class, "add", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ChunkTag.add[<#>,<#>] must have a value.");
                return null;
            }
            List<String> coords = CoreUtilities.split(attribute.getParam(), ',');
            if (coords.size() < 2) {
                attribute.echoError("The tag ChunkTag.add[<#>,<#>] requires two values!");
                return null;
            }
            if (!ArgumentHelper.matchesInteger(coords.get(0)) || !ArgumentHelper.matchesInteger(coords.get(1))) {
                attribute.echoError("Input to ChunkTag.add[x,z] is not a valid integer pair!");
                return null;
            }
            int x = Integer.parseInt(coords.get(0));
            int z = Integer.parseInt(coords.get(1));
            return new ChunkTag(object.world, object.chunkX + x, object.chunkZ + z);
        }, new String[0]);
        tagProcessor.registerTag(ChunkTag.class, "sub", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ChunkTag.add[<#>,<#>] must have a value.");
                return null;
            }
            List<String> coords = CoreUtilities.split(attribute.getParam(), ',');
            if (coords.size() < 2) {
                attribute.echoError("The tag ChunkTag.sub[<#>,<#>] requires two values!");
                return null;
            }
            if (!ArgumentHelper.matchesInteger(coords.get(0)) || !ArgumentHelper.matchesInteger(coords.get(1))) {
                attribute.echoError("Input to ChunkTag.sub[x,z] is not a valid integer pair!");
                return null;
            }
            int x = Integer.parseInt(coords.get(0));
            int z = Integer.parseInt(coords.get(1));
            return new ChunkTag(object.world, object.chunkX - x, object.chunkZ - z);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_generated", (attribute, object) -> new ElementTag(object.getBukkitWorld().isChunkGenerated(object.chunkX, object.chunkZ)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_loaded", (attribute, object) -> new ElementTag(object.isLoadedSafe()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "force_loaded", (attribute, object) -> {
            if (!object.isLoadedSafe()) {
                return new ElementTag(false);
            }
            Chunk chunk = object.getChunkForTag(attribute);
            return new ElementTag(chunk != null && chunk.isForceLoaded());
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "plugin_tickets", (attribute, object) -> {
            if (!object.isLoadedSafe()) {
                return new ListTag();
            }
            Chunk chunk = object.getChunkForTag(attribute);
            ListTag result = new ListTag();
            for (Plugin plugin : chunk.getPluginChunkTickets()) {
                result.addObject(new PluginTag(plugin));
            }
            return result;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "x", (attribute, object) -> new ElementTag(object.chunkX), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "z", (attribute, object) -> new ElementTag(object.chunkZ), new String[0]);
        tagProcessor.registerTag(WorldTag.class, "world", (attribute, object) -> object.world, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "cuboid", (attribute, object) -> {
            World world;
            int yMin = 0;
            int yMax = 255;
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && (world = object.getBukkitWorld()) != null) {
                yMin = world.getMinHeight();
                yMax = world.getMaxHeight();
            }
            return new CuboidTag(new LocationTag(object.getWorldName(), (double)(object.getX() * 16), (double)yMin, (double)(object.getZ() * 16), 0.0f, 0.0f), new LocationTag(object.getWorldName(), (double)(object.getX() * 16 + 15), (double)yMax, (double)(object.getZ() * 16 + 15), 0.0f, 0.0f));
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "tile_entities", (attribute, object) -> {
            ListTag tiles = new ListTag();
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            try {
                NMSHandler.chunkHelper.changeChunkServerThread(object.getBukkitWorld());
                for (BlockState block : chunk.getTileEntities()) {
                    tiles.addObject(new LocationTag(block.getLocation()));
                }
            }
            finally {
                NMSHandler.chunkHelper.restoreServerThread(object.getBukkitWorld());
            }
            return tiles;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "entities", (attribute, object) -> {
            ListTag entities = new ListTag();
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            ListTag typeFilter = attribute.hasParam() ? attribute.paramAsType(ListTag.class) : null;
            try {
                NMSHandler.chunkHelper.changeChunkServerThread(object.getBukkitWorld());
                block3: for (Entity entity : chunk.getEntities()) {
                    EntityTag current = new EntityTag(entity);
                    if (typeFilter != null) {
                        for (String type : typeFilter) {
                            if (!current.comparedTo(type)) continue;
                            entities.addObject(current.getDenizenObject());
                            continue block3;
                        }
                        continue;
                    }
                    entities.addObject(current.getDenizenObject());
                }
            }
            finally {
                NMSHandler.chunkHelper.restoreServerThread(object.getBukkitWorld());
            }
            return entities;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "living_entities", (attribute, object) -> {
            ListTag entities = new ListTag();
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            try {
                NMSHandler.chunkHelper.changeChunkServerThread(object.getBukkitWorld());
                for (Entity ent : chunk.getEntities()) {
                    if (!(ent instanceof LivingEntity)) continue;
                    entities.addObject(new EntityTag(ent).getDenizenObject());
                }
            }
            finally {
                NMSHandler.chunkHelper.restoreServerThread(object.getBukkitWorld());
            }
            return entities;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "players", (attribute, object) -> {
            ListTag entities = new ListTag();
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            for (Entity ent : chunk.getEntities()) {
                if (!EntityTag.isPlayer(ent)) continue;
                entities.addObject(new PlayerTag((Player)ent));
            }
            return entities;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "height_map", (attribute, object) -> {
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            int[] heightMap = NMSHandler.chunkHelper.getHeightMap(chunk);
            ArrayList<String> height_map = new ArrayList<String>(heightMap.length);
            for (int i : heightMap) {
                height_map.add(String.valueOf(i));
            }
            return new ListTag((List<String>)height_map);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "average_height", (attribute, object) -> {
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            int[] heightMap = NMSHandler.chunkHelper.getHeightMap(chunk);
            int sum = 0;
            for (int i : heightMap) {
                sum += i;
            }
            return new ElementTag((double)sum / (double)heightMap.length);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_flat", (attribute, object) -> {
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            int[] heightMap = NMSHandler.chunkHelper.getHeightMap(chunk);
            int tolerance = 2;
            if (attribute.hasParam() && ArgumentHelper.matchesInteger(attribute.getParam())) {
                tolerance = attribute.getIntParam();
            }
            int x = heightMap[0];
            for (int i : heightMap) {
                if (Math.abs(x - i) <= tolerance) continue;
                return new ElementTag(false);
            }
            return new ElementTag(true);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "surface_blocks", (attribute, object) -> {
            ListTag surface_blocks = new ListTag();
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            ChunkSnapshot snapshot = chunk.getChunkSnapshot();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    surface_blocks.addObject(new LocationTag(chunk.getWorld(), (double)(chunk.getX() << 4 | x), (double)(snapshot.getHighestBlockYAt(x, z) - 1), chunk.getZ() << 4 | z));
                }
            }
            return surface_blocks;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "blocks_flagged", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("ChunkTag.blocks_flagged[...] must have an input value.");
                return null;
            }
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            String flagName = CoreUtilities.toLowerCase(attribute.getParam());
            ListTag blocks = new ListTag();
            LocationFlagSearchHelper.getFlaggedLocations(chunk, flagName, loc -> blocks.addObject(new LocationTag((Location)loc)));
            return blocks;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawn_slimes", (attribute, object) -> {
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            return new ElementTag(chunk.isSlimeChunk());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "inhabited_time", (attribute, object) -> {
            Chunk chunk = object.getChunkForTag(attribute);
            if (chunk == null) {
                return null;
            }
            return new DurationTag(chunk.getInhabitedTime());
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a chunk!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        AbstractFlagTracker.tryFlagAdjusts(this, mechanism);
        if (mechanism.matches("inhabited_time") && mechanism.requireObject(DurationTag.class)) {
            this.getChunk().setInhabitedTime(mechanism.valueAsType(DurationTag.class).getTicks());
        }
        if (mechanism.matches("unload")) {
            this.getBukkitWorld().unloadChunk(this.getX(), this.getZ(), true);
        }
        if (mechanism.matches("unload_without_saving")) {
            this.getBukkitWorld().unloadChunk(this.getX(), this.getZ(), false);
        }
        if (mechanism.matches("force_loaded") && mechanism.requireBoolean()) {
            this.getChunk().setForceLoaded(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("clear_plugin_tickets")) {
            for (Plugin plugin : new ArrayList(this.getChunk().getPluginChunkTickets())) {
                this.getChunk().removePluginChunkTicket(plugin);
            }
        }
        if (mechanism.matches("load")) {
            this.getChunk().load(true);
        }
        if (mechanism.matches("regenerate")) {
            this.getBukkitWorld().regenerateChunk(this.getX(), this.getZ());
        }
        if (mechanism.matches("refresh_chunk")) {
            int chunkX = this.getX();
            int chunkZ = this.getZ();
            this.getBukkitWorld().refreshChunk(chunkX, chunkZ);
        }
        if (mechanism.matches("refresh_chunk_sections")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                this.getBukkitWorld().regenerateChunk(this.chunkX, this.chunkZ);
            } else {
                NMSHandler.chunkHelper.refreshChunkSections(this.getChunk());
            }
        }
        if (mechanism.matches("set_all_biomes") && mechanism.requireObject(BiomeTag.class)) {
            NMSHandler.chunkHelper.setAllBiomes(this.getChunk(), mechanism.valueAsType(BiomeTag.class).getBiome());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

