/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.entity.EntityHealth;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.scripts.commands.player.ExperienceCommand;
import com.denizenscript.denizen.scripts.commands.player.SidebarCommand;
import com.denizenscript.denizen.scripts.commands.server.BossBarCommand;
import com.denizenscript.denizen.tags.core.PlayerTagBase;
import com.denizenscript.denizen.utilities.AdvancedTextImpl;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.BossBarHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.entity.HideEntitiesHelper;
import com.denizenscript.denizen.utilities.flags.PlayerFlagHandler;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizen.utilities.packets.HideParticles;
import com.denizenscript.denizen.utilities.packets.ItemChangeMessage;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.NPCSelector;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.map.MapView;
import org.bukkit.util.RayTraceResult;

public class PlayerTag
implements ObjectTag,
Adjustable,
EntityFormObject,
FlaggableObject {
    static Map<String, UUID> playerNames = new HashMap<String, UUID>();
    public static String playerByNameMessage = BukkitImplDeprecations.playerByNameWarning.message;
    UUID uuid;
    private String prefix = "Player";
    public static ObjectTagProcessor<PlayerTag> tagProcessor = new ObjectTagProcessor();

    public static PlayerTag mirrorBukkitPlayer(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        return new PlayerTag(player);
    }

    public static void notePlayer(OfflinePlayer player) {
        if (player.getName() == null) {
            Debug.echoError("Null named player " + player + " - may be file corruption, or player data imported from non-bukkit server?");
            return;
        }
        if (!playerNames.containsKey(CoreUtilities.toLowerCase(player.getName()))) {
            playerNames.put(CoreUtilities.toLowerCase(player.getName()), player.getUniqueId());
        }
    }

    public static boolean isNoted(OfflinePlayer player) {
        return playerNames.containsValue(player.getUniqueId());
    }

    public static Map<String, UUID> getAllPlayers() {
        return playerNames;
    }

    @Deprecated
    public static PlayerTag valueOf(String string) {
        return PlayerTag.valueOf(string, null);
    }

    @Fetchable(value="p")
    public static PlayerTag valueOf(String string, TagContext context) {
        return PlayerTag.valueOfInternal(string, context, true);
    }

    public static PlayerTag valueOfInternal(String string, TagContext context, boolean defaultAnnounce) {
        if (string == null) {
            return null;
        }
        boolean announce = context == null ? defaultAnnounce : context.showErrors();
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("p@")) {
            string = string.substring("p@".length());
        }
        if (string.length() == 36 && string.indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(string);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null) {
                    return new PlayerTag(player);
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        if (string.length() <= 16 && playerNames.containsKey(string)) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerNames.get(string));
            if (announce && (context == null || context.script != null)) {
                BukkitImplDeprecations.playerByNameWarning.message = playerByNameMessage + " Player named '" + player.getName() + "' has UUID: " + player.getUniqueId();
                BukkitImplDeprecations.playerByNameWarning.warn(context);
            }
            return new PlayerTag(player);
        }
        if (announce) {
            Debug.log("Minor: Invalid Player! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if ((arg = CoreUtilities.toLowerCase(arg)).startsWith("p@")) {
            return true;
        }
        if (arg.length() == 36 && arg.indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(arg);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null && (player.isOnline() || player.hasPlayedBefore())) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean playerNameIsValid(String name) {
        return playerNames.containsKey(CoreUtilities.toLowerCase(name));
    }

    public PlayerTag(OfflinePlayer player) {
        this(player.getUniqueId());
    }

    public PlayerTag(UUID uuid) {
        this.uuid = uuid;
    }

    public PlayerTag(Player player) {
        this((OfflinePlayer)player);
        if (EntityTag.isNPC((Entity)player)) {
            throw new IllegalStateException("NPCs are not allowed as PlayerTag objects!");
        }
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return PlayerFlagHandler.getTrackerFor(this.getUUID());
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public boolean isValid() {
        OfflinePlayer pl = this.getOfflinePlayer();
        if (pl != null && pl.hasPlayedBefore()) {
            return true;
        }
        return this.getPlayerEntity() != null;
    }

    public Player getPlayerEntity() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public ImprovedOfflinePlayer getNBTEditor() {
        return NMSHandler.playerHelper.getOfflineData(this.getOfflinePlayer());
    }

    @Override
    public EntityTag getDenizenEntity() {
        return new EntityTag((Entity)this.getPlayerEntity());
    }

    public NPCTag getSelectedNPC() {
        NPC npc;
        if (Depends.citizens != null && CitizensAPI.hasImplementation() && (npc = CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)this.getPlayerEntity())) != null) {
            return new NPCTag(npc);
        }
        return null;
    }

    public String getName() {
        return this.getOfflinePlayer().getName();
    }

    @Override
    public LocationTag getLocation() {
        if (this.isOnline()) {
            return new LocationTag(this.getPlayerEntity().getLocation());
        }
        return new LocationTag(this.getNBTEditor().getLocation());
    }

    public int getRemainingAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getRemainingAir();
        }
        return this.getNBTEditor().getRemainingAir();
    }

    public int getMaximumAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaximumAir();
        }
        return 300;
    }

    public double getHealth() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getHealth();
        }
        return this.getNBTEditor().getHealthFloat();
    }

    public double getMaxHealth() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaxHealth();
        }
        return this.getNBTEditor().getMaxHealth();
    }

    public int getFoodLevel() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getFoodLevel();
        }
        return this.getNBTEditor().getFoodLevel();
    }

    public LocationTag getEyeLocation() {
        if (this.isOnline()) {
            return new LocationTag(this.getPlayerEntity().getEyeLocation());
        }
        return null;
    }

    public InventoryTag getInventory() {
        if (this.isOnline()) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.getPlayerEntity().getInventory());
        }
        return new InventoryTag(this.getNBTEditor());
    }

    public CraftingInventory getBukkitWorkbench() {
        if (this.isOnline() && (this.getPlayerEntity().getOpenInventory().getType() == InventoryType.WORKBENCH || this.getPlayerEntity().getOpenInventory().getType() == InventoryType.CRAFTING)) {
            return (CraftingInventory)this.getPlayerEntity().getOpenInventory().getTopInventory();
        }
        return null;
    }

    public InventoryTag getWorkbench() {
        CraftingInventory workbench;
        if (this.isOnline() && (workbench = this.getBukkitWorkbench()) != null) {
            return new InventoryTag((Inventory)workbench, (InventoryHolder)this.getPlayerEntity());
        }
        return null;
    }

    public InventoryTag getEnderChest() {
        if (this.isOnline()) {
            return new InventoryTag(this.getPlayerEntity().getEnderChest(), (InventoryHolder)this.getPlayerEntity());
        }
        return new InventoryTag(this.getNBTEditor(), true);
    }

    public WorldTag getWorldTag() {
        if (this.isOnline()) {
            return new WorldTag(this.getPlayerEntity().getWorld());
        }
        return new WorldTag(this.getLocation().getWorldName());
    }

    public World getWorld() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getWorld();
        }
        return this.getLocation().getWorld();
    }

    public ItemTag getHeldItem() {
        return new ItemTag(this.getPlayerEntity().getEquipment().getItemInMainHand());
    }

    public ItemTag getOffhandItem() {
        return new ItemTag(this.getPlayerEntity().getEquipment().getItemInOffHand());
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        this.getOfflinePlayer().decrementStatistic(statistic, amount);
    }

    public void decrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (statistic.getType() == Statistic.Type.ENTITY) {
            this.getOfflinePlayer().decrementStatistic(statistic, entity, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM) {
            this.getOfflinePlayer().decrementStatistic(statistic, material, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        this.getOfflinePlayer().incrementStatistic(statistic, amount);
    }

    public void incrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (statistic.getType() == Statistic.Type.ENTITY) {
            this.getOfflinePlayer().incrementStatistic(statistic, entity, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM) {
            this.getOfflinePlayer().incrementStatistic(statistic, material, amount);
        }
    }

    public void setStatistic(Statistic statistic, int amount) {
        this.getOfflinePlayer().setStatistic(statistic, amount);
    }

    public void setStatistic(Statistic statistic, EntityType entity, int amount) {
        if (statistic.getType() == Statistic.Type.ENTITY) {
            this.getOfflinePlayer().setStatistic(statistic, entity, amount);
        }
    }

    public void setStatistic(Statistic statistic, Material material, int amount) {
        if (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM) {
            this.getOfflinePlayer().setStatistic(statistic, material, amount);
        }
    }

    public boolean isOnline() {
        return this.getPlayerEntity() != null;
    }

    public void setBedSpawnLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().setBedSpawnLocation(location);
        } else {
            this.getNBTEditor().setBedSpawnLocation(location, this.getNBTEditor().isSpawnForced());
        }
    }

    public void setLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().teleport(location);
        } else {
            this.getNBTEditor().setLocation(location);
        }
    }

    public void setMaximumAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaximumAir(air);
        } else {
            Debug.echoError("Cannot set the maximum air of an offline player!");
        }
    }

    public void setRemainingAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setRemainingAir(air);
        } else {
            this.getNBTEditor().setRemainingAir(air);
        }
    }

    public void setHealth(double health) {
        if (this.isOnline()) {
            this.getPlayerEntity().setHealth(health);
        } else {
            this.getNBTEditor().setHealthFloat((float)health);
        }
    }

    public void setMaxHealth(double maxHealth) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaxHealth(maxHealth);
        } else {
            this.getNBTEditor().setMaxHealth(maxHealth);
        }
    }

    public void setFoodLevel(int foodLevel) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFoodLevel(foodLevel);
        } else {
            this.getNBTEditor().setFoodLevel(foodLevel);
        }
    }

    public void setLevel(int level) {
        if (this.isOnline()) {
            this.getPlayerEntity().setLevel(level);
        } else {
            this.getNBTEditor().setLevel(level);
        }
    }

    public void setFlySpeed(float speed) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFlySpeed(speed);
        } else {
            this.getNBTEditor().setFlySpeed(speed);
        }
    }

    public void setGameMode(GameMode mode) {
        if (this.isOnline()) {
            this.getPlayerEntity().setGameMode(mode);
        } else {
            this.getNBTEditor().setGameMode(mode);
        }
    }

    public boolean hasChunkLoaded(Chunk chunk) {
        return NMSHandler.playerHelper.hasChunkLoaded(this.getPlayerEntity(), chunk);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public PlayerTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "<LG>p@<Y>" + this.uuid + "<GR> (" + this.getOfflinePlayer().getName() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "p@" + this.uuid;
    }

    @Override
    public String identifySimple() {
        return "p@" + this.getOfflinePlayer().getName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.getOfflinePlayer();
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PlayerTag)) {
            return false;
        }
        return this.getUUID().equals(((PlayerTag)other).getUUID());
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "is_player", (attribute, object) -> new ElementTag(true), new String[0]);
        tagProcessor.registerTag(ListTag.class, "chat_history_list", (attribute, object) -> {
            List<String> history = PlayerTagBase.playerChatHistory.get(object.getUUID());
            return history == null ? new ListTag() : new ListTag(history, true);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "chat_history", (attribute, object) -> {
            List<String> messages;
            int x = 1;
            if (attribute.hasParam() && ArgumentHelper.matchesInteger(attribute.getParam())) {
                x = attribute.getIntParam();
            }
            if ((messages = PlayerTagBase.playerChatHistory.get(object.getUUID())) == null || messages.size() < x || x < 1) {
                return null;
            }
            return new ElementTag(messages.get(x - 1), true);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "formatted_money", (attribute, object) -> {
            if (Depends.economy == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                }
                return null;
            }
            return new ElementTag(Depends.economy.format(Depends.economy.getBalance(object.getOfflinePlayer())), true);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "money", (attribute, object) -> {
            if (Depends.economy == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                }
                return null;
            }
            if (attribute.startsWith("formatted", 2)) {
                attribute.fulfill(1);
                BukkitImplDeprecations.playerMoneyFormatTag.warn(attribute.context);
                return new ElementTag(Depends.economy.format(Depends.economy.getBalance(object.getOfflinePlayer())));
            }
            if (attribute.startsWith("currency_singular", 2)) {
                attribute.fulfill(1);
                BukkitImplDeprecations.oldEconomyTags.warn(attribute.context);
                return new ElementTag(Depends.economy.currencyNameSingular());
            }
            if (attribute.startsWith("currency", 2)) {
                attribute.fulfill(1);
                BukkitImplDeprecations.oldEconomyTags.warn(attribute.context);
                return new ElementTag(Depends.economy.currencyNamePlural());
            }
            return new ElementTag(Depends.economy.getBalance(object.getOfflinePlayer()));
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ObjectTag.class, "target", (attribute, object) -> {
            LocationTag eyeLoc;
            RayTraceResult result;
            String matcher;
            double range = 50.0;
            String string = matcher = attribute.hasParam() ? attribute.getParam() : null;
            if (attribute.startsWith("within", 2) && attribute.hasContext(2)) {
                range = attribute.getDoubleContext(2);
                attribute.fulfill(1);
            }
            if ((result = (eyeLoc = object.getEyeLocation()).getWorld().rayTrace((Location)eyeLoc, eyeLoc.getDirection(), range, FluidCollisionMode.NEVER, true, 0.01, e -> {
                if (e.getUniqueId().equals(object.getUUID())) {
                    return false;
                }
                if (matcher != null) {
                    return new EntityTag((Entity)e).tryAdvancedMatcher(matcher);
                }
                return true;
            })) == null || result.getHitEntity() == null) {
                return null;
            }
            return new EntityTag(result.getHitEntity()).getDenizenObject();
        }, new String[0]);
        PlayerTag.registerOfflineTag(LocationTag.class, "bed_spawn", (attribute, object) -> {
            try {
                NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
                if (object.getOfflinePlayer().getBedSpawnLocation() == null) {
                    LocationTag locationTag = null;
                    return locationTag;
                }
                LocationTag locationTag = new LocationTag(object.getOfflinePlayer().getBedSpawnLocation());
                return locationTag;
            }
            finally {
                NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
            }
        }, new String[0]);
        PlayerTag.registerOfflineTag(ObjectTag.class, "location", (attribute, object) -> {
            if (object.isOnline() && !object.getPlayerEntity().isDead()) {
                return new EntityTag((Entity)object.getPlayerEntity()).doLocationTag(attribute);
            }
            return object.getLocation();
        }, new String[0]);
        PlayerTag.registerOfflineTag(WorldTag.class, "world", (attribute, object) -> object.getWorldTag(), new String[0]);
        PlayerTag.registerOnlineOnlyTag(DurationTag.class, "item_cooldown", (attribute, object) -> {
            MaterialTag mat = new ElementTag(attribute.getParam()).asType(MaterialTag.class, attribute.context);
            if (mat != null) {
                return new DurationTag((long)object.getPlayerEntity().getCooldown(mat.getMaterial()));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(TimeTag.class, "first_played_time", (attribute, object) -> new TimeTag(object.getOfflinePlayer().getFirstPlayed()), new String[0]);
        tagProcessor.registerTag(DurationTag.class, "first_played", (attribute, object) -> {
            BukkitImplDeprecations.playerTimePlayedTags.warn(attribute.context);
            return new DurationTag(object.getOfflinePlayer().getFirstPlayed() / 50L);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_played_before", (attribute, object) -> new ElementTag(object.isValid()), new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "exhaustion", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().getExhaustion());
            }
            return new ElementTag(object.getNBTEditor().getExhaustion());
        }, new String[0]);
        PlayerTag.registerOfflineTag(DurationTag.class, "max_oxygen", (attribute, object) -> new DurationTag((long)object.getMaximumAir()), new String[0]);
        PlayerTag.registerOfflineTag(DurationTag.class, "oxygen", (attribute, object) -> {
            if (attribute.startsWith("max", 2)) {
                BukkitImplDeprecations.entityMaxOxygenTag.warn(attribute.context);
                attribute.fulfill(1);
                return new DurationTag((long)object.getMaximumAir());
            }
            return new DurationTag((long)object.getRemainingAir());
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "health_is_scaled", (attribute, object) -> new ElementTag(object.getPlayerEntity().isHealthScaled()), new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "health_scale", (attribute, object) -> new ElementTag(object.getPlayerEntity().getHealthScale()), new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "formatted_health", (attribute, object) -> {
            Double maxHealth = attribute.hasParam() ? Double.valueOf(attribute.getDoubleParam()) : null;
            return EntityHealth.getHealthFormatted(new EntityTag((Entity)object.getPlayerEntity()), maxHealth);
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "health_percentage", (attribute, object) -> {
            double maxHealth = object.getPlayerEntity().getMaxHealth();
            if (attribute.hasParam()) {
                maxHealth = attribute.getIntParam();
            }
            return new ElementTag(object.getPlayerEntity().getHealth() / maxHealth * 100.0);
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "health_max", (attribute, object) -> new ElementTag(object.getMaxHealth()), new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "health", (attribute, object) -> {
            if (attribute.startsWith("is_scaled", 2)) {
                attribute.fulfill(1);
                BukkitImplDeprecations.entityHealthTags.warn(attribute.context);
                return new ElementTag(object.getPlayerEntity().isHealthScaled());
            }
            if (attribute.startsWith("scale", 2)) {
                attribute.fulfill(1);
                BukkitImplDeprecations.entityHealthTags.warn(attribute.context);
                return new ElementTag(object.getPlayerEntity().getHealthScale());
            }
            if (attribute.startsWith("formatted", 2)) {
                BukkitImplDeprecations.entityHealthTags.warn(attribute.context);
                Double maxHealth = attribute.hasContext(2) ? Double.valueOf(attribute.getDoubleContext(2)) : null;
                attribute.fulfill(1);
                return EntityHealth.getHealthFormatted(new EntityTag((Entity)object.getPlayerEntity()), maxHealth);
            }
            if (attribute.startsWith("percentage", 2)) {
                BukkitImplDeprecations.entityHealthTags.warn(attribute.context);
                attribute.fulfill(1);
                double maxHealth = object.getPlayerEntity().getMaxHealth();
                if (attribute.hasParam()) {
                    maxHealth = attribute.getIntParam();
                }
                return new ElementTag(object.getPlayerEntity().getHealth() / maxHealth * 100.0);
            }
            if (attribute.startsWith("max", 2)) {
                BukkitImplDeprecations.entityHealthTags.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getMaxHealth());
            }
            return new ElementTag(object.getHealth());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_banned", (attribute, object) -> {
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null) {
                return new ElementTag(false);
            }
            if (ban.getExpiration() == null) {
                return new ElementTag(true);
            }
            return new ElementTag(ban.getExpiration().after(new Date()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_online", (attribute, object) -> new ElementTag(object.isOnline()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_op", (attribute, object) -> new ElementTag(object.getOfflinePlayer().isOp()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_whitelisted", (attribute, object) -> new ElementTag(object.getOfflinePlayer().isWhitelisted()), new String[0]);
        tagProcessor.registerTag(TimeTag.class, "last_played_time", (attribute, object) -> {
            if (object.isOnline()) {
                return TimeTag.now();
            }
            return new TimeTag(object.getOfflinePlayer().getLastPlayed());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "last_played", (attribute, object) -> {
            BukkitImplDeprecations.playerTimePlayedTags.warn(attribute.context);
            if (object.isOnline()) {
                return new DurationTag(System.currentTimeMillis() / 50L);
            }
            return new DurationTag(object.getOfflinePlayer().getLastPlayed() / 50L);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "groups", (attribute, object) -> {
            if (Depends.permissions == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                }
                return null;
            }
            ListTag list = new ListTag();
            WorldTag world = null;
            if (attribute.hasParam() && (world = attribute.paramAsType(WorldTag.class)) == null) {
                Debug.echoError("Invalid world specified: " + attribute.getParam());
                return null;
            }
            for (String group : Depends.permissions.getGroups()) {
                if (!Depends.permissions.playerInGroup(world != null ? world.getName() : null, object.getOfflinePlayer(), group)) continue;
                list.addObject(new ElementTag(group, true));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(TimeTag.class, "ban_expiration_time", (attribute, object) -> {
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            return new TimeTag(ban.getExpiration().getTime());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "ban_expiration", (attribute, object) -> {
            BukkitImplDeprecations.playerTimePlayedTags.warn(attribute.context);
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            return new DurationTag(ban.getExpiration().getTime() / 50L);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "ban_reason", (attribute, object) -> {
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            return new ElementTag(ban.getReason(), true);
        }, new String[0]);
        tagProcessor.registerTag(TimeTag.class, "ban_created_time", (attribute, object) -> {
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            return new TimeTag(ban.getCreated().getTime());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "ban_created", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            return new DurationTag(ban.getCreated().getTime() / 50L);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "ban_source", (attribute, object) -> {
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            return new ElementTag(ban.getSource(), true);
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "ban_info", (attribute, object) -> {
            BukkitImplDeprecations.playerBanInfoTags.warn(attribute.context);
            BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(object.getName());
            if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            if (attribute.startsWith("expiration", 2) && ban.getExpiration() != null) {
                attribute.fulfill(1);
                return new DurationTag(ban.getExpiration().getTime() / 50L);
            }
            if (attribute.startsWith("reason", 2)) {
                attribute.fulfill(1);
                return new ElementTag(ban.getReason());
            }
            if (attribute.startsWith("created", 2)) {
                attribute.fulfill(1);
                return new DurationTag(ban.getCreated().getTime() / 50L);
            }
            if (attribute.startsWith("source", 2)) {
                attribute.fulfill(1);
                return new ElementTag(ban.getSource());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "in_group", (attribute, object) -> {
            if (Depends.permissions == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                }
                return null;
            }
            String group = attribute.getParam();
            if (attribute.startsWith("global", 2)) {
                attribute.fulfill(1);
                return new ElementTag(Depends.permissions.playerInGroup(null, object.getOfflinePlayer(), group));
            }
            if (attribute.startsWith("world", 2)) {
                WorldTag world = null;
                if (attribute.hasContext(2) && (world = attribute.contextAsType(2, WorldTag.class)) == null) {
                    Debug.echoError("Invalid world specified: " + attribute.getContext(2));
                    return null;
                }
                attribute.fulfill(1);
                return new ElementTag(Depends.permissions.playerInGroup(world != null ? world.getName() : null, object.getOfflinePlayer(), group));
            }
            if (object.isOnline()) {
                return new ElementTag(Depends.permissions.playerInGroup(object.getPlayerEntity(), group));
            }
            if (Depends.permissions != null) {
                return new ElementTag(Depends.permissions.playerInGroup(null, object.getOfflinePlayer(), group));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_permission", (attribute, object) -> {
            String permission = attribute.getParam();
            if (attribute.startsWith("global", 2)) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                attribute.fulfill(1);
                return new ElementTag(Depends.permissions.playerHas(null, object.getOfflinePlayer(), permission));
            }
            if (attribute.startsWith("world", 2)) {
                String world = attribute.getContext(2);
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                attribute.fulfill(1);
                if (world.startsWith("w@")) {
                    world = world.substring(2);
                }
                return new ElementTag(Depends.permissions.playerHas(world, object.getOfflinePlayer(), permission));
            }
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().hasPermission(permission));
            }
            if (Depends.permissions != null) {
                return new ElementTag(Depends.permissions.playerHas(null, object.getOfflinePlayer(), permission));
            }
            return null;
        }, "permission");
        tagProcessor.registerTag(ElementTag.class, "statistic", (attribute, object) -> {
            Statistic statistic;
            if (!attribute.hasParam()) {
                return null;
            }
            try {
                statistic = Statistic.valueOf((String)attribute.getParam().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                attribute.echoError("Statistic '" + attribute.getParam() + "' does not exist: " + ex.getMessage());
                return null;
            }
            if (attribute.startsWith("qualifier", 2)) {
                ObjectTag obj = ObjectFetcher.pickObjectFor(attribute.getContext(2), attribute.context);
                attribute.fulfill(1);
                try {
                    if (obj instanceof MaterialTag) {
                        return new ElementTag(object.getOfflinePlayer().getStatistic(statistic, ((MaterialTag)obj).getMaterial()));
                    }
                    if (obj instanceof EntityTag) {
                        return new ElementTag(object.getOfflinePlayer().getStatistic(statistic, ((EntityTag)obj).getBukkitEntityType()));
                    }
                    return null;
                }
                catch (Exception e) {
                    Debug.echoError("Invalid statistic: " + statistic + " for this player!");
                    return null;
                }
            }
            try {
                return new ElementTag(object.getOfflinePlayer().getStatistic(statistic));
            }
            catch (Exception e) {
                Debug.echoError("Invalid statistic: " + statistic + " for this player!");
                return null;
            }
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "uuid", (attribute, object) -> new ElementTag(object.getUUID().toString()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "list_name", (attribute, object) -> new ElementTag(AdvancedTextImpl.instance.getPlayerListName(object.getPlayerEntity()), true), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "display_name", (attribute, object) -> new ElementTag(object.getPlayerEntity().getDisplayName(), true), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> {
            if (attribute.startsWith("list", 2) && object.isOnline()) {
                BukkitImplDeprecations.playerNameTags.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getPlayerListName(), true);
            }
            if (attribute.startsWith("display", 2) && object.isOnline()) {
                BukkitImplDeprecations.playerNameTags.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getDisplayName(), true);
            }
            return new ElementTag(object.getName(), true);
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "client_brand", (attribute, object) -> {
            NetworkInterceptHelper.enable();
            return new ElementTag(NMSHandler.playerHelper.getPlayerBrand(object.getPlayerEntity()), true);
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "locale", (attribute, object) -> new ElementTag(object.getPlayerEntity().getLocale(), true), new String[0]);
        PlayerTag.registerOfflineTag(InventoryTag.class, "inventory", (attribute, object) -> object.getInventory(), new String[0]);
        PlayerTag.registerOfflineTag(InventoryTag.class, "enderchest", (attribute, object) -> object.getEnderChest(), new String[0]);
        PlayerTag.registerOnlineOnlyTag(InventoryTag.class, "open_inventory", (attribute, object) -> InventoryTag.mirrorBukkitInventory(object.getPlayerEntity().getOpenInventory().getTopInventory()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ListTag.class, "discovered_recipes", (attribute, object) -> new ListTag(NMSHandler.entityHelper.getDiscoveredRecipes(object.getPlayerEntity())), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "selected_trade_index", (attribute, object) -> {
            if (object.getPlayerEntity().getOpenInventory().getTopInventory() instanceof MerchantInventory) {
                return new ElementTag(((MerchantInventory)object.getPlayerEntity().getOpenInventory().getTopInventory()).getSelectedRecipeIndex() + 1);
            }
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(TradeTag.class, "selected_trade", (attribute, object) -> {
            Inventory playerInventory = object.getPlayerEntity().getOpenInventory().getTopInventory();
            if (playerInventory instanceof MerchantInventory && ((MerchantInventory)playerInventory).getSelectedRecipe() != null) {
                return new TradeTag(((MerchantInventory)playerInventory).getSelectedRecipe()).duplicate();
            }
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ItemTag.class, "item_on_cursor", (attribute, object) -> new ItemTag(object.getPlayerEntity().getItemOnCursor()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "held_item_slot", (attribute, object) -> new ElementTag(object.getPlayerEntity().getInventory().getHeldItemSlot() + 1), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ObjectTag.class, "item_in_hand", (attribute, object) -> {
            if (attribute.startsWith("slot", 2)) {
                BukkitImplDeprecations.playerItemInHandSlotTag.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getInventory().getHeldItemSlot() + 1);
            }
            return object.getHeldItem();
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ListTag.class, "sidebar_lines", (attribute, object) -> {
            Sidebar sidebar = SidebarCommand.getSidebar(object);
            if (sidebar == null) {
                return null;
            }
            return new ListTag(sidebar.getLinesText(), true);
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "sidebar_title", (attribute, object) -> {
            Sidebar sidebar = SidebarCommand.getSidebar(object);
            if (sidebar == null) {
                return null;
            }
            return new ElementTag(sidebar.getTitle(), true);
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ListTag.class, "sidebar_scores", (attribute, object) -> {
            Sidebar sidebar = SidebarCommand.getSidebar(object);
            if (sidebar == null) {
                return null;
            }
            ListTag scores = new ListTag();
            for (int score : sidebar.getScores()) {
                scores.add(String.valueOf(score));
            }
            return scores;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ObjectTag.class, "sidebar", (attribute, object) -> {
            BukkitImplDeprecations.playerSidebarTags.warn(attribute.context);
            if (attribute.startsWith("lines", 2)) {
                attribute.fulfill(1);
                Sidebar sidebar = SidebarCommand.getSidebar(object);
                if (sidebar == null) {
                    return null;
                }
                return new ListTag(sidebar.getLinesText());
            }
            if (attribute.startsWith("title", 2)) {
                attribute.fulfill(1);
                Sidebar sidebar = SidebarCommand.getSidebar(object);
                if (sidebar == null) {
                    return null;
                }
                return new ElementTag(sidebar.getTitle());
            }
            if (attribute.startsWith("scores", 2)) {
                attribute.fulfill(1);
                Sidebar sidebar = SidebarCommand.getSidebar(object);
                if (sidebar == null) {
                    return null;
                }
                ListTag scores = new ListTag();
                for (int score : sidebar.getScores()) {
                    scores.add(String.valueOf(score));
                }
                return scores;
            }
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "skin_blob", (attribute, object) -> new ElementTag(NMSHandler.instance.getProfileEditor().getPlayerSkinBlob(object.getPlayerEntity())), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "skull_skin", (attribute, object) -> {
            String skin = NMSHandler.instance.getProfileEditor().getPlayerSkinBlob(object.getPlayerEntity());
            if (skin == null) {
                return null;
            }
            int semicolon = skin.indexOf(59);
            return new ElementTag(object.getPlayerEntity().getUniqueId() + "|" + skin.substring(0, semicolon) + "|" + object.getName());
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ItemTag.class, "skull_item", (attribute, object) -> {
            ItemStack item = new ItemStack(Material.PLAYER_HEAD);
            item = NMSHandler.itemHelper.setSkullSkin(item, NMSHandler.instance.getPlayerProfile(object.getPlayerEntity()));
            return new ItemTag(item);
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ObjectTag.class, "attack_cooldown", (attribute, object) -> {
            BukkitImplDeprecations.playerAttackCooldownTags.warn(attribute.context);
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)NMSHandler.playerHelper.ticksPassedDuringCooldown(object.getPlayerEntity()));
            }
            if (attribute.startsWith("max_duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)NMSHandler.playerHelper.getMaxAttackCooldownTicks(object.getPlayerEntity()));
            }
            if (attribute.startsWith("percent", 2)) {
                attribute.fulfill(1);
                return new ElementTag(NMSHandler.playerHelper.getAttackCooldownPercent(object.getPlayerEntity()) * 100.0f);
            }
            Debug.echoError("The tag 'player.attack_cooldown...' must be followed by a sub-tag.");
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "main_hand", (attribute, object) -> new ElementTag(object.getPlayerEntity().getMainHand().toString()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(NPCTag.class, "selected_npc", (attribute, object) -> {
            if (object.getPlayerEntity().hasMetadata("selected")) {
                return object.getSelectedNPC();
            }
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(EntityTag.class, "entity", (attribute, object) -> new EntityTag((Entity)object.getPlayerEntity()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "ip_address", (attribute, object) -> new ElementTag(object.getPlayerEntity().getAddress().getAddress().toString()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "ip", (attribute, object) -> {
            if (attribute.startsWith("address_only", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getAddress().toString());
            }
            String host = object.getPlayerEntity().getAddress().getHostName();
            if (attribute.startsWith("address", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getAddress().toString());
            }
            return new ElementTag(host);
        }, "host_name");
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "nameplate", (attribute, object) -> new ElementTag(NMSHandler.instance.getProfileEditor().getPlayerName(object.getPlayerEntity()), true), new String[0]);
        PlayerTag.registerOnlineOnlyTag(LocationTag.class, "compass_target", (attribute, object) -> {
            Location target = object.getPlayerEntity().getCompassTarget();
            if (target != null) {
                return new LocationTag(target);
            }
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "chunk_loaded", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ChunkTag chunk = attribute.paramAsType(ChunkTag.class);
            if (chunk == null) {
                return null;
            }
            return new ElementTag(chunk.isLoadedSafe() && object.hasChunkLoaded(chunk.getChunkForTag(attribute)));
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "can_fly", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().getAllowFlight());
            }
            return new ElementTag(object.getNBTEditor().getAllowFlight());
        }, "allowed_flight");
        PlayerTag.registerOfflineTag(ElementTag.class, "fly_speed", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().getFlySpeed());
            }
            return new ElementTag(object.getNBTEditor().getFlySpeed());
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "walk_speed", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().getWalkSpeed());
            }
            return new ElementTag(object.getNBTEditor().getWalkSpeed());
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "saturation", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().getSaturation());
            }
            return new ElementTag(object.getNBTEditor().getSaturation());
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "formatted_food_level", (attribute, object) -> {
            double maxHunger = object.getPlayerEntity().getMaxHealth();
            if (attribute.hasParam()) {
                maxHunger = attribute.getIntParam();
            }
            attribute.fulfill(1);
            int foodLevel = object.getFoodLevel();
            if ((double)foodLevel / maxHunger < 0.1) {
                return new ElementTag("starving");
            }
            if ((double)foodLevel / maxHunger < 0.4) {
                return new ElementTag("famished");
            }
            if ((double)foodLevel / maxHunger < 0.75) {
                return new ElementTag("parched");
            }
            if ((double)foodLevel / maxHunger < 1.0) {
                return new ElementTag("hungry");
            }
            return new ElementTag("healthy");
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "food_level", (attribute, object) -> {
            if (attribute.startsWith("formatted", 2)) {
                BukkitImplDeprecations.playerFoodLevelFormatTag.warn(attribute.context);
                double maxHunger = object.getPlayerEntity().getMaxHealth();
                if (attribute.hasContext(2)) {
                    maxHunger = attribute.getIntContext(2);
                }
                attribute.fulfill(1);
                int foodLevel = object.getFoodLevel();
                if ((double)foodLevel / maxHunger < 0.1) {
                    return new ElementTag("starving");
                }
                if ((double)foodLevel / maxHunger < 0.4) {
                    return new ElementTag("famished");
                }
                if ((double)foodLevel / maxHunger < 0.75) {
                    return new ElementTag("parched");
                }
                if ((double)foodLevel / maxHunger < 1.0) {
                    return new ElementTag("hungry");
                }
                return new ElementTag("healthy");
            }
            return new ElementTag(object.getFoodLevel());
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "gamemode", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(object.getPlayerEntity().getGameMode().name());
            }
            return new ElementTag(object.getNBTEditor().getGameMode().name());
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "is_blocking", (attribute, object) -> new ElementTag(object.getPlayerEntity().isBlocking()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "ping", (attribute, object) -> new ElementTag(NMSHandler.playerHelper.getPing(object.getPlayerEntity())), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "is_flying", (attribute, object) -> new ElementTag(object.getPlayerEntity().isFlying()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "is_sneaking", (attribute, object) -> new ElementTag(object.getPlayerEntity().isSneaking()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "is_sprinting", (attribute, object) -> new ElementTag(object.getPlayerEntity().isSprinting()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "has_advancement", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Advancement adv = AdvancementHelper.getAdvancement(attribute.getParam());
            if (adv == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Advancement '" + attribute.getParam() + "' does not exist.");
                }
                return null;
            }
            AdvancementProgress progress = object.getPlayerEntity().getAdvancementProgress(adv);
            return new ElementTag(progress.isDone());
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ListTag.class, "advancements", (attribute, object) -> {
            ListTag list = new ListTag();
            Bukkit.advancementIterator().forEachRemaining(adv -> {
                if (object.getPlayerEntity().getAdvancementProgress(adv).isDone()) {
                    list.add(adv.getKey().toString());
                }
            });
            return list;
        }, "list_advancements");
        PlayerTag.registerOnlineOnlyTag(DurationTag.class, "time_asleep", (attribute, object) -> new DurationTag((long)object.getPlayerEntity().getSleepTicks()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "time", (attribute, object) -> new ElementTag(object.getPlayerEntity().getPlayerTime()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "weather", (attribute, object) -> {
            if (object.getPlayerEntity().getPlayerWeather() != null) {
                return new ElementTag(object.getPlayerEntity().getPlayerWeather().name());
            }
            return null;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "calculate_xp", (attribute, object) -> {
            int level = object.getPlayerEntity().getLevel();
            return new ElementTag((float)ExperienceCommand.TOTAL_XP_FOR_LEVEL(level) + object.getPlayerEntity().getExp() * (float)ExperienceCommand.XP_FOR_NEXT_LEVEL(level));
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "xp_level", (attribute, object) -> new ElementTag(object.getPlayerEntity().getLevel()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "xp_to_next_level", (attribute, object) -> new ElementTag(object.getPlayerEntity().getExpToLevel()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "xp_total", (attribute, object) -> new ElementTag(object.getPlayerEntity().getTotalExperience()), new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "xp", (attribute, object) -> {
            if (attribute.startsWith("level", 2)) {
                BukkitImplDeprecations.playerXpTags.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getLevel());
            }
            if (attribute.startsWith("to_next_level", 2)) {
                BukkitImplDeprecations.playerXpTags.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getExpToLevel());
            }
            if (attribute.startsWith("total", 2)) {
                BukkitImplDeprecations.playerXpTags.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getPlayerEntity().getTotalExperience());
            }
            return new ElementTag(object.getPlayerEntity().getExp() * 100.0f);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "chat_prefix", (attribute, object) -> {
            if (Depends.chat == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("'chat_prefix' tag unavailable: Vault and a chat plugin are required.");
                }
                return null;
            }
            String prefix = Depends.chat.getPlayerPrefix(object.getWorld().getName(), object.getOfflinePlayer());
            if (prefix == null) {
                return null;
            }
            return new ElementTag(prefix, true);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "chat_suffix", (attribute, object) -> {
            if (Depends.chat == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("'chat_suffix' tag unavailable: Vault and a chat plugin are required.");
                }
                return null;
            }
            String suffix = Depends.chat.getPlayerSuffix(object.getWorld().getName(), object.getOfflinePlayer());
            if (suffix == null) {
                return null;
            }
            return new ElementTag(suffix, true);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "fake_block_locations", (attribute, object) -> {
            ListTag list = new ListTag();
            FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(object.getUUID());
            if (map != null) {
                for (LocationTag loc : map.byLocation.keySet()) {
                    list.addObject(loc.clone());
                }
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(MaterialTag.class, "fake_block", (attribute, object) -> {
            FakeBlock block;
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag input = attribute.paramAsType(LocationTag.class);
            FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(object.getUUID());
            if (map != null && (block = map.byLocation.get(input)) != null) {
                return block.material;
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "fake_entities", (attribute, object) -> {
            ListTag list = new ListTag();
            FakeEntity.FakeEntityMap map = FakeEntity.playersToEntities.get(object.getUUID());
            if (map != null) {
                for (Map.Entry<Integer, FakeEntity> entry : map.byId.entrySet()) {
                    list.addObject(entry.getValue().entity);
                }
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(EntityTag.class, "disguise_to_self", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            if (disguise.fakeToSelf == null) {
                return null;
            }
            return disguise.fakeToSelf.entity;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ObjectTag.class, "spectator_target", (attribute, object) -> {
            if (object.getPlayerEntity().getGameMode() != GameMode.SPECTATOR) {
                return null;
            }
            Entity target = object.getPlayerEntity().getSpectatorTarget();
            if (target == null) {
                return null;
            }
            return new EntityTag(target).getDenizenObject();
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "packets_sent", (attribute, object) -> {
            NetworkInterceptHelper.enable();
            return new ElementTag(NMSHandler.packetHelper.getPacketStats(object.getPlayerEntity(), true));
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "packets_received", (attribute, object) -> {
            NetworkInterceptHelper.enable();
            return new ElementTag(NMSHandler.packetHelper.getPacketStats(object.getPlayerEntity(), false));
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(EntityTag.class, "fish_hook", (attribute, object) -> {
            FishHook hook = NMSHandler.fishingHelper.getHookFrom(object.getPlayerEntity());
            if (hook == null) {
                return null;
            }
            return new EntityTag((Entity)hook);
        }, new String[0]);
        PlayerTag.registerOfflineTag(ElementTag.class, "spawn_forced", (attribute, object) -> {
            if (object.isOnline()) {
                return new ElementTag(NMSHandler.playerHelper.getSpawnForced(object.getPlayerEntity()));
            }
            return new ElementTag(object.getNBTEditor().isSpawnForced());
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(TimeTag.class, "last_action_time", (attribute, object) -> {
            long playerMilliTime = NMSHandler.playerHelper.getLastActionTime(object.getPlayerEntity());
            return new TimeTag(CoreUtilities.monotonicMillisToReal(playerMilliTime));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "scoreboard_id", (attribute, object) -> {
            String id = ScoreboardHelper.viewerMap.get(object.getUUID());
            if (id == null) {
                return null;
            }
            return new ElementTag(id);
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ListTag.class, "bossbar_ids", (attribute, object) -> {
            ListTag result = new ListTag();
            for (Map.Entry<String, BossBar> bar : BossBarCommand.bossBarMap.entrySet()) {
                if (!bar.getValue().getPlayers().contains(object.getPlayerEntity())) continue;
                result.addObject(new ElementTag(bar.getKey(), true));
            }
            return result;
        }, new String[0]);
        PlayerTag.registerOnlineOnlyTag(ListTag.class, "tab_completions", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String cmdFull = attribute.getParam();
            int space = cmdFull.indexOf(32);
            if (space == -1) {
                attribute.echoError("Invalid command input '" + cmdFull + "': must have at least one space");
                return null;
            }
            String cmdName = cmdFull.substring(0, space);
            PluginCommand actualCmd = Bukkit.getPluginCommand((String)cmdName);
            if (actualCmd == null) {
                attribute.echoError("Unknown command '" + cmdName + "'");
                return null;
            }
            String args = cmdFull.substring(space + 1);
            ListTag result = new ListTag();
            for (String str : actualCmd.tabComplete((CommandSender)object.getPlayerEntity(), cmdName, CoreUtilities.split(args, ' ').toArray(new String[0]))) {
                result.addObject(new ElementTag(str, true));
            }
            return result;
        }, new String[0]);
    }

    public static <R extends ObjectTag> void registerOfflineTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<PlayerTag, R> runnable, String ... variants) {
        tagProcessor.registerTag(returnType, name, (attribute, object) -> {
            if (!object.isValid()) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("Player is not considered valid in tag '" + attribute.getAttributeWithoutParam(1) + "' for player: " + object.debuggable());
                }
                return null;
            }
            return runnable.run(attribute, (PlayerTag)object);
        }, variants);
    }

    public static <R extends ObjectTag> void registerOnlineOnlyTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<PlayerTag, R> runnable, String ... variants) {
        tagProcessor.registerTag(returnType, name, (attribute, object) -> {
            if (!object.isOnline()) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("Player is not online, but tag '" + attribute.getAttributeWithoutParam(1) + "' requires the player be online, for player: " + object.debuggable());
                }
                return null;
            }
            return runnable.run(attribute, (PlayerTag)object);
        }, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        if (this.isOnline()) {
            return new EntityTag((Entity)this.getPlayerEntity());
        }
        return new ElementTag(this.identify());
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a player!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        AdvancementProgress prog;
        Advancement adv;
        AbstractFlagTracker.tryFlagAdjusts(this, mechanism);
        if (mechanism.matches("send_climbable_materials") && mechanism.requireObject(ListTag.class)) {
            List<MaterialTag> materialTags = mechanism.valueAsType(ListTag.class).filter(MaterialTag.class, mechanism.context);
            ArrayList<Material> materials = new ArrayList<Material>();
            for (MaterialTag materialTag : materialTags) {
                Material material = materialTag.getMaterial();
                if (!material.isBlock()) {
                    mechanism.echoError("Invalid material specified '" + material.name() + "': must be a block material.");
                    continue;
                }
                materials.add(material);
            }
            NMSHandler.playerHelper.sendClimbableMaterials(this.getPlayerEntity(), materials);
        }
        if (mechanism.matches("noclip") && mechanism.hasValue()) {
            if (mechanism.getValue().asBoolean()) {
                DenizenPacketHandler.forceNoclip.add(this.getUUID());
            } else {
                DenizenPacketHandler.forceNoclip.remove(this.getUUID());
            }
        }
        if (mechanism.matches("respawn")) {
            NMSHandler.packetHelper.respawn(this.getPlayerEntity());
        }
        if (mechanism.matches("vision")) {
            if (mechanism.hasValue() && mechanism.requireEnum(EntityType.class)) {
                NMSHandler.packetHelper.setVision(this.getPlayerEntity(), EntityType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                NMSHandler.packetHelper.forceSpectate(this.getPlayerEntity(), (Entity)this.getPlayerEntity());
            }
        }
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            this.setLevel(mechanism.getValue().asInt());
        }
        if (mechanism.matches("item_slot") && mechanism.requireInteger()) {
            if (this.isOnline()) {
                this.getPlayerEntity().getInventory().setHeldItemSlot(mechanism.getValue().asInt() - 1);
            } else {
                this.getNBTEditor().setItemInHand(mechanism.getValue().asInt() - 1);
            }
        }
        if (mechanism.matches("window_property")) {
            String[] split = mechanism.getValue().asString().split(",", 2);
            if (split.length != 2) {
                Debug.echoError("Invalid input! Must be in the form PROPERTY,VALUE");
            } else {
                try {
                    this.getPlayerEntity().setWindowProperty(InventoryView.Property.valueOf((String)split[0].toUpperCase()), Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    Debug.echoError("Input value must be a number!");
                }
                catch (IllegalArgumentException e) {
                    Debug.echoError("Must specify a valid window property!");
                }
            }
        }
        if (mechanism.matches("item_on_cursor") && mechanism.requireObject(ItemTag.class)) {
            this.getPlayerEntity().setItemOnCursor(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
        if (mechanism.matches("award_advancement")) {
            adv = AdvancementHelper.getAdvancement(mechanism.getValue().asString());
            if (adv == null) {
                if (mechanism.shouldDebug()) {
                    Debug.echoError("Advancement '" + mechanism.getValue().asString() + "' does not exist.");
                }
                return;
            }
            prog = this.getPlayerEntity().getAdvancementProgress(adv);
            for (String criteria : prog.getRemainingCriteria()) {
                prog.awardCriteria(criteria);
            }
        }
        if (mechanism.matches("revoke_advancement")) {
            adv = AdvancementHelper.getAdvancement(mechanism.getValue().asString());
            if (adv == null) {
                if (mechanism.shouldDebug()) {
                    Debug.echoError("Advancement '" + mechanism.getValue().asString() + "' does not exist.");
                }
                return;
            }
            prog = this.getPlayerEntity().getAdvancementProgress(adv);
            for (String criteria : prog.getAwardedCriteria()) {
                prog.revokeCriteria(criteria);
            }
        }
        if (mechanism.matches("fake_absorption_health") && mechanism.requireFloat()) {
            NMSHandler.packetHelper.setFakeAbsorption(this.getPlayerEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("health_scale") && mechanism.requireDouble()) {
            this.getPlayerEntity().setHealthScale(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("scale_health") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setHealthScaled(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("max_health") && mechanism.requireDouble()) {
            this.setMaxHealth(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("health") && mechanism.requireDouble()) {
            this.setHealth(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("resource_pack") || mechanism.matches("texture_pack")) {
            BukkitImplDeprecations.playerResourcePackMech.warn(mechanism.context);
            String pack = mechanism.getValue().asString();
            int pipe = pack.indexOf(124);
            if (pipe > 0) {
                Iterator hash = pack.substring(pipe + 1);
                pack = pack.substring(0, pipe);
                if (((String)((Object)hash)).length() != 40) {
                    Debug.echoError("Invalid resource_pack hash. Should be 40 characters of hexadecimal data.");
                    return;
                }
                byte[] hashData = new byte[20];
                for (int i = 0; i < 20; ++i) {
                    hashData[i] = (byte)Integer.parseInt(((String)((Object)hash)).substring(i * 2, i * 2 + 2), 16);
                }
                this.getPlayerEntity().setResourcePack(pack, hashData);
            } else {
                this.getPlayerEntity().setResourcePack(pack);
            }
        }
        if (mechanism.matches("saturation") && mechanism.requireFloat()) {
            if (this.isOnline()) {
                this.getPlayerEntity().setSaturation(mechanism.getValue().asFloat());
            } else {
                this.getNBTEditor().setSaturation(mechanism.getValue().asFloat());
            }
        }
        if (mechanism.matches("send_map") && mechanism.requireInteger()) {
            MapView map = Bukkit.getServer().getMap((int)((short)mechanism.getValue().asInt()));
            if (map != null) {
                this.getPlayerEntity().sendMap(map);
            } else {
                Debug.echoError("No map found for ID " + mechanism.getValue().asInt() + "!");
            }
        }
        if (mechanism.matches("food_level") && mechanism.requireInteger()) {
            this.setFoodLevel(mechanism.getValue().asInt());
        }
        if (mechanism.matches("bed_spawn_location") && mechanism.requireObject(LocationTag.class)) {
            this.setBedSpawnLocation(mechanism.valueAsType(LocationTag.class));
        }
        if (mechanism.matches("spawn_forced") && mechanism.requireBoolean()) {
            if (this.isOnline()) {
                NMSHandler.playerHelper.setSpawnForced(this.getPlayerEntity(), mechanism.getValue().asBoolean());
            } else {
                ImprovedOfflinePlayer editor = this.getNBTEditor();
                editor.setBedSpawnLocation(editor.getBedSpawnLocation(), mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("can_fly") && mechanism.requireBoolean()) {
            if (this.isOnline()) {
                this.getPlayerEntity().setAllowFlight(mechanism.getValue().asBoolean());
            } else {
                this.getNBTEditor().setAllowFlight(mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("fly_speed") && mechanism.requireFloat()) {
            this.setFlySpeed(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("flying") && mechanism.requireBoolean()) {
            boolean doFly = mechanism.getValue().asBoolean();
            if (doFly && !this.getPlayerEntity().getAllowFlight()) {
                Debug.echoError("Must adjust 'can_fly:true' before you can adjust 'flying:true'");
                return;
            }
            this.getPlayerEntity().setFlying(doFly);
        }
        if (mechanism.matches("sprinting") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setSprinting(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("gamemode") && mechanism.requireEnum(GameMode.class)) {
            this.setGameMode(GameMode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("kick")) {
            BukkitImplDeprecations.oldKickMech.warn(mechanism.context);
            this.getPlayerEntity().kickPlayer(mechanism.getValue().asString());
        }
        if (mechanism.matches("weather") && mechanism.requireEnum(WeatherType.class)) {
            BukkitImplDeprecations.oldWeatherMech.warn(mechanism.context);
            this.getPlayerEntity().setPlayerWeather(WeatherType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("reset_weather")) {
            BukkitImplDeprecations.oldWeatherMech.warn(mechanism.context);
            this.getPlayerEntity().resetPlayerWeather();
        }
        if (mechanism.matches("player_list_name")) {
            AdvancedTextImpl.instance.setPlayerListName(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("display_name")) {
            this.getPlayerEntity().setDisplayName(mechanism.getValue().asString());
            return;
        }
        if (mechanism.matches("show_workbench") && mechanism.requireObject(LocationTag.class)) {
            this.getPlayerEntity().openWorkbench((Location)mechanism.valueAsType(LocationTag.class), true);
            return;
        }
        if (mechanism.matches("location") && mechanism.requireObject(LocationTag.class)) {
            this.setLocation(mechanism.valueAsType(LocationTag.class));
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            BukkitImplDeprecations.oldTimeMech.warn(mechanism.context);
            this.getPlayerEntity().setPlayerTime((long)mechanism.getValue().asInt(), true);
        }
        if (mechanism.matches("freeze_time")) {
            BukkitImplDeprecations.oldTimeMech.warn(mechanism.context);
            if (mechanism.requireInteger("Invalid integer specified. Assuming current world time.")) {
                this.getPlayerEntity().setPlayerTime((long)mechanism.getValue().asInt(), false);
            } else {
                this.getPlayerEntity().setPlayerTime(this.getPlayerEntity().getWorld().getTime(), false);
            }
        }
        if (mechanism.matches("reset_time")) {
            BukkitImplDeprecations.oldTimeMech.warn(mechanism.context);
            this.getPlayerEntity().resetPlayerTime();
        }
        if (mechanism.matches("walk_speed") && mechanism.requireFloat()) {
            if (this.isOnline()) {
                this.getPlayerEntity().setWalkSpeed(mechanism.getValue().asFloat());
            } else {
                this.getNBTEditor().setWalkSpeed(mechanism.getValue().asFloat());
            }
        }
        if (mechanism.matches("exhaustion") && mechanism.requireFloat()) {
            if (this.isOnline()) {
                this.getPlayerEntity().setExhaustion(mechanism.getValue().asFloat());
            } else {
                this.getNBTEditor().setExhaustion(mechanism.getValue().asFloat());
            }
        }
        if (mechanism.matches("show_entity") && mechanism.requireObject(EntityTag.class)) {
            HideEntitiesHelper.unhideEntity(this.getPlayerEntity(), mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("hide_entity")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                ListTag split = mechanism.valueAsType(ListTag.class);
                if (split.size() > 0 && new ElementTag(split.get(0)).matchesType(EntityTag.class)) {
                    EntityTag entity = EntityTag.valueOf(split.get(0), mechanism.context);
                    if (!entity.isSpawnedOrValidForTag()) {
                        Debug.echoError("Can't hide the unspawned entity '" + split.get(0) + "'!");
                    } else {
                        HideEntitiesHelper.hideEntity(this.getPlayerEntity(), entity.getBukkitEntity());
                    }
                } else {
                    Debug.echoError("'" + split.get(0) + "' is not a valid entity!");
                }
            } else {
                Debug.echoError("Must specify an entity to hide!");
            }
        }
        if (mechanism.matches("hide_entities") && mechanism.hasValue()) {
            HideEntitiesHelper.PlayerHideMap map = HideEntitiesHelper.getPlayerMapFor(this.getUUID());
            String hideMe = mechanism.getValue().asString();
            map.matchersHidden.add(hideMe);
            if (this.isOnline()) {
                for (Entity ent : this.getPlayerEntity().getWorld().getEntities()) {
                    if (!new EntityTag(ent).tryAdvancedMatcher(hideMe) || !map.shouldHide(ent)) continue;
                    NMSHandler.entityHelper.sendHidePacket(this.getPlayerEntity(), ent);
                }
            }
        }
        if (mechanism.matches("unhide_entities") && mechanism.hasValue()) {
            HideEntitiesHelper.PlayerHideMap map = HideEntitiesHelper.getPlayerMapFor(this.getUUID());
            String unhideMe = mechanism.getValue().asString();
            map.matchersHidden.remove(unhideMe);
            if (map.matchersHidden.isEmpty() && map.entitiesHidden.isEmpty() && map.overridinglyShow.isEmpty()) {
                HideEntitiesHelper.playerHides.remove(this.getUUID());
            }
            if (this.isOnline()) {
                for (Entity ent : this.getPlayerEntity().getWorld().getEntities()) {
                    if (!new EntityTag(ent).tryAdvancedMatcher(unhideMe) || map.shouldHide(ent)) continue;
                    NMSHandler.entityHelper.sendShowPacket(this.getPlayerEntity(), ent);
                }
            }
        }
        if (mechanism.matches("show_boss_bar")) {
            BukkitImplDeprecations.oldBossBarMech.warn(mechanism.context);
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("\\|", 2);
                if (split.length == 2 && new ElementTag(split[0]).isDouble()) {
                    BossBarHelper.showSimpleBossBar(this.getPlayerEntity(), split[1], new ElementTag(split[0]).asDouble() * 0.005);
                } else {
                    BossBarHelper.showSimpleBossBar(this.getPlayerEntity(), split[0], 1.0);
                }
            } else {
                BossBarHelper.removeSimpleBossBar(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_experience")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("\\|", 2);
                if (split.length > 0 && new ElementTag(split[0]).isFloat()) {
                    if (split.length > 1 && new ElementTag(split[1]).isInt()) {
                        NMSHandler.packetHelper.showExperience(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), new ElementTag(split[1]).asInt());
                    } else {
                        NMSHandler.packetHelper.showExperience(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), this.getPlayerEntity().getLevel());
                    }
                } else {
                    Debug.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                NMSHandler.packetHelper.resetExperience(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_health")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("\\|", 3);
                if (split.length > 0 && new ElementTag(split[0]).isFloat()) {
                    if (split.length > 1 && new ElementTag(split[1]).isInt()) {
                        if (split.length > 2 && new ElementTag(split[2]).isFloat()) {
                            NMSHandler.packetHelper.showHealth(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), new ElementTag(split[1]).asInt(), new ElementTag(split[2]).asFloat());
                        } else {
                            NMSHandler.packetHelper.showHealth(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), new ElementTag(split[1]).asInt(), this.getPlayerEntity().getSaturation());
                        }
                    } else {
                        NMSHandler.packetHelper.showHealth(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), this.getPlayerEntity().getFoodLevel(), this.getPlayerEntity().getSaturation());
                    }
                } else {
                    Debug.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                NMSHandler.packetHelper.resetHealth(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_mount_health")) {
            double maximum;
            double current;
            if (!this.isOnline() || !this.getPlayerEntity().isInsideVehicle()) {
                mechanism.echoError("Cannot run fake_mount_health - player is offline or unmounted.");
                return;
            }
            Entity vehicle = this.getPlayerEntity().getVehicle();
            if (!(vehicle instanceof LivingEntity)) {
                mechanism.echoError("Cannot run fake_mount_health - vehicle is not a living entity.");
                return;
            }
            LivingEntity liveVehicle = (LivingEntity)vehicle;
            if (mechanism.hasValue()) {
                ListTag input = mechanism.valueAsType(ListTag.class);
                if (input.size() != 2) {
                    mechanism.echoError("Cannot run fake_mount_health - improper input.");
                    return;
                }
                current = new ElementTag(input.get(0)).asDouble();
                maximum = new ElementTag(input.get(1)).asDouble();
            } else {
                current = liveVehicle.getHealth();
                maximum = liveVehicle.getMaxHealth();
            }
            NMSHandler.packetHelper.showMobHealth(this.getPlayerEntity(), liveVehicle, current, maximum);
        }
        if (mechanism.matches("fake_entity_health") && mechanism.requireObject(MapTag.class)) {
            if (!this.isOnline()) {
                mechanism.echoError("Cannot run fake_entity_health - player is offline.");
                return;
            }
            MapTag map = mechanism.valueAsType(MapTag.class);
            EntityTag entity = map.getObjectAs("entity", EntityTag.class, mechanism.context);
            ElementTag healthObject = map.getElement("health");
            ElementTag maxObject = map.getElement("max");
            if (healthObject == null) {
                mechanism.echoError("Cannot run fake_entity_health - input map is missing 'health' key.");
                return;
            }
            double health = healthObject.asDouble();
            if (entity == null || !entity.isLivingEntity()) {
                mechanism.echoError("Cannot run fake_entity_health - entity is invalid or not living.");
                return;
            }
            double max = maxObject == null ? entity.getLivingEntity().getMaxHealth() : maxObject.asDouble();
            NMSHandler.packetHelper.showMobHealth(this.getPlayerEntity(), entity.getLivingEntity(), health, max);
        }
        if (mechanism.matches("fake_equipment") && !mechanism.getValue().asString().isEmpty()) {
            String[] split = mechanism.getValue().asString().split("\\|", 3);
            if (split.length > 0 && new ElementTag(split[0]).matchesType(EntityTag.class)) {
                String slot;
                String string = slot = split.length > 1 ? split[1].toUpperCase() : null;
                if (split.length > 1 && (new ElementTag(slot).matchesEnum(EquipmentSlot.class) || slot.equals("MAIN_HAND") || slot.equals("BOOTS"))) {
                    if (split.length > 2 && new ElementTag(split[2]).matchesType(ItemTag.class)) {
                        if (slot.equals("MAIN_HAND")) {
                            slot = "HAND";
                        } else if (slot.equals("BOOTS")) {
                            slot = "FEET";
                        }
                        NMSHandler.packetHelper.showEquipment(this.getPlayerEntity(), new ElementTag(split[0]).asType(EntityTag.class, mechanism.context).getLivingEntity(), EquipmentSlot.valueOf((String)slot), new ElementTag(split[2]).asType(ItemTag.class, mechanism.context).getItemStack());
                    } else if (split.length > 2) {
                        Debug.echoError("'" + split[2] + "' is not a valid ItemTag!");
                    }
                } else if (split.length > 1) {
                    Debug.echoError("'" + split[1] + "' is not a valid slot; must be HAND, OFF_HAND, BOOTS, LEGS, CHEST, or HEAD!");
                } else {
                    NMSHandler.packetHelper.resetEquipment(this.getPlayerEntity(), new ElementTag(split[0]).asType(EntityTag.class, mechanism.context).getLivingEntity());
                }
            } else {
                Debug.echoError("'" + split[0] + "' is not a valid EntityTag!");
            }
        }
        if (mechanism.matches("fov_multiplier")) {
            if (mechanism.hasValue() && mechanism.requireFloat()) {
                NMSHandler.packetHelper.setFieldOfView(this.getPlayerEntity(), mechanism.getValue().asFloat());
            } else {
                NMSHandler.packetHelper.setFieldOfView(this.getPlayerEntity(), Float.NaN);
            }
        }
        if (mechanism.matches("item_message")) {
            BukkitImplDeprecations.itemMessage.warn(mechanism.context);
            ItemChangeMessage.sendMessage(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("show_endcredits")) {
            NMSHandler.playerHelper.showEndCredits(this.getPlayerEntity());
        }
        if (mechanism.matches("show_demo")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                this.getPlayerEntity().showDemoScreen();
            } else {
                NMSHandler.packetHelper.showDemoScreen(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("spectator_target")) {
            if (mechanism.hasValue()) {
                this.getPlayerEntity().setGameMode(GameMode.SPECTATOR);
                this.getPlayerEntity().setSpectatorTarget(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
            } else if (this.getPlayerEntity().getGameMode() == GameMode.SPECTATOR) {
                this.getPlayerEntity().setSpectatorTarget(null);
            }
        }
        if (mechanism.matches("spectate") && mechanism.requireObject(EntityTag.class)) {
            NMSHandler.packetHelper.forceSpectate(this.getPlayerEntity(), mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("open_book")) {
            NMSHandler.packetHelper.openBook(this.getPlayerEntity(), EquipmentSlot.HAND);
        }
        if (mechanism.matches("open_offhand_book")) {
            NMSHandler.packetHelper.openBook(this.getPlayerEntity(), EquipmentSlot.OFF_HAND);
        }
        if (mechanism.matches("show_book") && mechanism.requireObject(ItemTag.class)) {
            ItemTag book = mechanism.valueAsType(ItemTag.class);
            if (!(book.getItemMeta() instanceof BookMeta)) {
                Debug.echoError("show_book mechanism must have a book as input.");
                return;
            }
            NMSHandler.packetHelper.showEquipment(this.getPlayerEntity(), (LivingEntity)this.getPlayerEntity(), EquipmentSlot.OFF_HAND, book.getItemStack());
            NMSHandler.packetHelper.openBook(this.getPlayerEntity(), EquipmentSlot.OFF_HAND);
            NMSHandler.packetHelper.showEquipment(this.getPlayerEntity(), (LivingEntity)this.getPlayerEntity(), EquipmentSlot.OFF_HAND, this.getPlayerEntity().getEquipment().getItemInOffHand());
        }
        if (mechanism.matches("resend_recipes")) {
            NMSHandler.playerHelper.resendRecipeDetails(this.getPlayerEntity());
            NMSHandler.playerHelper.resendDiscoveredRecipes(this.getPlayerEntity());
        }
        if (mechanism.matches("resend_discovered_recipes")) {
            NMSHandler.playerHelper.resendDiscoveredRecipes(this.getPlayerEntity());
        }
        if (mechanism.matches("quietly_discover_recipe")) {
            for (String keyText : mechanism.valueAsType(ListTag.class)) {
                NamespacedKey key = Utilities.parseNamespacedKey(keyText);
                NMSHandler.playerHelper.quietlyAddRecipe(this.getPlayerEntity(), key);
            }
        }
        if (mechanism.matches("discover_recipe")) {
            ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
            for (String key : mechanism.valueAsType(ListTag.class)) {
                keys.add(Utilities.parseNamespacedKey(key));
            }
            this.getPlayerEntity().discoverRecipes(keys);
        }
        if (mechanism.matches("forget_recipe")) {
            ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
            for (String key : mechanism.valueAsType(ListTag.class)) {
                keys.add(Utilities.parseNamespacedKey(key));
            }
            this.getPlayerEntity().undiscoverRecipes(keys);
        }
        if (mechanism.matches("edit_sign") && !NMSHandler.packetHelper.showSignEditor(this.getPlayerEntity(), mechanism.hasValue() ? (Location)mechanism.valueAsType(LocationTag.class) : null)) {
            Debug.echoError("Can't edit non-sign materials!");
        }
        if (mechanism.matches("tab_list_info")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("\\|", 2);
                if (split.length > 0) {
                    String header = split[0];
                    String footer = "";
                    if (split.length > 1) {
                        footer = split[1];
                    }
                    NMSHandler.packetHelper.showTabListHeaderFooter(this.getPlayerEntity(), header, footer);
                } else {
                    Debug.echoError("Must specify a header and footer to show!");
                }
            } else {
                NMSHandler.packetHelper.resetTabListHeaderFooter(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("sign_update")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("\\|", 2);
                if (LocationTag.matches(split[0]) && split.length > 1) {
                    ListTag lines = ListTag.valueOf(split[1], mechanism.context);
                    LocationTag location = LocationTag.valueOf(split[0], mechanism.context);
                    AdvancedTextImpl.instance.sendSignUpdate(this.getPlayerEntity(), location, lines.toArray(new String[4]));
                } else {
                    Debug.echoError("Must specify a valid location and at least one sign line!");
                }
            } else {
                Debug.echoError("Must specify a valid location and at least one sign line!");
            }
        }
        if (mechanism.matches("banner_update") && mechanism.getValue().asString().length() > 0) {
            String[] split = mechanism.getValue().asString().split("\\|");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (LocationTag.matches(split[0]) && split.length > 1) {
                for (int i = 1; i < split.length; ++i) {
                    String string = split[i];
                    if (i == 1 && !string.contains("/")) continue;
                    try {
                        List<String> splitList = CoreUtilities.split(string, '/', 2);
                        patterns.add(new Pattern(DyeColor.valueOf((String)splitList.get(0).toUpperCase()), PatternType.valueOf((String)splitList.get(1).toUpperCase())));
                        continue;
                    }
                    catch (Exception e) {
                        Debug.echoError("Could not apply pattern to banner: " + string);
                    }
                }
                LocationTag location = LocationTag.valueOf(split[0], mechanism.context);
                NMSHandler.packetHelper.showBannerUpdate(this.getPlayerEntity(), location, DyeColor.WHITE, patterns);
            } else {
                Debug.echoError("Must specify a valid location and pattern list!");
            }
        }
        if (mechanism.matches("stop_sound")) {
            String key;
            SoundCategory category;
            block216: {
                category = null;
                key = null;
                if (mechanism.hasValue()) {
                    try {
                        if (mechanism.getValue().matchesEnum(SoundCategory.class)) {
                            category = SoundCategory.valueOf((String)mechanism.getValue().asString().toUpperCase());
                            break block216;
                        }
                        key = mechanism.getValue().asString();
                    }
                    catch (Exception splitList) {}
                } else {
                    category = SoundCategory.MASTER;
                }
            }
            NMSHandler.playerHelper.stopSound(this.getPlayerEntity(), key, category);
        }
        if (mechanism.matches("action_bar")) {
            BukkitImplDeprecations.playerActionBarMech.warn(mechanism.context);
            this.getPlayerEntity().spigot().sendMessage(ChatMessageType.ACTION_BAR, FormattedTextHelper.parse(mechanism.getValue().asString(), ChatColor.WHITE));
        }
        if (mechanism.matches("update_advancements")) {
            NMSHandler.advancementHelper.update(this.getPlayerEntity());
        }
        if (mechanism.matches("name")) {
            String name = mechanism.getValue().asString();
            if (name.length() > 16) {
                Debug.echoError("Must specify a name with no more than 16 characters.");
            } else {
                NMSHandler.instance.getProfileEditor().setPlayerName(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin")) {
            String name = mechanism.getValue().asString();
            if (name.length() > 16) {
                Debug.echoError("Must specify a name with no more than 16 characters.");
            } else {
                NMSHandler.instance.getProfileEditor().setPlayerSkin(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin_blob")) {
            NMSHandler.instance.getProfileEditor().setPlayerSkinBlob(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("is_whitelisted") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setWhitelisted(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("is_op") && mechanism.requireBoolean()) {
            this.getOfflinePlayer().setOp(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("money") && mechanism.requireDouble() && Depends.economy != null) {
            BukkitImplDeprecations.oldMoneyMech.warn(mechanism.context);
            double bal = Depends.economy.getBalance(this.getOfflinePlayer());
            double goal = mechanism.getValue().asDouble();
            if (goal > bal) {
                Depends.economy.depositPlayer(this.getOfflinePlayer(), goal - bal);
            } else if (bal > goal) {
                Depends.economy.withdrawPlayer(this.getOfflinePlayer(), bal - goal);
            }
        }
        if (mechanism.matches("chat_prefix")) {
            if (Depends.chat == null) {
                Debug.echoError("Chat_Prefix mechanism invalid: No linked Chat plugin.");
                return;
            }
            Depends.chat.setPlayerPrefix(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("chat_suffix")) {
            if (Depends.chat == null) {
                Debug.echoError("Chat_Suffix mechanism invalid: No linked Chat plugin.");
                return;
            }
            Depends.chat.setPlayerSuffix(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("selected_npc") && Depends.citizens != null && mechanism.requireObject(NPCTag.class)) {
            ((NPCSelector)CitizensAPI.getDefaultNPCSelector()).select((CommandSender)this.getPlayerEntity(), mechanism.valueAsType(NPCTag.class).getCitizen());
        }
        if (mechanism.matches("hide_particles")) {
            if (!mechanism.hasValue()) {
                HideParticles.hidden.remove(this.getUUID());
            } else {
                NetworkInterceptHelper.enable();
                HashSet particles = HideParticles.hidden.computeIfAbsent(this.getUUID(), k -> new HashSet());
                Particle particle = Particle.valueOf((String)mechanism.getValue().asString().toUpperCase());
                particles.add(particle);
            }
        }
        if (mechanism.matches("send_to") && mechanism.hasValue()) {
            if (!this.isOnline()) {
                Debug.echoError("Cannot use send_to on offline player.");
                return;
            }
            Depends.bungeeSendPlayer(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("send_server_brand") && mechanism.hasValue()) {
            if (!this.isOnline()) {
                Debug.echoError("Cannot use send_server_brand on offline player.");
                return;
            }
            NMSHandler.packetHelper.sendBrand(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled()) {
            if (this.isOnline()) {
                new EntityTag((Entity)this.getPlayerEntity()).adjust(mechanism);
            } else {
                if (mechanism.matches("show_to_players")) {
                    HideEntitiesHelper.removeHide(null, this.getUUID());
                }
                if (mechanism.matches("hide_from_players")) {
                    HideEntitiesHelper.addHide(null, this.getUUID());
                }
            }
        }
    }

    @Override
    public boolean advancedMatches(String matcher) {
        return this.isOnline() && this.getDenizenEntity().tryAdvancedMatcher(matcher);
    }
}

