/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.io.File;
import java.io.FileOutputStream;

public class FileWriteCommand
extends AbstractCommand
implements Holdable {
    public FileWriteCommand() {
        this.setName("filewrite");
        this.setSyntax("filewrite [path:<path>] [data:<binary>]");
        this.setRequiredArguments(2, 2);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgPrefixed @ArgName(value="path") String path, @ArgPrefixed @ArgName(value="data") BinaryTag data) {
        if (!CoreConfiguration.allowFileWrite) {
            Debug.echoError(scriptEntry, "FileWrite disabled in Denizen/config.yml (refer to command documentation).");
            scriptEntry.setFinished(true);
            return;
        }
        File file = new File(DenizenCore.implementation.getDataFolder(), path);
        if (!DenizenCore.implementation.canWriteToFile(file)) {
            Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
            scriptEntry.setFinished(true);
            return;
        }
        try {
            if (!CoreConfiguration.filePathLimit.equals("none")) {
                File root = new File(DenizenCore.implementation.getDataFolder(), CoreConfiguration.filePathLimit);
                if (!file.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                    Debug.echoError("File path '" + path + "' is not within the config's restricted data file path.");
                    scriptEntry.setFinished(true);
                    return;
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            scriptEntry.setFinished(true);
            return;
        }
        Runnable runme = () -> {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(data.data);
                stream.close();
                scriptEntry.setFinished(true);
            }
            catch (Exception e) {
                Debug.echoError(scriptEntry, e);
                scriptEntry.setFinished(true);
            }
        };
        if (scriptEntry.shouldWaitFor()) {
            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(runme, 0.0f)));
        } else {
            runme.run();
        }
    }
}

