/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;

public class PlayerPlacesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag material;
    public ElementTag hand;
    public ItemTag item_in_hand;
    public BlockPlaceEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player places")) {
            return false;
        }
        return PlayerPlacesBlockScriptEvent.couldMatchBlockOrItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(2);
        if (!this.item_in_hand.tryAdvancedMatcher(mat) && !this.material.tryAdvancedMatcher(mat)) {
            return false;
        }
        if (!PlayerPlacesBlockScriptEvent.runGenericSwitchCheck(path, "using", this.hand.asString())) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
            case "old_material": {
                return new MaterialTag(this.event.getBlockReplacedState());
            }
            case "item_in_hand": {
                return this.item_in_hand;
            }
            case "hand": {
                return this.hand;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerPlacesBlock(BlockPlaceEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.hand = new ElementTag(event.getHand().name());
        this.material = new MaterialTag(event.getBlock());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item_in_hand = new ItemTag(event.getItemInHand());
        this.event = event;
        this.fire((Event)event);
    }
}

