/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;

public class BlockBuiltScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag old_material;
    public MaterialTag new_material;
    public BlockCanBuildEvent event;

    public BlockBuiltScriptEvent() {
        this.registerCouldMatcher("<block> being built (on <block>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String mat2 = path.eventArgLowerAt(4);
        if (mat2.length() > 0 && !this.old_material.tryAdvancedMatcher(mat2)) {
            return false;
        }
        if (!this.new_material.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determination = determinationObj.toString())).equals("buildable")) {
            this.cancelled = false;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public void cancellationChanged() {
        this.event.setBuildable(!this.cancelled);
        super.cancellationChanged();
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "new_material": {
                return this.new_material;
            }
            case "old_material": {
                return this.old_material;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockBuilt(BlockCanBuildEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.old_material = new MaterialTag(event.getBlock());
        this.new_material = new MaterialTag(event.getBlockData());
        this.cancelled = !event.isBuildable();
        this.event = event;
        this.fire((Event)event);
    }
}

