/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;

public class PlayerPreparesEnchantScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PrepareItemEnchantEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player prepares") || !path.eventArgLowerAt(3).equals("enchant")) {
            return false;
        }
        return PlayerPreparesEnchantScriptEvent.couldMatchItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!new ItemTag(this.event.getItem()).tryAdvancedMatcher(path.eventArgLowerAt(2))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determineLow;
        if (determinationObj instanceof ElementTag && (determineLow = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("offers:")) {
            ListTag offers = ListTag.valueOf(determineLow.substring("offers:".length()), this.getTagContext(path));
            if (offers.size() != this.event.getOffers().length) {
                Debug.echoError("Offer list size incorrect.");
                return false;
            }
            for (int i = 0; i < offers.size(); ++i) {
                MapTag map = MapTag.getMapFor(offers.getObject(i), this.getTagContext(path));
                this.event.getOffers()[i].setCost(map.getElement("cost").asInt());
                EnchantmentTag enchantment = map.getObjectAs("enchantment_type", EnchantmentTag.class, this.getTagContext(path));
                if (enchantment == null) {
                    enchantment = map.getObjectAs("enchantment", EnchantmentTag.class, this.getTagContext(path));
                }
                this.event.getOffers()[i].setEnchantment(enchantment.enchantment);
                this.event.getOffers()[i].setEnchantmentLevel(map.getElement("level").asInt());
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getEnchanter());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return new ItemTag(this.event.getItem());
            }
            case "location": {
                return new LocationTag(this.event.getEnchantBlock().getLocation());
            }
            case "bonus": {
                return new ElementTag(this.event.getEnchantmentBonus());
            }
            case "offers": {
                ListTag output = new ListTag();
                for (EnchantmentOffer offer : this.event.getOffers()) {
                    MapTag map = new MapTag();
                    map.putObject("cost", new ElementTag(offer.getCost()));
                    map.putObject("enchantment", new ElementTag(offer.getEnchantment().getKey().getKey()));
                    map.putObject("enchantment_type", new EnchantmentTag(offer.getEnchantment()));
                    map.putObject("level", new ElementTag(offer.getEnchantmentLevel()));
                    output.addObject(map);
                }
                return output;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEnchantItem(PrepareItemEnchantEvent event) {
        if (event.getInventory().getViewers().isEmpty()) {
            return;
        }
        this.event = event;
        this.fire((Event)event);
    }
}

