/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.enums.CustomEntityType;
import com.denizenscript.denizen.nms.interfaces.CustomEntity;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.entity.Gravity;
import com.denizenscript.denizen.utilities.entity.SpawnEntityHelper;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class DenizenEntityType {
    private static final Map<String, DenizenEntityType> registeredTypes = new HashMap<String, DenizenEntityType>();
    private final EntityType bukkitEntityType;
    private final String name;
    private final String lowercaseName;
    private final double gravity;
    public final CustomEntityType customEntityType;

    private DenizenEntityType(EntityType entityType) {
        this.bukkitEntityType = entityType;
        this.name = entityType.name();
        this.lowercaseName = CoreUtilities.toLowerCase(this.name);
        this.gravity = Gravity.getGravity(entityType);
        this.customEntityType = null;
    }

    private DenizenEntityType(String name, Class<? extends CustomEntity> entityType) {
        this(name, entityType, 0.115);
    }

    private DenizenEntityType(String name, Class<? extends CustomEntity> entityType, double gravity) {
        EntityType bukkitEntityType = EntityType.UNKNOWN;
        if (entityType != null) {
            for (EntityType type : EntityType.values()) {
                Class clazz = type.getEntityClass();
                if (clazz == null || !clazz.isAssignableFrom(entityType)) continue;
                bukkitEntityType = type;
                break;
            }
        }
        this.bukkitEntityType = bukkitEntityType;
        this.name = name.toUpperCase();
        this.lowercaseName = CoreUtilities.toLowerCase(name);
        this.gravity = gravity;
        this.customEntityType = CustomEntityType.valueOf(name.toUpperCase());
    }

    public Entity spawnNewEntity(Location location, ArrayList<Mechanism> mechanisms, String scriptName) {
        try {
            if (this.name.equals("DROPPED_ITEM")) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                    itemStack = mechanism.valueAsType(ItemTag.class).getItemStack();
                    break;
                }
                return location.getWorld().dropItem(location, itemStack);
            }
            if (!this.isCustom()) {
                return SpawnEntityHelper.spawn(location, this.bukkitEntityType, mechanisms, scriptName);
            }
            switch (this.customEntityType) {
                case FAKE_ARROW: {
                    return NMSHandler.customEntityHelper.spawnFakeArrow(location);
                }
                case FAKE_PLAYER: {
                    if (!Settings.packetInterception()) break;
                    String name = null;
                    String skin = null;
                    String blob = null;
                    for (Mechanism mechanism : new ArrayList<Mechanism>(mechanisms)) {
                        if (mechanism.matches("name")) {
                            name = mechanism.getValue().asString();
                            mechanisms.remove(mechanism);
                        } else if (mechanism.matches("skin")) {
                            skin = mechanism.getValue().asString();
                            mechanisms.remove(mechanism);
                        } else if (mechanism.matches("skin_blob")) {
                            blob = mechanism.getValue().asString();
                            mechanisms.remove(mechanism);
                        }
                        if (name == null || skin == null && blob == null) continue;
                        break;
                    }
                    NetworkInterceptHelper.enable();
                    return NMSHandler.customEntityHelper.spawnFakePlayer(location, name, skin, blob, true);
                }
                case ITEM_PROJECTILE: {
                    BukkitImplDeprecations.itemProjectile.warn();
                    ItemStack itemStack = new ItemStack(Material.STONE);
                    for (Mechanism mechanism : mechanisms) {
                        if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                        itemStack = mechanism.valueAsType(ItemTag.class).getItemStack();
                    }
                    return NMSHandler.customEntityHelper.spawnItemProjectile(location, itemStack);
                }
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public double getGravity() {
        return this.gravity;
    }

    public EntityType getBukkitEntityType() {
        return this.bukkitEntityType;
    }

    public static void registerEntityType(String name, Class<? extends CustomEntity> entityType) {
        registeredTypes.put(name.toUpperCase(), new DenizenEntityType(name, entityType));
    }

    public static boolean isRegistered(String name) {
        return registeredTypes.containsKey(name.toUpperCase());
    }

    public static DenizenEntityType getByName(String name) {
        return registeredTypes.get(name.toUpperCase());
    }

    public static DenizenEntityType getByEntity(Entity entity) {
        if (entity instanceof CustomEntity) {
            return DenizenEntityType.getByName(((CustomEntity)entity).getEntityTypeName());
        }
        return DenizenEntityType.getByName(entity.getType().name());
    }

    public boolean isCustom() {
        return this.customEntityType != null;
    }

    public String toString() {
        return this.getName();
    }

    static {
        for (EntityType entityType : EntityType.values()) {
            registeredTypes.put(entityType.name(), new DenizenEntityType(entityType));
        }
    }
}

