/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public abstract class BracedCommand
extends AbstractCommand {
    public static List<BracedData> getBracedCommands(ScriptEntry scriptEntry) {
        return BracedCommand.getBracedCommands(scriptEntry, true);
    }

    public static List<ScriptEntry> getBracedCommandsDirect(ScriptEntry scriptEntry, ScriptEntry copyFrom) {
        if (scriptEntry == null) {
            return null;
        }
        List<BracedData> bracedSet = scriptEntry.getBracedSet();
        if (bracedSet == null) {
            List<Object> contents = scriptEntry.getInsideList();
            if (contents == null) {
                return null;
            }
            List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(contents, scriptEntry.getScript() == null ? null : scriptEntry.getScript().getContainer(), scriptEntry.entryData);
            BracedData bd = new BracedData();
            bd.key = "base";
            bd.args = new ArrayList<String>();
            bd.value = entries;
            bracedSet = new ArrayList<BracedData>(1);
            bracedSet.add(bd);
            scriptEntry.setBracedSet(bracedSet);
        }
        if (bracedSet.isEmpty()) {
            return null;
        }
        BracedData bd = bracedSet.get(0);
        ArrayList<ScriptEntry> toReturn = new ArrayList<ScriptEntry>(bd.value.size());
        for (ScriptEntry sEntry : bd.value) {
            ScriptEntry newEntry = sEntry.clone();
            newEntry.copyFrom(copyFrom);
            newEntry.entryData.scriptEntry = newEntry;
            toReturn.add(newEntry);
        }
        return toReturn;
    }

    public static List<BracedData> getBracedCommands(ScriptEntry scriptEntry, boolean duplicate) {
        if (scriptEntry == null) {
            return null;
        }
        List<BracedData> entryBracedSet = scriptEntry.getBracedSet();
        if (entryBracedSet != null) {
            if (!duplicate) {
                return entryBracedSet;
            }
            ArrayList<BracedData> res = new ArrayList<BracedData>(entryBracedSet.size());
            try {
                for (BracedData bd : entryBracedSet) {
                    BracedData newbd = new BracedData();
                    newbd.entry = scriptEntry;
                    newbd.key = bd.key;
                    newbd.value = new ArrayList<ScriptEntry>(bd.value.size());
                    for (ScriptEntry sEntry : bd.value) {
                        ScriptEntry newEntry = sEntry.clone();
                        newEntry.entryData.transferDataFrom(scriptEntry.entryData);
                        newEntry.entryData.scriptEntry = newEntry;
                        newbd.value.add(newEntry);
                    }
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoDebug((Debuggable)scriptEntry, "Wrangling braced command args: " + bd.key);
                    }
                    newbd.args = bd.args;
                    res.add(newbd);
                }
            }
            catch (Exception e) {
                Debug.echoError(scriptEntry, e);
            }
            return res;
        }
        List<Object> contents = scriptEntry.getInsideList();
        if (contents != null) {
            List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(contents, scriptEntry.getScript() == null ? null : scriptEntry.getScript().getContainer(), scriptEntry.entryData);
            BracedData bd = new BracedData();
            bd.entry = scriptEntry;
            bd.key = "base";
            bd.args = new ArrayList<String>();
            bd.value = entries;
            ArrayList<BracedData> bracedSections = new ArrayList<BracedData>(1);
            bracedSections.add(bd);
            scriptEntry.setBracedSet(bracedSections);
            return BracedCommand.getBracedCommands(scriptEntry);
        }
        ArrayList<BracedData> bracedSections = new ArrayList<BracedData>();
        TreeMap commandList = new TreeMap();
        int bracesEntered = 0;
        boolean newCommand = true;
        boolean waitingForDash = false;
        if (CoreConfiguration.debugVerbose) {
            Debug.echoDebug((Debuggable)scriptEntry, "Starting getBracedCommands...");
            Debug.echoDebug((Debuggable)scriptEntry, "...with first command name: " + scriptEntry.getCommandName());
            Debug.echoDebug((Debuggable)scriptEntry, "...with first command arguments: " + scriptEntry.getOriginalArguments());
            Debug.echoDebug((Debuggable)scriptEntry, "Entry found: " + scriptEntry.getCommandName());
        }
        List<String> argList = scriptEntry.getOriginalArguments();
        String bracesName = scriptEntry.getCommandName().toUpperCase();
        ArrayList<String> bracesArgs = new ArrayList<String>();
        bracesArgs.add(bracesName);
        int startArg = -1;
        for (int i = 0; i < argList.size(); ++i) {
            String arg = argList.get(i);
            if (!arg.equals("{")) continue;
            startArg = i;
            break;
        }
        if (startArg == -1) {
            return null;
        }
        if (scriptEntry.getScript() != null) {
            Deprecations.oldBraceSyntax.warn(scriptEntry);
        }
        int tStart = -1;
        int tEnd = -1;
        for (int i = startArg; i < argList.size(); ++i) {
            String arg = argList.get(i);
            if (CoreConfiguration.debugVerbose) {
                Debug.echoDebug((Debuggable)scriptEntry, "Arg found: " + arg);
            }
            if (arg.equals("{")) {
                tEnd = ++bracesEntered == 1 && bracedSections.size() != 0 ? i - 1 : -1;
                newCommand = false;
                boolean bl = waitingForDash = bracesEntered == 1;
                if (CoreConfiguration.debugVerbose) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Opened brace; " + bracesEntered + " now");
                }
                if (bracesEntered <= 1) continue;
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
                continue;
            }
            if (arg.equals("}")) {
                --bracesEntered;
                newCommand = false;
                if (CoreConfiguration.debugVerbose) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Closed brace; " + bracesEntered + " now");
                }
                if (bracesEntered > 0) {
                    ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
                    continue;
                }
                BracedData bd = new BracedData();
                bd.entry = scriptEntry;
                bd.key = bracesName;
                if (bracedSections.contains(bd)) {
                    Debug.echoError(scriptEntry, "You may not have braced commands with the same arguments.");
                    break;
                }
                ArrayList<ScriptEntry> bracesSection = new ArrayList<ScriptEntry>();
                for (ArrayList command : commandList.values()) {
                    if (command.isEmpty()) {
                        if (!CoreConfiguration.debugVerbose) continue;
                        Debug.echoError(scriptEntry, "Empty command?");
                        continue;
                    }
                    String cmd = (String)command.get(0);
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoDebug((Debuggable)scriptEntry, "Calculating " + cmd);
                    }
                    command.remove(0);
                    int lineNum = 1;
                    if (cmd.length() > 2 && cmd.charAt(0) == ScriptBuilder.LINE_PREFIX_CHAR && cmd.charAt(cmd.length() - 1) == ScriptBuilder.LINE_PREFIX_CHAR) {
                        lineNum = Integer.parseInt(cmd.substring(1, cmd.length() - 1));
                        cmd = (String)command.get(0);
                        command.remove(0);
                    }
                    String[] args = new String[command.size()];
                    args = command.toArray(args);
                    ScriptEntry newEntry = new ScriptEntry(cmd, args, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
                    newEntry.internal.lineNumber = lineNum;
                    newEntry.internal.originalLine = newEntry.toString();
                    bracesSection.add(newEntry);
                    bracesSection.get((int)(bracesSection.size() - 1)).entryData.transferDataFrom(scriptEntry.entryData);
                    if (!CoreConfiguration.debugVerbose) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "Command added: " + cmd + ", with " + args.length + " arguments");
                }
                if (CoreConfiguration.debugVerbose) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Adding section " + bracesName + " with " + tStart + " to " + tEnd);
                }
                bd.args = bracesArgs;
                bd.aStart = tStart;
                bd.aEnd = tEnd;
                bd.value = bracesSection;
                bracedSections.add(bd);
                bracesName = "";
                bracesArgs = new ArrayList();
                commandList = new TreeMap();
                tEnd = -1;
                tStart = i + 1;
                continue;
            }
            if (newCommand && bracesEntered == 1) {
                commandList.put(commandList.size(), new ArrayList());
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
                newCommand = false;
                if (!CoreConfiguration.debugVerbose) continue;
                Debug.echoDebug((Debuggable)scriptEntry, "Treating as new command");
                continue;
            }
            if (arg.equals("-") && bracesEntered == 1) {
                newCommand = true;
                waitingForDash = false;
                if (!CoreConfiguration.debugVerbose) continue;
                Debug.echoDebug((Debuggable)scriptEntry, "Assuming following is a new command");
                continue;
            }
            if (bracesEntered == 0) {
                bracesName = bracesName + arg + " ";
                bracesArgs.add(arg);
                continue;
            }
            if (waitingForDash) {
                Debug.echoError(scriptEntry, "Malformed braced section! Missing a - symbol!");
                break;
            }
            newCommand = false;
            ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
            if (!CoreConfiguration.debugVerbose) continue;
            Debug.echoDebug((Debuggable)scriptEntry, "Adding to the command");
        }
        scriptEntry.setBracedSet(bracedSections);
        return BracedCommand.getBracedCommands(scriptEntry);
    }

    public static class BracedData {
        public String key;
        public List<String> args;
        public List<ScriptEntry> value;
        public int aStart;
        public int aEnd;
        public ScriptEntry entry;

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BracedData) {
                return this.key.equals(((BracedData)o).key);
            }
            return false;
        }
    }
}

