/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.FallingBlock;

public class EntityAutoExpire
implements Property {
    public static final String[] handledMechs = new String[]{"auto_expire"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof FallingBlock;
    }

    public static EntityAutoExpire getFrom(ObjectTag _entity) {
        if (!EntityAutoExpire.describes(_entity)) {
            return null;
        }
        return new EntityAutoExpire((EntityTag)_entity);
    }

    private EntityAutoExpire(EntityTag _entity) {
        this.entity = _entity;
    }

    public static void registerTags() {
        PropertyParser.registerTag(EntityAutoExpire.class, ElementTag.class, "auto_expire", (attribute, object) -> new ElementTag(object.doesAutoExpire()), new String[0]);
    }

    public FallingBlock getFallingBlock() {
        return (FallingBlock)this.entity.getBukkitEntity();
    }

    public boolean doesAutoExpire() {
        return this.getFallingBlock().doesAutoExpire();
    }

    @Override
    public String getPropertyString() {
        return this.doesAutoExpire() ? null : "false";
    }

    @Override
    public String getPropertyId() {
        return "auto_expire";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("auto_expire") && mechanism.requireBoolean()) {
            this.getFallingBlock().shouldAutoExpire(mechanism.getValue().asBoolean());
        }
    }
}

