/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;

public class EntityBodyArrows
implements Property {
    public static final String[] handledMechs = new String[]{"body_arrows", "clear_body_arrows"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        return object instanceof EntityTag && ((EntityTag)object).isLivingEntity();
    }

    public static EntityBodyArrows getFrom(ObjectTag object) {
        if (!EntityBodyArrows.describes(object)) {
            return null;
        }
        return new EntityBodyArrows((EntityTag)object);
    }

    private EntityBodyArrows(EntityTag entity) {
        this.entity = entity;
    }

    private int getBodyArrows() {
        return this.entity.getLivingEntity().getArrowsInBody();
    }

    private void setBodyArrows(int numArrows) {
        this.entity.getLivingEntity().setArrowsInBody(numArrows);
    }

    @Override
    public String getPropertyString() {
        int numArrows = this.getBodyArrows();
        return numArrows == 0 ? null : String.valueOf(numArrows);
    }

    @Override
    public String getPropertyId() {
        return "body_arrows";
    }

    public static void register() {
        PropertyParser.registerTag(EntityBodyArrows.class, ElementTag.class, "body_arrows", (attribute, object) -> new ElementTag(object.getBodyArrows()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("body_arrows") && mechanism.requireInteger()) {
            this.setBodyArrows(mechanism.getValue().asInt());
        }
        if (mechanism.matches("clear_body_arrows")) {
            this.setBodyArrows(0);
        }
    }
}

