/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;

public class EntityFlower
implements Property {
    public static final String[] handledTags = new String[]{"flower"};
    public static final String[] handledMechs = new String[]{"flower"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof Bee;
    }

    public static EntityFlower getFrom(ObjectTag entity) {
        if (!EntityFlower.describes(entity)) {
            return null;
        }
        return new EntityFlower((EntityTag)entity);
    }

    private EntityFlower(EntityTag entity) {
        this.entity = entity;
    }

    public Bee getBee() {
        return (Bee)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        if (this.getBee().getFlower() == null) {
            return null;
        }
        return new LocationTag(this.getBee().getFlower()).identify();
    }

    @Override
    public String getPropertyId() {
        return "flower";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("flower")) {
            if (this.getBee().getFlower() == null) {
                return null;
            }
            return new LocationTag(this.getBee().getFlower()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("flower")) {
            if (mechanism.hasValue() && mechanism.requireObject(LocationTag.class)) {
                this.getBee().setFlower((Location)mechanism.valueAsType(LocationTag.class));
            } else {
                this.getBee().setFlower(null);
            }
        }
    }
}

