/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;

public class InventoryTrades
implements Property {
    public static final String[] handledMechs = new String[]{"trades"};
    InventoryTag inventory;

    public static boolean describes(ObjectTag inventory) {
        return inventory instanceof InventoryTag && ((InventoryTag)inventory).getInventory() instanceof MerchantInventory;
    }

    public static InventoryTrades getFrom(ObjectTag inventory) {
        if (!InventoryTrades.describes(inventory)) {
            return null;
        }
        return new InventoryTrades((InventoryTag)inventory);
    }

    public InventoryTrades(InventoryTag inventory) {
        this.inventory = inventory;
    }

    public ListTag getTradeRecipes() {
        ArrayList<TradeTag> recipes = new ArrayList<TradeTag>();
        for (MerchantRecipe recipe : ((MerchantInventory)this.inventory.getInventory()).getMerchant().getRecipes()) {
            recipes.add(new TradeTag(recipe).duplicate());
        }
        return new ListTag((Collection<? extends ObjectTag>)recipes);
    }

    @Override
    public String getPropertyString() {
        ListTag recipes = this.getTradeRecipes();
        if (recipes.isEmpty()) {
            return null;
        }
        return recipes.identify();
    }

    @Override
    public String getPropertyId() {
        return "trades";
    }

    public static void register() {
        PropertyParser.registerTag(InventoryTrades.class, ListTag.class, "trades", (attribute, inventory) -> inventory.getTradeRecipes(), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("trades") && mechanism.requireInteger()) {
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            for (TradeTag recipe : mechanism.valueAsType(ListTag.class).filter(TradeTag.class, mechanism.context)) {
                recipes.add(recipe.getRecipe());
            }
            ((MerchantInventory)this.inventory.getInventory()).getMerchant().setRecipes(recipes);
        }
    }
}

