/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;

public class ItemMap
implements Property {
    public static final String[] handledMechs = new String[]{"map", "full_render", "map_locked", "map_center"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == Material.FILLED_MAP;
    }

    public static ItemMap getFrom(ObjectTag _item) {
        if (!ItemMap.describes(_item)) {
            return null;
        }
        return new ItemMap((ItemTag)_item);
    }

    private ItemMap(ItemTag _item) {
        this.item = _item;
    }

    public static void register() {
        PropertyParser.registerTag(ItemMap.class, ElementTag.class, "map", (attribute, object) -> {
            if (!object.hasMapId()) {
                return null;
            }
            return new ElementTag(object.getMapId());
        }, new String[0]);
        PropertyParser.registerTag(ItemMap.class, ElementTag.class, "map_scale", (attribute, object) -> {
            if (!object.hasMapId()) {
                return null;
            }
            MapMeta map = object.getMapMeta();
            if (!map.hasMapView()) {
                return null;
            }
            return new ElementTag(map.getMapView().getScale().getValue());
        }, new String[0]);
        PropertyParser.registerTag(ItemMap.class, ElementTag.class, "map_locked", (attribute, object) -> {
            if (!object.hasMapId()) {
                return null;
            }
            MapMeta map = object.getMapMeta();
            if (!map.hasMapView()) {
                return null;
            }
            return new ElementTag(map.getMapView().isLocked());
        }, new String[0]);
        PropertyParser.registerTag(ItemMap.class, LocationTag.class, "map_center", (attribute, object) -> {
            if (!object.hasMapId()) {
                return null;
            }
            MapMeta map = object.getMapMeta();
            if (!map.hasMapView()) {
                return null;
            }
            MapView mapView = map.getMapView();
            return new LocationTag(mapView.getWorld(), (double)mapView.getCenterX(), 0.0, mapView.getCenterZ());
        }, new String[0]);
    }

    public MapMeta getMapMeta() {
        return (MapMeta)this.item.getItemMeta();
    }

    public boolean hasMapId() {
        return this.getMapMeta().hasMapId();
    }

    public int getMapId() {
        MapMeta map = this.getMapMeta();
        return map.hasMapId() ? map.getMapId() : 0;
    }

    public void setMapId(int id) {
        MapMeta map = this.getMapMeta();
        map.setMapId(id);
        this.item.setItemMeta((ItemMeta)map);
    }

    @Override
    public String getPropertyString() {
        return this.hasMapId() ? String.valueOf(this.getMapId()) : null;
    }

    @Override
    public String getPropertyId() {
        return "map";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("map") && mechanism.requireInteger()) {
            this.setMapId(mechanism.getValue().asInt());
        }
        if (mechanism.matches("full_render")) {
            boolean worked;
            int xMin = 0;
            int zMin = 0;
            int xMax = 128;
            int zMax = 128;
            if (mechanism.hasValue()) {
                List<String> input = CoreUtilities.split(mechanism.getValue().asString(), ',');
                if (input.size() != 4) {
                    mechanism.echoError("Invalid input to 'full_render' - must be a set of 4 comma separated integers.");
                    return;
                }
                try {
                    xMin = Math.max(Integer.parseInt(input.get(0)), 0);
                    zMin = Math.max(Integer.parseInt(input.get(1)), 0);
                    xMax = Math.min(Integer.parseInt(input.get(2)), 128);
                    zMax = Math.min(Integer.parseInt(input.get(3)), 128);
                }
                catch (NumberFormatException ex) {
                    mechanism.echoError("Invalid input to 'full_render' - found comma separated list of 4 values, but not all values are integers: " + ex.getMessage());
                }
            }
            if (!(worked = NMSHandler.itemHelper.renderEntireMap(this.getMapId(), xMin, zMin, xMax, zMax))) {
                mechanism.echoError("Cannot render map: ID doesn't exist. Has the map never been displayed?");
            }
        }
        if (mechanism.matches("map_locked") && mechanism.requireBoolean()) {
            MapMeta meta = this.getMapMeta();
            if (!meta.hasMapView()) {
                mechanism.echoError("Map is not loaded/rendered.");
                return;
            }
            meta.getMapView().setLocked(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("map_center") && mechanism.requireObject(LocationTag.class)) {
            LocationTag loc = mechanism.valueAsType(LocationTag.class);
            MapMeta meta = this.getMapMeta();
            if (!meta.hasMapView()) {
                mechanism.echoError("Map is not loaded/rendered.");
                return;
            }
            MapView mapView = meta.getMapView();
            mapView.setCenterX(loc.getBlockX());
            mapView.setCenterZ(loc.getBlockZ());
            if (loc.getWorld() != null) {
                mapView.setWorld(loc.getWorld());
            }
        }
    }
}

